/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeAdapter;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.Version;
import oracle.ide.composite.AbstractCompositeFileElementProxy;
import oracle.ide.composite.CompositeFileElementProxy;
import oracle.ide.composite.CompositeFileElementRegistry;
import oracle.ide.config.ClientSetting;
import oracle.ide.config.DTCache;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.ContentSet;
import oracle.ide.model.ContentType;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.NodeListener;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.Recognizer;
import oracle.ide.model.RelativeDirectoryContextFolder;
import oracle.ide.model.Subject;
import oracle.ide.model.TextNode;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.net.URLPath;
import oracle.ide.util.Assert;
import oracle.ide.util.MnemonicSolver;
import oracle.ide.vcs.VCS;
import oracle.ide.vcs.VCSEvent;
import oracle.ide.vcs.VCSListener;
import oracle.ide.vcs.VCSManager;
import oracle.ide.vcs.VCSRegistry;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.Copyable;
import oracle.jdeveloper.compare.StreamDecoder;
import oracle.jdeveloper.history.CustomFilterSubstitution;
import oracle.jdeveloper.history.HistoryManager;
import oracle.jdeveloper.resource.VCSArb;
import oracle.jdeveloper.vcs.changelist.ChangeListEventQueue;
import oracle.jdeveloper.vcs.patch.ApplyPatchCommand;
import oracle.jdeveloper.vcs.patch.CreatePatchCommand;
import oracle.jdeveloper.vcs.patch.PatchController;
import oracle.jdeveloper.vcs.properties.PropertiesCommand;
import oracle.jdeveloper.vcs.properties.PropertiesController;
import oracle.jdeveloper.vcs.properties.PropertiesPanel;
import oracle.jdeveloper.vcs.properties.PropertiesPanelRegistry;
import oracle.jdeveloper.vcs.properties.VersionPropertiesPanelProvider;
import oracle.jdeveloper.vcs.share.ShareCommand;
import oracle.jdeveloper.vcs.spi.VCSContextMenuListener;
import oracle.jdeveloper.vcs.spi.VCSControlCache;
import oracle.jdeveloper.vcs.spi.VCSEventBus;
import oracle.jdeveloper.vcs.spi.VCSExtension;
import oracle.jdeveloper.vcs.spi.VCSFileEventSender;
import oracle.jdeveloper.vcs.spi.VCSHistoryProvider;
import oracle.jdeveloper.vcs.spi.VCSMenuConstants;
import oracle.jdeveloper.vcs.spi.VCSNodeUpdate;
import oracle.jdeveloper.vcs.spi.VCSPropertyDescriptor;
import oracle.jdeveloper.vcs.spi.VCSPropertyKey;
import oracle.jdeveloper.vcs.spi.VCSPropertyMap;
import oracle.jdeveloper.vcs.spi.VCSStatusCache;
import oracle.jdeveloper.vcs.util.VCSBufferUtils;
import oracle.jdeveloper.vcs.util.VCSExtensionUtils;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdeveloper.vcs.util.VCSIdeEventRecorder;
import oracle.jdeveloper.vcs.util.VCSKeyboardUtils;
import oracle.jdeveloper.vcs.util.VCSMenuUtils;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdeveloper.vcs.versionhistory.VersionHistoryAddin;
import oracle.jdeveloper.vcs.versionhistory.VersionHistoryCommand;
import oracle.jdeveloper.vcs.versionhistory.VersionHistoryNode;
import oracle.jdevimpl.vcs.cmd.ConfigureVersioningCommand;
import oracle.jdevimpl.vcs.util.GeneralPropertiesPanel;

public class VCSManagerImpl
extends VCSManager
implements Addin {
    public static final float VERSIONING_MENU_WEIGHT = MenuConstants.WEIGHT_ADDITIONAL_MENU;
    public static final String VCS_EXTENSION_ID = "oracle.jdeveloper.vcs";
    private static final String ACCELERATOR_FILE = "oracle/jdevimpl/vcs/accelerators.xml";
    private Map<VCSListener, URLFilter> _vcsListeners;
    private CompositeFileElementProxy _compositeFileElementProxy;
    private Collection<ContextMenuListener> _contextMenuListeners;
    private static DTCache _dtcache;

    private void $init$() {
        this._vcsListeners = new LinkedHashMap<VCSListener, URLFilter>();
        this._contextMenuListeners = new ArrayList<ContextMenuListener>();
    }

    public VCSManagerImpl() {
        this.$init$();
    }

    public void initialize() {
        VCSManager.setVCSManager((VCSManager)this);
        VCSIdeEventRecorder.initialize();
        VCSFileEventSender.setFileEventSender(new 1());
        this.initializeVersioningProperties();
        this.registerPatchSupportHandlers();
        this.registerPropertiesHandlers();
        EditorManager.getEditorManager().register((EditorAddin)new VersionHistoryAddin(), new Class[]{VersionHistoryNode.class});
        Node.addNodeListenerForTypeHierarchy(Node.class, (NodeListener)new 2());
        Ide.addIdeListener((IdeListener)new 3());
        Node.addNodeListenerForTypeHierarchy(Project.class, (NodeListener)new 4());
        IdeActions.getFileSaveAction().addController((Controller)new 5());
        this._compositeFileElementProxy = new 6(null);
        CompositeFileElementRegistry.registerCompositeProxy((CompositeFileElementProxy)this._compositeFileElementProxy);
        JMenu versioningMenu = Ide.getMenubar().createMenu(VCSArb.getString(33), new Integer(VCSArb.getMnemonic(59)), VERSIONING_MENU_WEIGHT);
        MenuManager.putJMenu((String)"Versioning", (JMenu)versioningMenu);
        Ide.getMenubar().add((Component)versioningMenu);
        Ide.addIdeListener((IdeListener)new 7());
        IdeAction.find((int)51).addController((Controller)new 8());
        VCSMenuUtils.installContextMenuListener(new 9(null));
        Ide.getVersionInfo().addComponent(VCSArb.getString(42), Version.VER_FULL);
    }

    private void solveMnemonics(JMenu menu, JMenuItem[] fixedItems, JMenuItem[] solveItems) {
        if (solveItems == null) {
            int i = 0;
            while (i < menu.getItemCount()) {
                if (fixedItems == null || !Arrays.asList(fixedItems).contains(menu.getItem(i))) {
                    menu.getItem(i).setMnemonic(0);
                }
                ++i;
            }
        } else {
            JMenuItem[] jMenuItemArray = solveItems;
            int n = 0;
            while (n < jMenuItemArray.length) {
                JMenuItem menuItem = jMenuItemArray[n];
                menuItem.setMnemonic(0);
                ++n;
            }
        }
        MnemonicSolver mnemonicSolver = new MnemonicSolver();
        int i = 0;
        while (i < menu.getItemCount()) {
            JMenuItem menuItem = menu.getItem(i);
            if (menuItem.getMnemonic() != 0) {
                mnemonicSolver.addMenuLabel(menuItem, menuItem.getText(), true);
            } else if (solveItems == null || Arrays.asList(solveItems).contains(menuItem)) {
                mnemonicSolver.addMenuLabel(menuItem, menuItem.getText(), false);
            }
            ++i;
        }
        mnemonicSolver.solve();
    }

    private void initializeVersioningProperties() {
        HashMap propertiesMap;
        VCSPropertyMap properties = (VCSPropertyMap)ClientSetting.findOrCreate((String)VCS_EXTENSION_ID).getData("VersioningSettings");
        HashMap defaultsMap = null;
        HashMap hashMap = propertiesMap = defaultsMap != null ? defaultsMap : new HashMap();
        if (properties != null) {
            propertiesMap.putAll(properties.getMap());
        } else {
            properties = new VCSPropertyMap();
        }
        properties.setMap(propertiesMap);
        ClientSetting.findOrCreate((String)VCS_EXTENSION_ID).putData("VersioningSettings", (Copyable)properties);
    }

    public boolean canCheckOut(URL url) {
        return URLFileSystem.isReadOnly((URL)url) && this.isVersioned(url) && !VCSFileSystemUtils.isNonEditable(url);
    }

    public boolean checkOutNode(Node node) {
        return this.checkOutNode(node, null);
    }

    public boolean checkOutNode(Node node, CommandProcessor processor) {
        String checkOutCommand = this.getCheckOutCommand(node);
        if (checkOutCommand == null) {
            return false;
        }
        Command command = CommandProcessor.createCommand((String)checkOutCommand, (Context)new Context(node));
        try {
            boolean bl = (processor != null ? processor.invoke(command) : this.invokeCommand(command)) == 0;
            return bl;
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
            boolean bl = false;
            return bl;
        }
    }

    public String getCheckOutCommand(Node node) {
        VCSExtension vcs = VCSExtensionUtils.getActiveExtension(node.getURL());
        return vcs != null ? vcs.getCheckOutCommand() : null;
    }

    public boolean setReadWrite(URL[] urls) {
        HashMap<VCSExtension, ArrayList<URL>> urlMap = new HashMap<VCSExtension, ArrayList<URL>>();
        URL[] uRLArray = urls;
        int n = 0;
        while (n < uRLArray.length) {
            VCSExtension vcs;
            URL url = uRLArray[n];
            if (!VCSFileSystemUtils.isNonEditable(url) && (vcs = VCSExtensionUtils.getActiveExtension(url)) != null) {
                ArrayList<URL> vcsUrls = (ArrayList<URL>)urlMap.get(vcs);
                if (vcsUrls == null) {
                    vcsUrls = new ArrayList<URL>();
                    urlMap.put(vcs, vcsUrls);
                }
                vcsUrls.add(url);
            }
            ++n;
        }
        for (Map.Entry entry : urlMap.entrySet()) {
            try {
                if (((VCSExtension)entry.getKey()).setReadWrite(((Collection)entry.getValue()).toArray(new URL[0]))) continue;
                boolean bl = false;
                return bl;
            }
            catch (Exception e) {
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    public boolean isAutoCheckOutEnabled(URL url) {
        VCSExtension extension = VCSExtensionUtils.getActiveExtension(url);
        if (extension == null) {
            return true;
        }
        VCSPropertyDescriptor propertyDescriptor = extension.getPropertyDescriptor();
        if (propertyDescriptor == null || Arrays.asList(propertyDescriptor.getPropertyKeys()).indexOf("autoCheckouts") < 0) {
            return true;
        }
        String clientSettingsKey = propertyDescriptor.getClientSettingsKey();
        String propertyDataKey = propertyDescriptor.getPropertyDataKey();
        VCSPropertyMap propertyMap = null;
        propertyMap = clientSettingsKey == null ? (VCSPropertyMap)((Object)Ide.getSettings().getData(propertyDataKey)) : (VCSPropertyMap)ClientSetting.findOrCreate((String)clientSettingsKey).getData(propertyDataKey);
        Boolean autoCheckouts = propertyMap != null ? propertyMap.getMap().get("autoCheckouts") : null;
        if (autoCheckouts == null) {
            autoCheckouts = VCSPropertyKey.DEFAULT_AUTO_CHECKOUTS;
        }
        return autoCheckouts;
    }

    public boolean isVersioned(URL url) {
        VCSExtension vcs = VCSExtensionUtils.getActiveExtension(url);
        if (vcs == null) {
            return false;
        }
        try {
            boolean bl = vcs.getStatus(new URL[]{url})[0].isVersioned();
            return bl;
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
            boolean bl = false;
            return bl;
        }
    }

    public void validateStatus(URL url) {
        this.validateStatus(new 10(this, url));
    }

    public void validateStatus(URLFilter filter) {
        for (String id : VCSRegistry.keySet()) {
            VCSStatusCache statusCache;
            VCS vcs = VCSRegistry.lookup((String)id);
            if (!(vcs instanceof VCSExtension) || (statusCache = ((VCSExtension)vcs).getStatusCache()) == null) continue;
            statusCache.clear(filter);
        }
    }

    public void addVCSListener(VCSListener listener, URLFilter filter) {
        this._vcsListeners.put(listener, filter);
        if (filter != null) {
            VCSBufferUtils.registerTrackingFilter(filter);
        }
    }

    public void removeVCSListener(VCSListener listener) {
        URLFilter filter = this._vcsListeners.get(listener);
        this._vcsListeners.remove(listener);
        if (filter != null) {
            VCSBufferUtils.deregisterTrackingFilter(filter);
        }
    }

    public String getVersionName(URL url) {
        VCSExtension vcs = VCSExtensionUtils.getActiveExtension(url);
        return vcs != null ? vcs.getVersionName(url) : null;
    }

    public void registerWorkspaceArtifact(String path) {
        ChangeListEventQueue.registerWorkspaceArtifact(path);
    }

    public void deregisterWorkspaceArtifact(String path) {
        ChangeListEventQueue.deregisterWorkspaceArtifact(path);
    }

    public boolean containsConflicts(URL url) {
        VCSExtension vcs = VCSExtensionUtils.getActiveExtension(url);
        if (vcs != null) {
            return vcs.isConflictsStatus(url);
        }
        return false;
    }

    public InputStream openConflictsStreamAsContributor(URL url) throws IOException {
        return VCSManagerImpl.openConflictsStreamAsContributor(url, StreamDecoder.getDefaultEncoding((URL)url));
    }

    public static final InputStream openConflictsStreamAsContributor(URL url, String charsetName) throws IOException {
        InputStream inputStream = null;
        BufferedReader br = null;
        BufferedWriter bw = null;
        try {
            inputStream = URLFileSystem.openInputStream((URL)url);
            InputStreamReader isr = new InputStreamReader(inputStream, charsetName);
            StringWriter sw = new StringWriter();
            br = new BufferedReader(isr);
            bw = new BufferedWriter(sw);
            int conflictSection = 0;
            block21: while (br.ready()) {
                String line = br.readLine();
                switch (conflictSection) {
                    case 0: {
                        if (!line.startsWith("<<<<<<<")) break;
                        conflictSection = 1;
                        continue block21;
                    }
                    case 1: {
                        if (!line.startsWith("=======")) break;
                        conflictSection = 2;
                        continue block21;
                    }
                    case 2: {
                        if (!line.startsWith(">>>>>>>")) continue block21;
                        conflictSection = 0;
                        continue block21;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                bw.write(line);
                bw.newLine();
            }
            bw.close();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(sw.getBuffer().toString().getBytes(charsetName));
            return byteArrayInputStream;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            } else if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    private void fireNodeReloaded(Node node) {
        VCSNodeUpdate nodeUpdate = new VCSNodeUpdate(node, VCSNodeUpdate.RELOADED);
        VCSEventBus.send(nodeUpdate);
    }

    private void fireNodeRenamed(Node node, URL oldUrl) {
        VCSNodeUpdate nodeUpdate = new VCSNodeUpdate(node, VCSNodeUpdate.RENAMED);
        nodeUpdate.setOldURL(oldUrl);
        VCSEventBus.send(nodeUpdate);
    }

    private void fireNodeSaved(Node node) {
        VCSNodeUpdate nodeUpdate = new VCSNodeUpdate(node, VCSNodeUpdate.SAVED);
        VCSEventBus.send(nodeUpdate);
    }

    private void _fireVCSEvent(URL[] urls, int eventType) {
        VCSEvent vcse = new VCSEvent((Object)this, urls, eventType);
        VCSListener[] l = this._vcsListeners.keySet().toArray(new VCSListener[0]);
        int i = l.length - 1;
        while (i >= 0) {
            URLFilter filter = this._vcsListeners.get(l[i]);
            if (filter == null) {
                if (eventType != 3) {
                    l[i].notifyEvent(vcse);
                }
            } else {
                int j = 0;
                while (j < urls.length) {
                    if (filter.accept(urls[j])) {
                        l[i].notifyEvent(vcse);
                        break;
                    }
                    ++j;
                }
            }
            --i;
        }
    }

    private void registerPatchSupportHandlers() {
        IdeAction applyPatchAction = IdeAction.get((int)ApplyPatchCommand.APPLY_PATCH_CMD_ID, (String)ApplyPatchCommand.APPLY_PATCH_CMD, (String)VCSArb.getString(118), (String)VCSArb.getString(33), null, (ResourceBundle)VCSArb.getInstance(), null, null, (boolean)false);
        applyPatchAction.putValue("Category", (Object)VCSMenuConstants.ACTION_CATEGORY_VERSIONING);
        applyPatchAction.putValue("NoCtxName", (Object)VCSArb.getString(190));
        applyPatchAction.addController((Controller)new PatchController());
    }

    private void registerPropertiesHandlers() {
        IdeAction propertiesAction = IdeAction.get((int)PropertiesCommand.PROPERTIES_CMD_ID, (String)PropertiesCommand.PROPERTIES_CMD, (String)VCSArb.getString(123), (String)VCSArb.getString(33), null, (ResourceBundle)VCSArb.getInstance(), null, null, (boolean)false);
        propertiesAction.putValue("Category", (Object)VCSMenuConstants.ACTION_CATEGORY_VERSIONING);
        propertiesAction.putValue("NoCtxName", (Object)VCSArb.getString(190));
        propertiesAction.addController((Controller)new PropertiesController());
        PropertiesPanelRegistry.registerPanelProvider(new 11());
    }

    private int invokeCommand(Command command) {
        if (command == null) {
            return 9;
        }
        try {
            int n = command.doit();
            return n;
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
            int n = -1;
            return n;
        }
    }

    public void registerContextMenuListener(ContextMenuListener l) {
        this._contextMenuListeners.add(l);
    }

    public void deregisterContextMenuListener(ContextMenuListener l) {
        this._contextMenuListeners.remove(l);
    }

    public ContextMenuListener[] getContextMenuListeners() {
        return this._contextMenuListeners.toArray(new ContextMenuListener[0]);
    }

    public static void _test_SelectNoSystem() {
    }

    public static void _test_SelectSystem(VCS vcs) {
        vcs.toString();
    }

    public static DTCache getDTCache() {
        if (Boolean.getBoolean("vcs.nodtcache")) {
            if (_dtcache == null) {
                _dtcache = new DTCache();
            }
            return _dtcache;
        }
        return Ide.getDTCache();
    }

    static void mav$_fireVCSEvent(VCSManagerImpl vCSManagerImpl, URL[] uRLArray, int n) {
        vCSManagerImpl._fireVCSEvent(uRLArray, n);
    }

    static void mav$fireNodeRenamed(VCSManagerImpl vCSManagerImpl, Node node, URL uRL) {
        vCSManagerImpl.fireNodeRenamed(node, uRL);
    }

    static void mav$fireNodeReloaded(VCSManagerImpl vCSManagerImpl, Node node) {
        vCSManagerImpl.fireNodeReloaded(node);
    }

    static void mav$fireNodeSaved(VCSManagerImpl vCSManagerImpl, Node node) {
        vCSManagerImpl.fireNodeSaved(node);
    }

    static void mav$solveMnemonics(VCSManagerImpl vCSManagerImpl, JMenu jMenu, JMenuItem[] jMenuItemArray, JMenuItem[] jMenuItemArray2) {
        vCSManagerImpl.solveMnemonics(jMenu, jMenuItemArray, jMenuItemArray2);
    }

    final class 1
    extends VCSFileEventSender {
        protected void fireVCSEvent(URL[] urls, int eventType) {
            VCSManagerImpl.mav$_fireVCSEvent(VCSManagerImpl.this, urls, eventType);
        }
    }

    final class 2
    extends NodeListener {
        public void nodeSaved(NodeEvent ne) {
            VCSManagerImpl.mav$fireNodeSaved(VCSManagerImpl.this, ne.getNode());
        }

        public void nodeReverted(NodeEvent ne) {
            VCSManagerImpl.mav$fireNodeReloaded(VCSManagerImpl.this, ne.getNode());
        }

        public void nodeRenamed(NodeEvent ne, URL oldURL, URL newURL) {
            VCSManagerImpl.mav$fireNodeRenamed(VCSManagerImpl.this, ne.getNode(), oldURL);
        }
    }

    final class 3
    extends IdeAdapter {
        public final void addinsLoaded(IdeEvent idee) {
            IdeAction[] actions = new IdeAction[]{IdeAction.find((int)CreatePatchCommand.CREATE_PATCH_CMD_ID), IdeAction.find((int)ApplyPatchCommand.APPLY_PATCH_CMD_ID)};
            VCSKeyboardUtils.addKeyStrokeContext(actions, VCSMenuConstants.ACTION_CATEGORY_VERSIONING);
            VCSKeyboardUtils.addAcceleratorDefinitionFile(this.getClass().getClassLoader(), VCSManagerImpl.ACCELERATOR_FILE);
            this.mapExtensionToContentType(".stf", ContentType.BINARY);
            this.mapExtensionToContentType(".oxm_asn", ContentType.TEXT);
            this.mapExtensionToContentType(".oxm_oco", ContentType.TEXT);
            this.mapExtensionToContentType(".oxm_ucl", ContentType.TEXT);
            this.mapExtensionToContentType(".oxm_uin", ContentType.TEXT);
            this.mapExtensionToContentType(".oxm_ude", ContentType.TEXT);
            Ide.removeIdeListener((IdeListener)this);
        }

        private void mapExtensionToContentType(String extension, ContentType contentType) {
            if (Recognizer.getContentTypeForExtension((String)extension) == null) {
                Recognizer.mapExtensionToContentType((String)extension, (ContentType)contentType);
            }
        }
    }

    final class 4
    extends NodeListener {
        public void nodeOpened(NodeEvent ne) {
            Project project = (Project)ne.getNode();
            VCSListenerImpl l = new VCSListenerImpl(project);
            project.getTransientProperties().put("VCSListener", l);
            VCSManagerImpl.this.addVCSListener(l, null);
        }

        public void nodeClosed(NodeEvent ne) {
            Project project = (Project)ne.getNode();
            VCSListener l = (VCSListener)project.getTransientProperties().remove("VCSListener");
            VCSManagerImpl.this.removeVCSListener(l);
        }
    }

    final class 5
    implements Controller {
        public boolean handleEvent(IdeAction action, Context context) {
            return this.canSave(context) ^ true;
        }

        private boolean canSave(Context context) {
            URL url = VCSModelUtils.getLocatableURL(context.getNode());
            return url == null || context.getNode() instanceof TextNode || !VCSManagerImpl.this.containsConflicts(url);
        }

        public boolean update(IdeAction action, Context context) {
            if (!this.canSave(context)) {
                action.setEnabled(false);
                return true;
            }
            return false;
        }
    }

    final class 6
    extends AbstractCompositeFileElementProxy {
        public Class getCompositeElementClass() {
            return RelativeDirectoryContextFolder.class;
        }

        public URL[] getCompositeFileURLs(Element compositeElement) {
            URL locatableUrl;
            RelativeDirectoryContextFolder directoryContextFolder = (RelativeDirectoryContextFolder)compositeElement;
            URLPath rootDirectoryPath = directoryContextFolder.getRootDirectories();
            String relativePath = directoryContextFolder.getRelativePath();
            URL uRL = locatableUrl = compositeElement instanceof Locatable ? ((Locatable)compositeElement).getURL() : null;
            if (relativePath == null) {
                URL[] uRLArray;
                if (locatableUrl != null) {
                    URL[] uRLArray2 = new URL[1];
                    uRLArray = uRLArray2;
                    uRLArray2[0] = locatableUrl;
                } else {
                    uRLArray = new URL[]{};
                }
                return uRLArray;
            }
            URL[] urls = new URL[rootDirectoryPath.size()];
            int i = 0;
            Iterator itr = rootDirectoryPath.iterator();
            while (itr.hasNext()) {
                urls[i++] = URLFactory.newDirURL((URL)((URL)itr.next()), (String)relativePath);
            }
            return urls;
        }

        public 6(String string) {
            super(string);
        }
    }

    final class 7
    extends IdeAdapter {
        public void addinsLoaded(IdeEvent idee) {
            IdeAction configureAction = IdeAction.get((int)ConfigureVersioningCommand.CONFIGURE_VERSIONING_CMD_ID, (String)ConfigureVersioningCommand.CONFIGURE_VERSIONING_CMD, (String)VCSArb.getString(141));
            VCSMenuUtils.addMenuItem(VCSMenuUtils.getMainVersioningMenu(), configureAction.getCommandId(), 99.9f);
            VCSMenuUtils.addMenuItem(VCSMenuUtils.getMainVersioningMenu(), CreatePatchCommand.CREATE_PATCH_CMD_ID, 100.0f);
            VCSMenuUtils.addMenuItem(VCSMenuUtils.getMainVersioningMenu(), ApplyPatchCommand.APPLY_PATCH_CMD_ID, 100.0f);
            ArrayList<JMenu> solverMenuItems = new ArrayList<JMenu>();
            for (String id : VCSRegistry.keySet()) {
                VCS vcs = VCSRegistry.lookup((String)id);
                if (!(vcs instanceof VCSExtension)) continue;
                VCSExtension extension = (VCSExtension)vcs;
                try {
                    if (!extension.canActivate()) {
                        Assert.println((String)("VCSExtension.canActivate() failure: " + extension.getId()));
                        continue;
                    }
                    long t1 = System.currentTimeMillis();
                    extension.activate();
                    Assert.printTiming((long)(System.currentTimeMillis() - t1), (String)("VCSExtension.activate(): " + extension.getId()), (String)"");
                    JMenu menu = MenuManager.getJMenu((String)("Versioning" + '.' + extension.getId()));
                    if (menu != VCSMenuUtils.getMainVersioningMenu()) {
                        solverMenuItems.add(menu);
                    }
                    this.installVersionHistory(extension, menu);
                }
                catch (Exception e) {
                    extension.getExceptionHandler().handleException(e);
                }
            }
            if (!solverMenuItems.isEmpty()) {
                VCSManagerImpl.mav$solveMnemonics(VCSManagerImpl.this, VCSMenuUtils.getMainVersioningMenu(), null, solverMenuItems.toArray(new JMenuItem[0]));
            }
            VCSControlCache.getInstance().fireControlStateChanged(null);
            Ide.removeIdeListener((IdeListener)this);
        }

        private void installVersionHistory(VCSExtension extension, JMenu menu) {
            VCSHistoryProvider historyProvider = extension.getHistoryProvider();
            HistoryManager historyManager = HistoryManager.getHistoryManager();
            if (historyProvider == null || historyManager == null) {
                return;
            }
            if (historyProvider.getHistoryProvider() != null) {
                historyManager.registerProvider(historyProvider.getHistoryProvider());
            }
            if (historyProvider.getVersioningUserSubstitution() != null) {
                historyManager.getCustomFilterManager().registerSubstitution((CustomFilterSubstitution)historyProvider.getVersioningUserSubstitution());
            }
            if (menu == null) {
                return;
            }
            if (historyProvider.getVersionHistoryAction() != null) {
                IdeAction versionHistoryAction = historyProvider.getVersionHistoryAction();
                VCSMenuUtils.installVersionHistoryMenuItem(menu, versionHistoryAction != null ? versionHistoryAction.getCommandId() : VersionHistoryCommand.VERSION_HISTORY_CMD_ID);
            }
            if (historyProvider.getVersionTreeAction() != null) {
                IdeAction versionTreeAction = historyProvider.getVersionTreeAction();
                VCSMenuUtils.installVersionHistoryMenuItem(menu, versionTreeAction.getCommandId());
            }
        }
    }

    final class 8
    implements Controller {
        public boolean handleEvent(IdeAction action, Context context) {
            if (action.getCommandId() == 51) {
                VCSControlCache.getInstance().fireControlStateChanged(null);
            }
            return false;
        }

        public boolean update(IdeAction action, Context context) {
            return false;
        }
    }

    final class 9
    extends VCSContextMenuListener {
        protected Component[] getContextMenuItems(Context context) {
            Component[] componentArray;
            IdeAction action = null;
            if (context.getNode() instanceof Workspace) {
                action = ShareCommand.getShareApplicationAction();
            }
            if (context.getNode() instanceof Project) {
                action = ShareCommand.getShareProjectAction();
            }
            if (action == null) {
                return null;
            }
            action.updateAction(context);
            if (action.isEnabled()) {
                Component[] componentArray2 = new Component[1];
                componentArray = componentArray2;
                componentArray2[0] = VCSMenuUtils.createMenuItem(action.getCommandId(), 0.1f);
            } else {
                componentArray = null;
            }
            return componentArray;
        }

        public 9(String string) {
            super(string);
        }
    }

    final class 10
    implements URLFilter {
        private final /* synthetic */ URL v$url;
        final /* synthetic */ VCSManagerImpl this$0;

        public boolean accept(URL url2) {
            return this.v$url.equals(url2);
        }

        public 10(VCSManagerImpl vCSManagerImpl, URL uRL) {
            this.v$url = uRL;
            this.this$0 = vCSManagerImpl;
        }
    }

    private class VCSListenerImpl
    implements VCSListener {
        private final Project _project;

        VCSListenerImpl(Project project) {
            this._project = project;
        }

        public void notifyEvent(VCSEvent event) {
            int eventType = event.getEventType();
            switch (eventType) {
                case 1: {
                    Assert.println((String)"VCSManager: VCSEvent.FILE_CREATED");
                    ContentSet contents = ProjectContent.getInstance((PropertyStorage)this._project).getAllContents();
                    URL[] addedURLs = event.getURLs();
                    int i = 0;
                    while (i < addedURLs.length) {
                        if (contents.canHaveMember(addedURLs[i])) {
                            try {
                                Node node = NodeFactory.findOrCreate((URL)addedURLs[i]);
                                this.fireAddedEvent(node);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        ++i;
                    }
                    break;
                }
                case 2: {
                    Assert.println((String)"VCSManager: VCSEvent.FILE_DELETED");
                    ContentSet contents = ProjectContent.getInstance((PropertyStorage)this._project).getAllContents();
                    URL[] removedURLs = event.getURLs();
                    int i = 0;
                    while (i < removedURLs.length) {
                        Node removedNode;
                        if (contents.canHaveMember(removedURLs[i]) && (removedNode = NodeFactory.find((URL)removedURLs[i])) != null) {
                            this.fireRemovedEvent(removedNode);
                        }
                        ++i;
                    }
                    break;
                }
                case 4: {
                    Assert.println((String)"VCSManager: VCSEvent.FILE_STRUCTURE_CHANGED");
                    ContentSet contents = ProjectContent.getInstance((PropertyStorage)this._project).getAllContents();
                    URL[] structureChangeURLs = event.getURLs();
                    URL projectDir = URLFileSystem.getParent((URL)this._project.getURL());
                    int i = 0;
                    while (i < structureChangeURLs.length) {
                        if (contents.canHaveMember(structureChangeURLs[i])) {
                            this.fireStructureChangedEvent();
                        } else if (URLFileSystem.equals((URL)structureChangeURLs[i], (URL)projectDir)) {
                            this.fireStructureChangedEvent();
                        }
                        ++i;
                    }
                    break;
                }
            }
        }

        private void fireAddedEvent(Node addedNode) {
            UpdateMessage.fireChildAdded((Subject)this._project, (Element)addedNode);
        }

        private void fireRemovedEvent(Node removedNode) {
            UpdateMessage updateMessage = new UpdateMessage(UpdateMessage.CHILD_REMOVED, (Object)this);
            updateMessage.getRemoveObjects().add(removedNode);
            this._project.notifyObservers((Object)this._project, updateMessage);
        }

        private void fireStructureChangedEvent() {
            UpdateMessage.fireStructureChanged((Subject)this._project);
        }
    }

    final class 11
    extends VersionPropertiesPanelProvider {
        public String getTabName() {
            return VCSArb.getString(12);
        }

        public float getTabWeight() {
            return Float.MAX_VALUE;
        }

        public boolean isDefaultTab() {
            return false;
        }

        public boolean isHandled(Context context) {
            if (!super.isHandled(context)) {
                return false;
            }
            URL url = this.getContextURL(context);
            return url != null && VCSManagerImpl.this.isVersioned(url);
        }

        public PropertiesPanel createPanel(Context context) {
            return new GeneralPropertiesPanel(this.getContextElement(context), this.getContextURL(context));
        }
    }
}

