/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.generic;

import java.io.IOException;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.config.ClientSetting;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.explorer.IconOverlayTracker;
import oracle.ide.model.Displayable;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.net.URLFileSystemHelperDecorator;
import oracle.ide.net.URLFilter;
import oracle.ide.panels.Navigable;
import oracle.ide.util.FastStringBuffer;
import oracle.javatools.history.HistoryProperty;
import oracle.javatools.util.Copyable;
import oracle.jdeveloper.history.HistoryProvider;
import oracle.jdeveloper.vcs.changelist.ChangeList;
import oracle.jdeveloper.vcs.generic.CheckOutProvider;
import oracle.jdeveloper.vcs.generic.MultiChangeList;
import oracle.jdeveloper.vcs.generic.PendingChangesAdapter;
import oracle.jdeveloper.vcs.generic.ProfileListener;
import oracle.jdeveloper.vcs.generic.StatusResolver;
import oracle.jdeveloper.vcs.generic.VCSActionInfo;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.properties.PropertiesPanelRegistry;
import oracle.jdeveloper.vcs.spi.VCSCommandStyle;
import oracle.jdeveloper.vcs.spi.VCSCommandType;
import oracle.jdeveloper.vcs.spi.VCSEBComponent;
import oracle.jdeveloper.vcs.spi.VCSEventBus;
import oracle.jdeveloper.vcs.spi.VCSExtension;
import oracle.jdeveloper.vcs.spi.VCSExtensionInformation;
import oracle.jdeveloper.vcs.spi.VCSHistoryProvider;
import oracle.jdeveloper.vcs.spi.VCSMenuConstants;
import oracle.jdeveloper.vcs.spi.VCSOverlayItemProducer;
import oracle.jdeveloper.vcs.spi.VCSPropertyCustomizer;
import oracle.jdeveloper.vcs.spi.VCSPropertyDescriptor;
import oracle.jdeveloper.vcs.spi.VCSPropertyMap;
import oracle.jdeveloper.vcs.spi.VCSSingleNodeObserver;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.spi.VCSStatusCache;
import oracle.jdeveloper.vcs.spi.VCSStatusFilter;
import oracle.jdeveloper.vcs.spi.VCSURLFileSystemHelper;
import oracle.jdeveloper.vcs.util.VCSDefaultUtils;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdeveloper.vcs.util.VCSKeyboardUtils;
import oracle.jdeveloper.vcs.util.VCSMenuUtils;
import oracle.jdeveloper.vcs.util.VCSNavigableUtils;
import oracle.jdevimpl.vcs.generic.GLazyIdeAction;
import oracle.jdevimpl.vcs.generic.GenericContextMenuListener;
import oracle.jdevimpl.vcs.generic.GenericController;
import oracle.jdevimpl.vcs.generic.GenericHistoryAction;
import oracle.jdevimpl.vcs.generic.GenericHistoryProvider;
import oracle.jdevimpl.vcs.generic.GenericPropertyPanelProvider;
import oracle.jdevimpl.vcs.generic.SearchNavigable;
import oracle.jdevimpl.vcs.generic.VCSActionInfoImpl;
import oracle.jdevimpl.vcs.generic.changelist.ChangeListViewId;
import oracle.jdevimpl.vcs.generic.changelist.GenericChangeListDockableFactory;
import oracle.jdevimpl.vcs.generic.changelist.StatusBasedChangeListWindow;
import oracle.jdevimpl.vcs.generic.changelist.StatusBasedMultiChangeList;
import oracle.jdevimpl.vcs.generic.changelist.ViewPendingChangesAction;
import oracle.jdevimpl.vcs.generic.profile.AbstractActionInfo;
import oracle.jdevimpl.vcs.generic.profile.ActionInfo;
import oracle.jdevimpl.vcs.generic.profile.ActionsInfo;
import oracle.jdevimpl.vcs.generic.profile.AutomaticActionInfo;
import oracle.jdevimpl.vcs.generic.profile.ChangeListInfo;
import oracle.jdevimpl.vcs.generic.profile.ClientSettingInfo;
import oracle.jdevimpl.vcs.generic.profile.EventBusInfo;
import oracle.jdevimpl.vcs.generic.profile.FileSystemHelperInfo;
import oracle.jdevimpl.vcs.generic.profile.FileSystemInfo;
import oracle.jdevimpl.vcs.generic.profile.HistoryProviderInfo;
import oracle.jdevimpl.vcs.generic.profile.PendingChangesInfo;
import oracle.jdevimpl.vcs.generic.profile.PreferencesInfo;
import oracle.jdevimpl.vcs.generic.profile.ProfileInfo;
import oracle.jdevimpl.vcs.generic.profile.PropertyProviderInfo;
import oracle.jdevimpl.vcs.generic.profile.SectionInfo;
import oracle.jdevimpl.vcs.generic.profile.SectionsInfo;
import oracle.jdevimpl.vcs.generic.profile.StatusInfo;
import oracle.jdevimpl.vcs.generic.profile.StatusesInfo;
import oracle.jdevimpl.vcs.generic.util.CandidateStatusFilter;
import oracle.jdevimpl.vcs.generic.util.RecognizedStatusFilter;
import oracle.jdevimpl.vcs.generic.util.UnrecognizedStatusFilter;
import oracle.jdevimpl.vcs.generic.util.UnversionedStatusFilter;
import oracle.jdevimpl.vcs.generic.util.VCSGenericUtil;
import oracle.jdevimpl.vcs.generic.util.VersionedStatusFilter;

public class GenericClient
extends VCSExtension
implements VCSProfile {
    private static final VCSStatus sUnrecognizedStatus;
    private static final String AUTO_OP_CHECKOUT_NODE = "CHECKOUT_NODE";
    private final Logger _logger;
    private URL _systemDirectory;
    private final ProfileInfo _profile;
    private ProfileListener _profileListener;
    private StatusResolver _statusResolver;
    private final Map _fsHelpers;
    private final Map _actionInfos;
    private VCSStatusCache _statusCache;
    private Controller _controller;
    private IdeAction[] _actions;
    private ContextMenuListener _contextMenuListener;
    private IconOverlayTracker _overlayTracker;
    private VCSExtensionInformation _clientInfo;
    private ChangeListener _propertyChangeListener;
    private CheckOutProvider _checkOutProvider;
    private VCSHistoryProvider _historyProvider;
    private boolean _canActivate;
    private final Collection _propProviders;
    private final Map _changeListsById;
    private final Map _changeListInfosById;
    private String _changeListViewID;
    private PendingChangesAdapter _pendingChangesAdapter;
    private ChangeList[] _changeLists;
    private VCSOverlayItemProducer _overlayProducer;
    private final Map _qualifiedDataKeys;
    static final /* synthetic */ boolean $assertionsDisabled;

    private void $init$() {
        this._fsHelpers = new HashMap(5);
        this._actionInfos = new HashMap(20);
        this._canActivate = true;
        this._propProviders = new ArrayList(5);
        this._changeListsById = new HashMap(10);
        this._changeListInfosById = new HashMap(10);
        this._qualifiedDataKeys = new HashMap(10);
    }

    public GenericClient(ProfileInfo profile) {
        this.$init$();
        this._logger = Logger.getLogger(profile.getID());
        this._profile = profile;
    }

    public void initialize() {
        long start = System.currentTimeMillis();
        try {
            try {
                super.initialize();
                this._logger.addHandler(this.createDefaultLogHandler());
                this._logger.setUseParentHandlers(false);
                this._statusResolver = this.createStatusResolver();
                this._profileListener = this.createProfileListener();
                this.initializeClientSettings();
                this.fireProfileInitialized();
            }
            catch (Exception e) {
                this._canActivate = false;
                this._logger.log(Level.SEVERE, "error initializing vcs profile " + this._profile.getID(), e);
            }
        }
        finally {
            if (this._canActivate) {
                this._logger.info("profile initialized in " + String.valueOf(System.currentTimeMillis() - start) + "ms");
            }
        }
    }

    public boolean isControlled(URL url) {
        URLFilter filter = this._profile.getFileSystem().getURLFilter("oracle.jdeveloper.vcs.filters.url.CONTROL");
        if (filter == null) {
            System.err.println(this.getId() + ": url-filter oracle.jdeveloper.vcs.filters.url.CONTROL undefined");
            return false;
        }
        return filter.accept(url);
    }

    public boolean canActivate() {
        return this._canActivate && this.fireCanActivate() && super.canActivate();
    }

    public void activate() {
        HistoryProviderInfo historyProviderInfo;
        long start = System.currentTimeMillis();
        try {
            this.initializePreferencePanels();
        }
        catch (ClassNotFoundException cfne) {
            this._logger.severe("unable to load preferences panel class");
        }
        this.initializeDefaultStatusFilters();
        this.activateOperations();
        VCSKeyboardUtils.addKeyStrokeContext(this._actions, this.getInformation().getShortLabel());
        this.activateMenus();
        this.activateEventBusComponents();
        VCSPropertyMap commonProperties = this.getData("oracle.jdeveloper.vcs.data.COMMON_SETTINGS");
        this._overlayProducer = this.createOverlayProducer();
        if (commonProperties != null) {
            this._propertyChangeListener = new ClientChangeListener(null);
            commonProperties.addChangeListener(this._propertyChangeListener);
            if (this._overlayProducer instanceof ChangeListener) {
                commonProperties.addChangeListener((ChangeListener)((Object)this._overlayProducer));
            }
            commonProperties.fireChangeEvent();
        }
        if (this._fsHelpers.isEmpty()) {
            for (FileSystemHelperInfo helperInfo : this._profile.getFileSystem().getHelpers()) {
                try {
                    Class helperClass = helperInfo.getHelperClass();
                    URLFileSystemHelper helperInstance = (URLFileSystemHelper)helperClass.newInstance();
                    if (helperInstance instanceof URLFileSystemHelperDecorator) {
                        VCSFileSystemUtils.registerDecorator(helperInfo.getProtocol(), (URLFileSystemHelperDecorator)helperInstance);
                    } else {
                        URLFileSystem.registerHelper((String)helperInfo.getProtocol(), (URLFileSystemHelper)helperInstance);
                    }
                    this._fsHelpers.put(helperInfo.getProtocol(), helperClass.newInstance());
                }
                catch (ClassNotFoundException cfne) {
                    this._logger.severe("unable to load filesystem helper class for protocol " + helperInfo.getProtocol());
                }
                catch (Exception e) {
                    this._logger.severe("unable to instantiate filesystem helper class for protocol " + helperInfo.getProtocol());
                }
            }
        }
        Iterator it = this._fsHelpers.entrySet().iterator();
        while (it.hasNext()) {
            Object helper = it.next().getValue();
            if (!(helper instanceof VCSURLFileSystemHelper)) continue;
            ((VCSURLFileSystemHelper)((Object)helper)).setEnabled(true);
        }
        this.manageOverlayTracker();
        if (this._checkOutProvider == null) {
            try {
                if (this._profile.getCheckOutClass() != null) {
                    this._checkOutProvider = (CheckOutProvider)this._profile.getCheckOutClass().newInstance();
                }
            }
            catch (ClassNotFoundException cfne) {
                this._logger.severe("unable to load checkout provider class");
            }
            catch (Exception e) {
                this._logger.severe("unable to instantiate checkout provider class");
            }
        }
        if ((historyProviderInfo = this._profile.getHistoryProvider()) != null) {
            IdeAction versionHistoryAction = GenericHistoryAction.getAction(this);
            1 historyActionInfo = new 1(this, historyProviderInfo);
            this._actionInfos.put(Ide.findCmdName((int)versionHistoryAction.getCommandId()), historyActionInfo);
            this._historyProvider = new VCSHistoryProvider(new GenericHistoryProvider(this, historyProviderInfo, this._profile.getClientInfo(), historyActionInfo), versionHistoryAction);
        }
        Collection propProviders = this._profile.getPropertyProvider();
        it = propProviders.iterator();
        while (it.hasNext()) {
            try {
                GenericPropertyPanelProvider provider = new GenericPropertyPanelProvider(this, (PropertyProviderInfo)((Object)it.next()));
                PropertiesPanelRegistry.registerPanelProvider(provider);
                this._propProviders.add(provider);
            }
            catch (ClassNotFoundException cnfe) {
                this._logger.log(Level.SEVERE, "unable to load property panel class " + cnfe.getMessage());
            }
        }
        PendingChangesInfo pcInfo = this._profile.getPendingChanges();
        if (pcInfo != null) {
            try {
                this.activatePendingChanges(pcInfo);
            }
            catch (Exception e) {
                this._logger.log(Level.SEVERE, "unable to activate pending changes support", e);
            }
        }
        this.fireProfileActivated();
        this._logger.info("profile activated in " + String.valueOf(System.currentTimeMillis() - start) + "ms");
    }

    public void shutdown() {
        long start = System.currentTimeMillis();
        try {
            this.fireProfileDestroyed();
        }
        finally {
            this._logger.info("profile destroyed in " + String.valueOf(System.currentTimeMillis() - start) + "ms");
        }
    }

    public VCSStatusCache getStatusCache() {
        if (this._statusCache == null) {
            try {
                this._statusCache = new 2();
            }
            catch (Exception e) {
                this._logger.severe("Unable to resolve statuses: " + e.getMessage());
                VCSStatusCache vCSStatusCache = null;
                return vCSStatusCache;
            }
        }
        return this._statusCache;
    }

    public String getID() {
        return this._profile.getID();
    }

    public String getId() {
        return this.getID();
    }

    public ProfileInfo getProfileInfo() {
        return this._profile;
    }

    public URLFilter getURLFilter() {
        return this.getURLFilter("oracle.jdeveloper.vcs.filters.url.DEFAULT");
    }

    public URLFilter getURLFilter(String id) {
        FileSystemInfo fsi = this._profile.getFileSystem();
        if (fsi != null) {
            return fsi.getURLFilter(id);
        }
        return null;
    }

    public VCSStatusFilter getStatusFilter(String id) {
        StatusesInfo si;
        FileSystemInfo fsi = this._profile.getFileSystem();
        if (fsi != null && (si = fsi.getStatuses()) != null) {
            return si.getStatusFilter(id);
        }
        return null;
    }

    public VCSExtensionInformation getInformation() {
        if (this._clientInfo == null) {
            this._clientInfo = new VCSExtensionInformation(new 3());
        }
        return this._clientInfo;
    }

    public String getCheckOutCommand() {
        ActionsInfo ops = this._profile.getActions();
        AutomaticActionInfo op = ops.getAutomaticAction(AUTO_OP_CHECKOUT_NODE);
        return op != null ? op.getActionClassName() : null;
    }

    public VCSPropertyDescriptor getPropertyDescriptor() {
        return new VCSPropertyDescriptor(this._profile.getID(), this.getQualifiedDataKey("oracle.jdeveloper.vcs.data.COMMON_SETTINGS"), new String[]{"useOverlays", "autoCheckouts", "property_operation_timeout"});
    }

    public boolean setReadWrite(URL url) throws Exception {
        return this._checkOutProvider != null ? this._checkOutProvider.checkOut(url) : super.setReadWrite(url);
    }

    public boolean isConflictsStatus(VCSStatus status) {
        return status instanceof StatusInfo && ((StatusInfo)status).isConflicts();
    }

    public ClientSetting getSettings() {
        return ClientSetting.findOrCreate((String)this._profile.getID());
    }

    public VCSPropertyMap getData(String key) {
        return (VCSPropertyMap)this.getSettings().getData(this.getQualifiedDataKey(key));
    }

    public String getQualifiedDataKey(String key) {
        String qualified = (String)this._qualifiedDataKeys.get(key);
        if (qualified == null) {
            qualified = this._profile.getID() + "." + key;
        }
        return qualified;
    }

    public VCSStatus getStatusInstance(String id) {
        if ("oracle.jdeveloper.vcs.status.UNRECOGNIZED".equals(id)) {
            return sUnrecognizedStatus;
        }
        return this._profile.getFileSystem().getStatuses().getStatus(id);
    }

    public synchronized VCSActionInfo getActionInfo(String actionId) {
        ActionInfo actionInfo;
        VCSActionInfo ai = (VCSActionInfo)this._actionInfos.get(actionId);
        if (ai == null && (actionInfo = this._profile.getActions().getAction(actionId)) != null) {
            ai = this._profile.getPendingChanges() != null ? new ActionInfoImpl(this, actionInfo, this._profile.getPendingChanges().getChangeLists(), null) : new ActionInfoImpl((VCSProfile)this, actionInfo, null);
            this._actionInfos.put(actionId, ai);
        }
        return ai;
    }

    public synchronized URL getSystemDirectory() {
        if (this._systemDirectory == null) {
            this._systemDirectory = ExtensionRegistry.getExtensionRegistry().getSystemDirectory(this._profile.getID());
        }
        return this._systemDirectory;
    }

    public Logger getLogger() {
        return this._logger;
    }

    public CheckOutProvider getCheckOutProvider() {
        return this._checkOutProvider;
    }

    public VCSHistoryProvider getHistoryProvider() {
        return this._historyProvider;
    }

    public HistoryProperty getHistoryProperty(String id) {
        HistoryProvider provider;
        VCSHistoryProvider vcsProvider = this.getHistoryProvider();
        if (vcsProvider != null && (provider = vcsProvider.getHistoryProvider()) != null && provider instanceof GenericHistoryProvider) {
            return ((GenericHistoryProvider)provider).getProperty(id);
        }
        return null;
    }

    public String getChangeListViewID() {
        if (this._profile.getPendingChanges() != null) {
            if (this._changeListViewID == null) {
                this._changeListViewID = ChangeListViewId.getViewId(this);
            }
            return this._changeListViewID;
        }
        return null;
    }

    public PendingChangesAdapter getPendingChangesAdapter() {
        if (this._profile.getPendingChanges() == null) {
            return null;
        }
        if (this._pendingChangesAdapter == null) {
            PendingChangesAdapter adapter = this._profile.getPendingChanges().getAdapter();
            if (adapter == null) {
                adapter = new 4();
            }
            this._pendingChangesAdapter = adapter;
        }
        return this._pendingChangesAdapter;
    }

    public ChangeList[] getChangeLists() {
        PendingChangesInfo pci;
        if (this._changeLists == null && (pci = this._profile.getPendingChanges()) != null) {
            Collection declaredLists = pci.getChangeLists();
            ArrayList<ChangeList> lists = new ArrayList<ChangeList>(declaredLists.size() * 2);
            for (Object o : declaredLists) {
                if (o instanceof ChangeListInfo) {
                    ChangeListInfo clInfo = (ChangeListInfo)o;
                    String changeListClass = clInfo.getChangeListClass();
                    ChangeList cl = null;
                    if (changeListClass != null) {
                        try {
                            cl = (ChangeList)Class.forName(changeListClass).newInstance();
                        }
                        catch (Exception e) {
                            this._logger.severe("error instantiating change list class: " + e.getClass().getName() + ": " + e.getMessage());
                        }
                    } else {
                        StatusBasedMultiChangeList.sContextProfile = this;
                        StatusBasedMultiChangeList.sContextInfo = clInfo;
                        cl = new StatusBasedMultiChangeList(this, clInfo);
                        StatusBasedMultiChangeList.sContextProfile = null;
                        StatusBasedMultiChangeList.sContextInfo = null;
                    }
                    if (cl == null) continue;
                    lists.add(cl);
                    this._changeListsById.put(clInfo.getID(), cl);
                    this._changeListInfosById.put(clInfo.getID(), clInfo);
                    continue;
                }
                if (!(o instanceof MultiChangeList)) continue;
                ChangeList cl = (ChangeList)o;
                lists.add(cl);
                this._changeListsById.put(cl.getClass().getName(), cl);
                this._changeListInfosById.put(cl.getClass().getName(), null);
            }
            this._changeLists = lists.toArray(new ChangeList[lists.size()]);
        }
        return this._changeLists;
    }

    public ChangeList getChangeList(String id) {
        this.getChangeLists();
        return (ChangeList)this._changeListsById.get(id);
    }

    public ChangeListInfo getChangeListInfo(String id) {
        this.getChangeLists();
        return (ChangeListInfo)this._changeListInfosById.get(id);
    }

    private void initializeClientSettings() {
        ClientSetting prefs = this.getSettings();
        Map propertyMap = VCSPropertyCustomizer.createDefaultProperties(new String[]{"useOverlays", "useLabelDecorations", "logMessagesToLogWindow", "autoCheckouts", "autoCheckoutComment", "property_operation_timeout"});
        VCSPropertyMap commonPrefs = this.getData("oracle.jdeveloper.vcs.data.COMMON_SETTINGS");
        if (commonPrefs != null) {
            propertyMap.putAll(commonPrefs.getMap());
        } else {
            commonPrefs = new VCSPropertyMap();
            prefs.putData(this.getQualifiedDataKey("oracle.jdeveloper.vcs.data.COMMON_SETTINGS"), (Copyable)commonPrefs);
        }
        commonPrefs.setMap(propertyMap);
        for (ClientSettingInfo cs : this._profile.getClientSettings()) {
            propertyMap = cs.getProperties();
            VCSPropertyMap properties = (VCSPropertyMap)prefs.getData(this.getQualifiedDataKey(cs.getID()));
            if (properties != null) {
                propertyMap.putAll(properties.getMap());
            } else {
                properties = new VCSPropertyMap();
                prefs.putData(this.getQualifiedDataKey(cs.getID()), (Copyable)properties);
            }
            properties.setMap(propertyMap);
        }
    }

    private void initializePreferencePanels() throws ClassNotFoundException {
        PreferencesInfo prefs = this._profile.getPreferences();
        if (prefs == null) {
            this._logger.fine("no preference panels to initialize");
            return;
        }
        List childPanels = prefs.getChildPanels();
        Navigable[] children = new Navigable[childPanels.size()];
        Iterator it = childPanels.iterator();
        int index = 0;
        while (it.hasNext()) {
            PreferencesInfo.ChildPanelInfo p = (PreferencesInfo.ChildPanelInfo)it.next();
            children[index++] = new SearchNavigable(p.getLabel(), p.getTraversableClass(), p.getSearchTag());
        }
        Navigable root = new Navigable(this.getInformation().getShortLabel(), prefs.getTraversableClass(), (Navigable[])(children.length > 0 ? children : null));
        VCSNavigableUtils.registerSystemNavigable(root);
    }

    private void initializeDefaultStatusFilters() {
        StatusesInfo s = this._profile.getFileSystem().getStatuses();
        if (s != null) {
            s.addStatusFilter(new VersionedStatusFilter());
            s.addStatusFilter(new UnversionedStatusFilter());
            s.addStatusFilter(new CandidateStatusFilter());
            s.addStatusFilter(new RecognizedStatusFilter(sUnrecognizedStatus));
            s.addStatusFilter(new UnrecognizedStatusFilter(sUnrecognizedStatus));
        }
    }

    static {
        $assertionsDisabled = GenericClient.class.desiredAssertionStatus() ^ true;
        sUnrecognizedStatus = VCSDefaultUtils.createUnrecognizedStatus();
    }

    private void activateOperations() {
        if (!$assertionsDisabled && this._controller != null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this._actions != null) {
            throw new AssertionError();
        }
        this._controller = new GenericController(this, this._profile);
        this._actionInfos.clear();
        this._actions = this.createActions();
        int i = 0;
        while (i < this._actions.length) {
            this._actions[i].addController(this._controller);
            ++i;
        }
        IdeAction action = IdeAction.find((int)51);
        if (action != null) {
            action.addController(this._controller);
        }
    }

    private IdeAction[] createActions() {
        ActionsInfo opInfo = this._profile.getActions();
        List operations = opInfo.getActions();
        if (operations != null && operations.size() > 0) {
            ArrayList<IdeAction> actions = new ArrayList<IdeAction>(operations.size() * 2);
            for (ActionInfo op : operations) {
                int commandIdeId = Ide.findOrCreateCmdID((String)op.getID());
                String className = op.getActionClassName();
                if (op.getResourcePrefix() != null) {
                    try {
                        actions.add(GLazyIdeAction.getAction(commandIdeId, className, this._profile.getRsbundleClass(), op.getResourcePrefix(), op.getIconRef()));
                    }
                    catch (ClassNotFoundException cnfe) {
                        this._logger.severe("Unable to init lazy status, could not load resource class. " + cnfe.getMessage());
                    }
                    continue;
                }
                actions.add(IdeAction.get((int)commandIdeId, (String)className, (String)op.getLabel(), (String)VCSMenuConstants.ACTION_CATEGORY_VERSIONING, (Integer)new Integer(op.getMnemonic()), null, null, (boolean)true));
            }
            if (this._profile.getPendingChanges() != null) {
                IdeAction action = ViewPendingChangesAction.getAction(this);
                actions.add(action);
                this._actionInfos.put(Ide.findCmdName((int)action.getCommandId()), new 5());
            }
            return actions.toArray(new IdeAction[actions.size()]);
        }
        return new IdeAction[0];
    }

    private void activateMenus() {
        SectionsInfo menuInfo = null;
        menuInfo = this._profile.getMenus().getMenu("oracle.jdeveloper.vcs.menus.VERSIONING_MENU");
        if (menuInfo != null) {
            this.installVersioningMenuItems(menuInfo.getSections());
        } else {
            this._logger.fine("no main versioning menu items found");
        }
        menuInfo = this._profile.getMenus().getMenu("oracle.jdeveloper.vcs.menus.COMPARE_MENU");
        if (menuInfo != null) {
            this.installCompareMenuItems(menuInfo.getSections());
        } else {
            this._logger.fine("no compare menu items found");
        }
        menuInfo = this._profile.getMenus().getMenu("oracle.jdeveloper.vcs.menus.REPLACE_MENU");
        if (menuInfo != null) {
            this.installReplaceWithMenuItems(menuInfo.getSections());
        } else {
            this._logger.fine("no replace-with menu items found");
        }
        if (this._contextMenuListener == null) {
            this._contextMenuListener = new GenericContextMenuListener(this, this._profile, this._logger);
        }
        VCSMenuUtils.installContextMenuListener(this._contextMenuListener);
    }

    private void installCompareMenuItems(Collection menuSections) {
        for (SectionInfo section : menuSections) {
            for (String actionRef : section.getActionRefs()) {
                Integer cmdId = Ide.findCmdID((String)actionRef);
                if (cmdId == null) {
                    this._logger.warning("unsatisfied action reference: " + actionRef);
                    continue;
                }
                VCSMenuUtils.installCompareMenuItem(cmdId, this.getId());
            }
        }
    }

    private void installReplaceWithMenuItems(Collection menuSections) {
        for (SectionInfo section : menuSections) {
            for (String actionRef : section.getActionRefs()) {
                Integer cmdId = Ide.findCmdID((String)actionRef);
                if (cmdId == null) {
                    this._logger.warning("unsatisfied action reference: " + actionRef);
                    continue;
                }
                VCSMenuUtils.installReplaceMenuItem(cmdId, this.getId());
            }
        }
    }

    private void installVersioningMenuItems(Collection menuSections) {
        JMenu menu = VCSMenuUtils.installMainSystemMenu(this.getId(), this.getInformation());
        float sectionIdentifier = 1.0f;
        for (SectionInfo section : menuSections) {
            for (String actionRef : section.getActionRefs()) {
                ActionInfo referencedOp = this._profile.getActions().getAction(actionRef);
                if (referencedOp == null) {
                    this._logger.warning("unsatisfied action reference in menu declarations: " + actionRef);
                    continue;
                }
                Integer cmdId = Ide.findCmdID((String)referencedOp.getID());
                if (cmdId == null) {
                    this._logger.warning("unrecognized operation in menu declarations: " + actionRef);
                    continue;
                }
                VCSMenuUtils.addMenuItem(menu, cmdId, sectionIdentifier);
            }
            sectionIdentifier += 1.0f;
        }
        if (this._profile.getPendingChanges() != null) {
            this.installPendingChangesMenuItem(menu);
        }
    }

    private void installPendingChangesMenuItem(JMenu menu) {
        VCSMenuUtils.addMenuItem(menu, ViewPendingChangesAction.getCommandId(this), 99.7f);
    }

    private void activateEventBusComponents() {
        EventBusInfo ebi = this._profile.getEventBus();
        if (ebi == null) {
            return;
        }
        VCSSingleNodeObserver nodeObserver = ebi.getNodeObserver();
        if (nodeObserver != null) {
            nodeObserver.setStatusCache(this.getStatusCache());
            nodeObserver.setURLFilter(this.getURLFilter());
            VCSEventBus.addToBus(nodeObserver);
        }
        Iterator it = ebi.getComponents().iterator();
        while (it.hasNext()) {
            VCSEventBus.addToBus((VCSEBComponent)it.next());
        }
    }

    private void activatePendingChanges(PendingChangesInfo info) throws ClassNotFoundException {
        this._changeListsById.clear();
        this._changeListInfosById.clear();
        this._changeLists = null;
        new GenericChangeListDockableFactory(ChangeListViewId.getViewId(this), StatusBasedChangeListWindow.class.getName(), this);
    }

    private void manageOverlayTracker() {
        boolean useLabeldecorations;
        VCSPropertyMap commonPrefs = this.getData("oracle.jdeveloper.vcs.data.COMMON_SETTINGS");
        Boolean b = (Boolean)commonPrefs.getMap().get("useOverlays");
        boolean useOverlays = b != null ? b : false;
        b = (Boolean)commonPrefs.getMap().get("useLabelDecorations");
        boolean bl = useLabeldecorations = b != null ? b : false;
        if (this._overlayTracker != null) {
            if (this._controller == null || !useOverlays && !useLabeldecorations) {
                this._overlayTracker.stopTracking();
                this._overlayTracker = null;
            }
            return;
        }
        VCSStatusCache statusCache = this.getStatusCache();
        if (this._controller != null && (useOverlays || useLabeldecorations) && statusCache != null) {
            this._overlayTracker = VCSDefaultUtils.createNodeOverlayTracker(10, this._overlayProducer, this.getURLFilter(), this.getId());
        }
    }

    private ProfileListener createProfileListener() throws ClassNotFoundException {
        try {
            Class theClass = this._profile.getListenerClass();
            ProfileListener profileListener = (ProfileListener)theClass.newInstance();
            return profileListener;
        }
        catch (ClassNotFoundException cnfe) {
            this._logger.severe("unable to load profile listener class.");
            throw cnfe;
        }
        catch (Exception e) {
            this._logger.severe("error instantiating profile listener class: " + e.getClass().getName() + ": " + e.getMessage());
            ProfileListener profileListener = null;
            return profileListener;
        }
    }

    private StatusResolver createStatusResolver() throws ClassNotFoundException {
        try {
            Class theClass = this._profile.getFileSystem().getStatuses().getResolverClass();
            StatusResolver statusResolver = (StatusResolver)theClass.newInstance();
            return statusResolver;
        }
        catch (ClassNotFoundException cnfe) {
            this._logger.severe("unable to load status resolver class.");
            throw cnfe;
        }
        catch (Exception e) {
            this._logger.severe("error instantiating status resolver class: " + e.getClass().getName() + ": " + e.getMessage());
            StatusResolver statusResolver = null;
            return statusResolver;
        }
    }

    private VCSOverlayItemProducer createOverlayProducer() {
        try {
            VCSOverlayItemProducer vCSOverlayItemProducer = VCSGenericUtil.newOverlayProducer(this, this._profile.getFileSystem().getStatuses().getOverlayProducerClass());
            return vCSOverlayItemProducer;
        }
        catch (ClassNotFoundException cnfe) {
            this._logger.warning("could not find overlay producer class. using a default instance");
            VCSOverlayItemProducer vCSOverlayItemProducer = new VCSOverlayItemProducer(this.getStatusCache());
            return vCSOverlayItemProducer;
        }
    }

    private Handler createDefaultLogHandler() {
        SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss.SSS z dd.MM.yy");
        6 formatter = new 6(this, df);
        try {
            FileHandler handler = new FileHandler(URLFileSystem.getPlatformPathName((URL)URLFactory.newURL((URL)this.getSystemDirectory(), (String)"vcs.log")));
            handler.setFormatter(formatter);
            handler.setLevel(Level.ALL);
            FileHandler fileHandler = handler;
            return fileHandler;
        }
        catch (IOException ioe) {
            Logger.getLogger("").log(Level.SEVERE, "unable to use default vcs log file", ioe);
            ConsoleHandler handler = new ConsoleHandler();
            handler.setFormatter(formatter);
            handler.setLevel(Level.ALL);
            ConsoleHandler consoleHandler = handler;
            return consoleHandler;
        }
    }

    private void fireProfileInitialized() {
        if (this._profileListener != null) {
            this._profileListener.profileInitialized(this);
        }
    }

    private boolean fireCanActivate() {
        if (this._profileListener != null) {
            return this._profileListener.canActivate(this);
        }
        return true;
    }

    private void fireProfileActivated() {
        if (this._profileListener != null) {
            this._profileListener.profileActivated(this);
        }
    }

    private void fireProfileDestroyed() {
        if (this._profileListener != null) {
            this._profileListener.profileDestroyed(this);
        }
    }

    static void mav$manageOverlayTracker(GenericClient genericClient) {
        genericClient.manageOverlayTracker();
    }

    static ProfileInfo ra$_profile(GenericClient genericClient) {
        return genericClient._profile;
    }

    static StatusResolver ra$_statusResolver(GenericClient genericClient) {
        return genericClient._statusResolver;
    }

    final class 1
    extends VCSActionInfoImpl {
        public VCSCommandStyle getStyle() {
            return VCSCommandStyle.NORMAL;
        }

        public VCSCommandType getType() {
            return VCSCommandType.BOTH;
        }

        public 1(VCSProfile vCSProfile, AbstractActionInfo abstractActionInfo) {
            super(vCSProfile, abstractActionInfo);
        }
    }

    final class 2
    extends VCSStatusCache {
        protected void getImpl(URL[] urls, VCSStatus[] statuses) throws Exception {
            GenericClient.ra$_statusResolver(GenericClient.this).populateStatuses(GenericClient.this, urls, statuses);
        }
    }

    final class 3
    implements Displayable {
        public Icon getIcon() {
            return null;
        }

        public String getLongLabel() {
            return GenericClient.ra$_profile(GenericClient.this).getClientInfo().getLongLabel();
        }

        public String getShortLabel() {
            return GenericClient.ra$_profile(GenericClient.this).getClientInfo().getShortLabel();
        }

        public String getToolTipText() {
            return this.getLongLabel();
        }

        public String toString() {
            return this.getShortLabel();
        }
    }

    final class 4
    extends PendingChangesAdapter {
        public VCSProfile getProfile() {
            return GenericClient.this;
        }
    }

    final class 5
    implements VCSActionInfo {
        public VCSCommandStyle getStyle() {
            return VCSCommandStyle.NORMAL;
        }

        public VCSCommandType getType() {
            return VCSCommandType.BOTH;
        }

        public boolean requirementsSatisfied(Context context) {
            return true;
        }

        public Collection getFilteredSelection(Context context) {
            return Collections.EMPTY_SET;
        }

        public boolean isChangeListAction() {
            return false;
        }

        public String getDialogTitle() {
            return null;
        }

        public String getDialogHint() {
            return null;
        }

        public String getHelpTopicId() {
            return null;
        }
    }

    final class 6
    extends Formatter {
        private final /* synthetic */ DateFormat v$df;
        final /* synthetic */ GenericClient this$0;

        public String format(LogRecord r) {
            FastStringBuffer buff = new FastStringBuffer(100);
            buff.append('[');
            buff.append(this.v$df.format(new Date(r.getMillis())));
            buff.append("] ").append(r.getMessage()).append("\n");
            return buff.toString();
        }

        public 6(GenericClient genericClient, DateFormat dateFormat) {
            this.v$df = dateFormat;
            this.this$0 = genericClient;
        }
    }

    private static final class ActionInfoImpl
    extends VCSActionInfoImpl {
        private final ActionInfo _actionInfo;

        private ActionInfoImpl(VCSProfile profile, ActionInfo info) {
            super(profile, info);
            this._actionInfo = info;
        }

        private ActionInfoImpl(VCSProfile profile, ActionInfo info, Collection changeListInfos) {
            super(profile, info, changeListInfos);
            this._actionInfo = info;
        }

        public String getDialogTitle() {
            return this._actionInfo.getDialogTitle();
        }

        public String getDialogHint() {
            return this._actionInfo.getDialogHint();
        }

        public String getHelpTopicId() {
            return this._actionInfo.getHelpTopicId();
        }

        ActionInfoImpl(VCSProfile vCSProfile, ActionInfo actionInfo, Collection collection, 1 var4_4) {
            this(vCSProfile, actionInfo, collection);
        }

        ActionInfoImpl(VCSProfile vCSProfile, ActionInfo actionInfo, 1 var3_3) {
            this(vCSProfile, actionInfo);
        }

        public final class 1 {
        }
    }

    private final class ClientChangeListener
    implements ChangeListener {
        public void stateChanged(ChangeEvent e) {
            GenericClient.mav$manageOverlayTracker(GenericClient.this);
        }

        private ClientChangeListener() {
        }

        ClientChangeListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

