/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.generic;

import java.lang.reflect.InvocationTargetException;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.controller.IdeAction;
import oracle.ide.navigator.NavigatorWindow;
import oracle.jdeveloper.vcs.generic.ActionCommand;
import oracle.jdeveloper.vcs.generic.VCSActionInfo;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSController;
import oracle.jdevimpl.vcs.generic.profile.ProfileInfo;
import oracle.jdevimpl.vcs.generic.profile.RefreshActionInfo;

public class GenericController
extends VCSController {
    private final VCSProfile _profileBean;
    private final ProfileInfo _profileInfo;
    private VCSController _delegateController;
    private boolean _noDelegate;

    public GenericController(VCSProfile profileBean, ProfileInfo profileInfo) {
        super(null);
        this._profileBean = profileBean;
        this._profileInfo = profileInfo;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        VCSController delegate = this.getDelegateController();
        if (delegate != null && delegate.handleEvent(action, context)) {
            return true;
        }
        if (action.getCommandId() == 51) {
            RefreshActionInfo ri = this._profileInfo.getActions().getRefreshAction();
            if (ri != null && context.getView() instanceof NavigatorWindow) {
                if (ri.getRefreshStatuses()) {
                    this._profileBean.getStatusCache().clear();
                }
                return false;
            }
            return false;
        }
        return super.handleEvent(action, context);
    }

    public boolean update(IdeAction action, Context context) {
        VCSController delegate = this.getDelegateController();
        if (delegate != null && delegate.update(action, context)) {
            return true;
        }
        if (action.getCommandId() == 51) {
            RefreshActionInfo ri = this._profileInfo.getActions().getRefreshAction();
            if (ri != null && context.getView() instanceof NavigatorWindow) {
                action.setEnabled(true);
                return true;
            }
            return false;
        }
        return super.update(action, context);
    }

    protected boolean isHandledAction(IdeAction action) {
        String actionId = Ide.findCmdName((int)action.getCommandId());
        if (actionId != null && actionId.endsWith(".oracle.jdeveloper.vcs.action.HISTORY")) {
            return false;
        }
        if (actionId != null && actionId.endsWith(".oracle.jdeveloper.vcs.action.VIEW_PENDING_CHANGES")) {
            return false;
        }
        VCSActionInfo actionInfo = this._profileBean.getActionInfo(actionId);
        return actionInfo != null;
    }

    protected void preUpdate(IdeAction action, Command command) {
        if (command instanceof ActionCommand) {
            ((ActionCommand)command).setProfile(this._profileBean);
        }
    }

    protected void preInvoke(IdeAction action, Command command) {
        if (command instanceof ActionCommand) {
            ((ActionCommand)command).setProfile(this._profileBean);
        }
    }

    private synchronized VCSController getDelegateController() {
        if (this._delegateController == null && !this._noDelegate) {
            try {
                Class theClass = this._profileInfo.getActions().getControllerClass();
                if (theClass == null) {
                    this._noDelegate = true;
                    VCSController vCSController = null;
                    return vCSController;
                }
                this._delegateController = (VCSController)theClass.newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                this._profileBean.getLogger().severe("Unable to load operation controller class: " + cnfe.getMessage());
            }
            catch (Exception e) {
                Throwable cause = e;
                if (e instanceof InvocationTargetException) {
                    cause = ((InvocationTargetException)e).getTargetException();
                }
                this._profileBean.getLogger().severe("Error instantiating operation controller class: " + cause.getMessage());
            }
        }
        return this._delegateController;
    }
}

