/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.generic;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.table.DefaultTableCellRenderer;
import oracle.ide.Context;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.javatools.history.HistoryEntry;
import oracle.javatools.history.HistoryProperty;
import oracle.jdeveloper.history.DefaultHistoryProperty;
import oracle.jdeveloper.history.HistoryFilter;
import oracle.jdeveloper.history.HistoryProvider;
import oracle.jdeveloper.history.SharedProperties;
import oracle.jdeveloper.vcs.generic.HistoryEntryProducer;
import oracle.jdeveloper.vcs.generic.VCSActionInfo;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSExceptionHandler;
import oracle.jdevimpl.vcs.generic.profile.ClientInfoInfo;
import oracle.jdevimpl.vcs.generic.profile.HistoryPropertyInfo;
import oracle.jdevimpl.vcs.generic.profile.HistoryProviderInfo;

public final class GenericHistoryProvider
extends HistoryProvider {
    private static final Map sSharedProps = new HashMap(7);
    private final HistoryFilter[] _predefinedFilters;
    private final Map _propIndex;
    private final VCSProfile _profile;
    private final HistoryProviderInfo _providerInfo;
    private final ClientInfoInfo _clientInfo;
    private final VCSActionInfo _actionInfo;
    private HistoryFilter _typeFilter;
    private HistoryEntryProducer _producer;
    private HistoryProperty[] _properties;
    private VCSExceptionHandler _exceptionHandler;

    private void $init$() {
        this._predefinedFilters = new HistoryFilter[0];
        this._propIndex = new HashMap(10);
    }

    static {
        sSharedProps.put("oracle.jdeveloper.vcs.history.DATE", SharedProperties.getDateProperty());
        sSharedProps.put("oracle.jdeveloper.vcs.history.REVISION", SharedProperties.getRevisionProperty());
        sSharedProps.put("oracle.jdeveloper.vcs.history.DESCRIPTION", SharedProperties.getDescriptionProperty());
    }

    public GenericHistoryProvider(VCSProfile profile, HistoryProviderInfo providerInfo, ClientInfoInfo clientInfo, VCSActionInfo actionInfo) {
        this.$init$();
        this._profile = profile;
        this._providerInfo = providerInfo;
        this._clientInfo = clientInfo;
        this._actionInfo = actionInfo;
    }

    public HistoryFilter getTypeFilter() {
        if (this._typeFilter == null) {
            this._typeFilter = this.createTypeFilter();
        }
        return this._typeFilter;
    }

    public HistoryFilter[] getPredefinedFilters() {
        return this._predefinedFilters;
    }

    public HistoryProperty[] getProperties() {
        if (this._properties == null) {
            this._properties = this.createProperties();
        }
        return this._properties;
    }

    public HistoryProperty getProperty(String id) {
        return (HistoryProperty)this._propIndex.get(id);
    }

    public boolean isProviderFor(URL url) {
        URLFilter filter = this._profile.getURLFilter("oracle.jdeveloper.vcs.filters.url.DEFAULT");
        if (filter != null && !filter.accept(url)) {
            return false;
        }
        try {
            Collection filtered = this._actionInfo.getFilteredSelection(Context.newIdeContext((Node)NodeFactory.findOrCreate((URL)url)));
            boolean bl = filtered != null && filtered.size() == 1;
            return bl;
        }
        catch (Exception e) {
            this._profile.getLogger().log(Level.WARNING, "history provider could not determine status for " + URLFileSystem.getPlatformPathName((URL)url), e);
            this.getExceptionHandler().handleException(e);
            boolean bl = false;
            return bl;
        }
    }

    public HistoryEntry[] getEntries(URL url, HistoryFilter historyFilter) {
        HistoryEntryProducer producer = this.getEntryProducer();
        if (producer != null) {
            return producer.produceEntries(url);
        }
        return new HistoryEntry[0];
    }

    private HistoryEntryProducer getEntryProducer() {
        if (this._producer == null) {
            try {
                Class theClass = this._providerInfo.getEntryProducerClass();
                this._producer = (HistoryEntryProducer)theClass.newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                this._profile.getLogger().warning("unable to load history entry producer class: " + cnfe.getMessage());
            }
            catch (Exception e) {
                this._profile.getLogger().log(Level.WARNING, "unable to instantiate history entry producer", e instanceof InvocationTargetException ? ((InvocationTargetException)e).getTargetException() : e);
            }
        }
        return this._producer;
    }

    private HistoryProperty[] createProperties() {
        Collection propertyInfos = this._providerInfo.getHistoryProperties();
        ArrayList<HistoryProperty> properties = new ArrayList<HistoryProperty>(propertyInfos.size() + 5);
        HistoryProperty dateProperty = SharedProperties.getDateProperty();
        float weight = 0.1f;
        dateProperty.setWeight(weight);
        properties.add(dateProperty);
        this._propIndex.put("oracle.jdeveloper.vcs.history.DATE", dateProperty);
        for (HistoryPropertyInfo propInfo : propertyInfos) {
            String propId = propInfo.getID();
            if ("oracle.jdeveloper.vcs.history.DATE".equals(propId)) continue;
            try {
                HistoryProperty prop = (HistoryProperty)sSharedProps.get(propId);
                if (prop != null) {
                    if ("oracle.jdeveloper.vcs.history.DESCRIPTION".equals(propId)) {
                        DefaultTableCellRenderer r = new DefaultTableCellRenderer();
                        r.setText("mmmmmmmmmmmmmmmmmmmmmmmm");
                        prop.setAutoSizeMaximum(r.getPreferredSize().width);
                    }
                } else {
                    prop = new DefaultHistoryProperty(propInfo.getCustomFilterId(), propInfo.getShortLabel(), propInfo.getLongLabel(), propInfo.getType(), propInfo.getPrototype());
                }
                prop.setWeight(weight += 0.1f);
                prop.setDefault(propInfo.getVisible());
                properties.add(prop);
                this._propIndex.put(propId, prop);
            }
            catch (ClassNotFoundException cnfe) {
                String identifier = propInfo.getID();
                if (identifier == null) {
                    identifier = propInfo.getShortLabel();
                }
                this._profile.getLogger().log(Level.WARNING, "unable to set type for history property " + identifier, cnfe);
            }
        }
        return properties.toArray(new HistoryProperty[properties.size()]);
    }

    private HistoryFilter createTypeFilter() {
        return new 1();
    }

    private VCSExceptionHandler getExceptionHandler() {
        if (this._exceptionHandler == null) {
            this._exceptionHandler = new VCSExceptionHandler();
        }
        return this._exceptionHandler;
    }

    static HistoryProviderInfo ra$_providerInfo(GenericHistoryProvider genericHistoryProvider) {
        return genericHistoryProvider._providerInfo;
    }

    static ClientInfoInfo ra$_clientInfo(GenericHistoryProvider genericHistoryProvider) {
        return genericHistoryProvider._clientInfo;
    }

    static Map ra$sSharedProps() {
        return sSharedProps;
    }

    final class 1
    implements HistoryFilter {
        private String _label;

        public boolean accept(HistoryEntry entry) {
            HistoryProperty[] props = GenericHistoryProvider.this.getProperties();
            int i = 0;
            while (i < props.length) {
                if (!GenericHistoryProvider.ra$sSharedProps().containsValue(props[i]) && entry.getValue(props[i]) != null) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public String getShortLabel() {
            if (this._label == null) {
                String label = GenericHistoryProvider.ra$_providerInfo(GenericHistoryProvider.this).getFilterLabel();
                if (label == null || label.equals("")) {
                    label = GenericHistoryProvider.ra$_clientInfo(GenericHistoryProvider.this).getShortLabel();
                }
                this._label = label;
            }
            return this._label;
        }
    }
}

