/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.generic;

import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.logging.Level;
import oracle.ide.Context;
import oracle.ide.help.HelpInfo;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.properties.PropertiesPanel;
import oracle.jdeveloper.vcs.properties.VersionPropertiesPanelProvider;
import oracle.jdevimpl.vcs.generic.VCSActionInfoImpl;
import oracle.jdevimpl.vcs.generic.profile.PropertyProviderInfo;

public class GenericPropertyPanelProvider
extends VersionPropertiesPanelProvider {
    private final VCSProfile _profile;
    private final PropertyProviderInfo _info;
    private final VCSActionInfoImpl _actionInfo;
    private Class _panelClass;

    public GenericPropertyPanelProvider(VCSProfile profile, PropertyProviderInfo info) throws ClassNotFoundException {
        super(profile.getStatusCache());
        this._profile = profile;
        this._info = info;
        this._actionInfo = new VCSActionInfoImpl(this._profile, this._info);
        this._panelClass = this._info.getPropertyPanelClass();
    }

    public PropertiesPanel createPanel(Context context) {
        try {
            Constructor c = this._panelClass.getConstructor(URL.class);
            PropertiesPanel propertiesPanel = (PropertiesPanel)c.newInstance(this.getContextURL(context));
            return propertiesPanel;
        }
        catch (NoSuchMethodException nsme) {
            try {
                PropertiesPanel panel;
                PropertiesPanel propertiesPanel = panel = (PropertiesPanel)this._panelClass.newInstance();
                return propertiesPanel;
            }
            catch (Exception e) {
                this._profile.getLogger().log(Level.SEVERE, "unable to instantiate " + this._panelClass.getName() + " using the default constructor", e);
                PropertiesPanel propertiesPanel = null;
                return propertiesPanel;
            }
        }
        catch (Exception e) {
            this._profile.getLogger().log(Level.SEVERE, "unable to instantiate " + this._panelClass.getName() + " using URL constructor", e);
            PropertiesPanel propertiesPanel = null;
            return propertiesPanel;
        }
    }

    public String getTabName() {
        if (this._info.getShortLabel() != null) {
            return this._info.getShortLabel();
        }
        return super.getTabName();
    }

    public float getTabWeight() {
        if (this._info.getWeight() != null) {
            return this._info.getWeight().floatValue();
        }
        return super.getTabWeight();
    }

    public boolean isDefaultTab() {
        if (this._info.getDefault() != null) {
            return this._info.getDefault();
        }
        return super.isDefaultTab();
    }

    public HelpInfo getHelpInfo() {
        if (this._info.getHelpId() != null) {
            return new HelpInfo(this._info.getHelpId());
        }
        return super.getHelpInfo();
    }

    public boolean isHandled(Context context) {
        if (this._info.getRequires() != null || !this._info.getAffects().isEmpty()) {
            try {
                boolean bl = this._actionInfo.requirementsSatisfied(context) && !this._actionInfo.getFilteredSelection(context).isEmpty();
                return bl;
            }
            catch (Exception e) {
                boolean bl = false;
                return bl;
            }
        }
        return super.isHandled(context);
    }
}

