/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.generic;

import java.util.Iterator;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import oracle.ide.Addin;
import oracle.ide.performance.PerformanceLogger;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfiles;
import oracle.jdevimpl.vcs.generic.GenericClient;
import oracle.jdevimpl.vcs.generic.VCSGenericRegistry;

public class VCSGenericAddin
extends VCSProfiles
implements Addin {
    public void initialize() {
        try {
            InitialContext ic = new InitialContext();
            ic.bind("jdeveloper/vcsprofiles", (Object)this);
        }
        catch (NamingException ne) {
            ne.printStackTrace();
        }
        PerformanceLogger.get().startTiming(this.getClass().getName() + ".initProfiles", "Initializing VCS Profiles");
        Iterator it = VCSGenericRegistry.getInstance().getRegisteredClients();
        int profileCount = 0;
        while (it.hasNext()) {
            GenericClient client = (GenericClient)it.next();
            PerformanceLogger.get().startTiming(this.getClass().getName() + ".initProfile");
            try {
                client.initialize();
                ++profileCount;
            }
            finally {
                PerformanceLogger.get().stopTiming(this.getClass().getName() + ".initProfile", client.getID());
            }
        }
        PerformanceLogger.get().stopTiming(this.getClass().getName() + ".initProfiles", "Initialized " + String.valueOf(profileCount) + (profileCount > 1 ? " VCS Profiles" : " VCS Profile"));
    }

    public VCSProfile getProfile(String id) {
        return VCSGenericRegistry.getInstance().lookup(id);
    }
}

