/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.generic.changelist;

import java.net.URL;
import java.util.ArrayList;
import oracle.ide.model.Displayable;
import oracle.ide.model.Locatable;
import oracle.jdeveloper.vcs.changelist.ChangeList;
import oracle.jdeveloper.vcs.changelist.ChangeListEventQueue;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.util.VCSComponents;
import oracle.jdeveloper.vcs.vop.MutableVersionOperationModel;
import oracle.jdevimpl.vcs.generic.changelist.CLUtil;
import oracle.jdevimpl.vcs.generic.changelist.ExtendedDisplayProperty;
import oracle.jdevimpl.vcs.generic.profile.ChangeListInfo;

public class DisplayPropertyBasedChangeList
extends ChangeList {
    private final VCSProfile _profile;
    private final ChangeListInfo _info;
    private ExtendedDisplayProperty[] _properties;

    public DisplayPropertyBasedChangeList(VCSProfile profile, ChangeListInfo info) throws ClassNotFoundException {
        this._profile = profile;
        this._info = info;
        this._properties = CLUtil.createDisplayProperties(info.getDisplayProperties());
    }

    protected MutableVersionOperationModel createModel() {
        return VCSComponents.createFileListerModel(new ArrayList(), this._properties);
    }

    protected ChangeListEventQueue createEventQueue() {
        return CLUtil.createEventQueue(this._profile, this, this._info);
    }

    protected void insertProperties(int firstItem, int lastItem) {
        this.resolveProperties(firstItem, lastItem);
        super.insertProperties(firstItem, lastItem);
    }

    protected void updateProperties(int firstItem, int lastItem) {
        this.resolveProperties(firstItem, lastItem);
        super.updateProperties(firstItem, lastItem);
    }

    private void resolveProperties(int firstItem, int lastItem) {
        int i = firstItem;
        while (i <= lastItem) {
            Displayable d = this.getModel().getItem(i);
            if (d instanceof Locatable) {
                URL url = ((Locatable)d).getURL();
                int j = 0;
                while (j < this._properties.length) {
                    this.getModel().setProperty(i, this._properties[j], this._profile.getPendingChangesAdapter().resolvePropertyValue(this._info.getID(), this._properties[j].getID(), url));
                    ++j;
                }
            }
            ++i;
        }
    }
}

