/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.generic.changelist;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controls.Toolbar;
import oracle.ide.help.HelpInfo;
import oracle.javatools.util.ResourcePicker;
import oracle.jdeveloper.vcs.changelist.AsynchronousChangeList;
import oracle.jdeveloper.vcs.changelist.ChangeList;
import oracle.jdeveloper.vcs.changelist.ChangeListCommentsCustomizer;
import oracle.jdeveloper.vcs.changelist.ChangeListWindow;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSOverlayItemProducer;
import oracle.jdeveloper.vcs.spi.VCSPropertyMap;
import oracle.jdevimpl.vcs.generic.GenericClient;
import oracle.jdevimpl.vcs.generic.changelist.CLUtil;
import oracle.jdevimpl.vcs.generic.changelist.StatusBasedMultiChangeList;
import oracle.jdevimpl.vcs.generic.profile.ChangeListInfo;
import oracle.jdevimpl.vcs.generic.profile.PendingChangesInfo;
import oracle.jdevimpl.vcs.generic.profile.SectionInfo;
import oracle.jdevimpl.vcs.generic.util.VCSGenericUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StatusBasedChangeListWindow
extends ChangeListWindow {
    private static final String OPTIONS_VISIBLE_DT_PROP = ".changeListCommentsVisible";
    private final String _displayName;
    private GenericClient _profile;
    private PendingChangesInfo _pendingChangesInfo;
    private Map<ChangeListInfo, ChangeList> _infos;
    private ChangeListener _prefsListener;
    private HelpInfo _helpInfo;

    private void $init$() {
        this._infos = null;
    }

    public StatusBasedChangeListWindow(String windowId, VCSProfile profile) {
        super(((GenericClient)profile).getChangeLists(), windowId);
        this.$init$();
        this._profile = (GenericClient)profile;
        this._pendingChangesInfo = this._profile.getProfileInfo().getPendingChanges();
        String displayName = this._pendingChangesInfo.getDisplayName();
        if (displayName == null) {
            ResourcePicker res = ResourcePicker.getPicker(GenericClient.class);
            displayName = res.getString("PENDING_CHANGES_LABEL");
        }
        this._displayName = displayName;
        for (Map.Entry<ChangeListInfo, ChangeList> entry : this.getInfos().entrySet()) {
            if (!entry.getKey().includeCommentsUI()) continue;
            entry.getValue().addPropertyChangeListener("optionsVisible", new 1());
        }
        this.prefsChanged();
    }

    private Map<ChangeListInfo, ChangeList> getInfos() {
        if (this._infos != null) {
            return this._infos;
        }
        this._infos = new HashMap<ChangeListInfo, ChangeList>();
        ChangeList[] changeLists = this._profile.getChangeLists();
        if (this._profile != null) {
            ChangeListInfo[] changeListInfos = this._profile.getProfileInfo().getPendingChanges().getChangeLists().toArray(new ChangeListInfo[0]);
            if (changeLists.length != changeListInfos.length) {
                throw new IllegalStateException();
            }
            int i = 0;
            while (i < changeLists.length) {
                this._infos.put(changeListInfos[i], changeLists[i]);
                ++i;
            }
        }
        return this._infos;
    }

    public void resetChangeListInfos() {
        this._infos = null;
    }

    @Override
    public HelpInfo getHelpInfo() {
        if (this._pendingChangesInfo.getHelpId() == null) {
            return super.getHelpInfo();
        }
        if (this._helpInfo == null) {
            this._helpInfo = new HelpInfo(this._pendingChangesInfo.getHelpId());
        }
        return this._helpInfo;
    }

    @Override
    public String getTitleName() {
        return this._displayName;
    }

    @Override
    protected String getBusyStatusMessage(Object modeId) {
        ChangeList changeList = this.getChangeList(modeId);
        for (Map.Entry<ChangeListInfo, ChangeList> entry : this.getInfos().entrySet()) {
            if (changeList != entry.getValue() || entry.getKey().getBusyMessage() == null) continue;
            return entry.getKey().getBusyMessage();
        }
        return super.getBusyStatusMessage();
    }

    @Override
    protected void delayedInitialization() {
        for (Map.Entry<ChangeListInfo, ChangeList> entry : this.getInfos().entrySet()) {
            ChangeList cl = entry.getValue();
            if (cl instanceof StatusBasedMultiChangeList && cl.getStatusCache() == null) {
                cl.setStatusCache(this._profile.getStatusCache());
            }
            try {
                cl.setOverlayItemProducer(VCSGenericUtil.newOverlayProducer(this._profile, entry.getKey().getOverlayProducerClass()));
            }
            catch (ClassNotFoundException cnfe) {
                this._profile.getLogger().warning("could not find overlay producer class. using a default instance");
                cl.setOverlayItemProducer(new VCSOverlayItemProducer(this._profile.getStatusCache()));
            }
            if (entry.getKey().getVisibleStatuses() != null) {
                cl.setVisibleStatuses(CLUtil.toStatusArray(this._profile, entry.getKey().getVisibleStatuses().getStatusRefs()));
            }
            if (!entry.getKey().includeCommentsUI()) continue;
            cl.setOptionsCustomizer(new ChangeListCommentsCustomizer());
            cl.setOptionsVisible(Ide.getDTCache().getBoolean(this._profile.getID() + OPTIONS_VISIBLE_DT_PROP, false));
        }
        VCSPropertyMap prefs = this._pendingChangesInfo.getAdapter().getPreferences();
        if (prefs != null) {
            this._prefsListener = new 2();
            prefs.addChangeListener(this._prefsListener);
        }
    }

    @Override
    public void prefsChanged() {
        if (this._profile != null) {
            super.prefsChanged();
        }
    }

    @Override
    protected void preferencesChanged() {
        super.preferencesChanged();
        AsynchronousChangeList icl = this.getIncomingChangeList();
        if (icl != null) {
            icl.timerIntervalChanged();
        }
    }

    private AsynchronousChangeList getIncomingChangeList() {
        for (ChangeListInfo cli : this.getInfos().keySet()) {
            ChangeList cl = this._infos.get(cli);
            if (cl == null || !(cl instanceof AsynchronousChangeList)) continue;
            return (AsynchronousChangeList)cl;
        }
        return null;
    }

    @Override
    protected void postDeinitialization() {
        super.postDeinitialization();
        VCSPropertyMap prefs = this._pendingChangesInfo.getAdapter().getPreferences();
        if (prefs != null) {
            prefs.removeChangeListener(this._prefsListener);
            this._prefsListener = null;
        }
    }

    @Override
    protected void updateEllipsisItems() {
        if (this._profile == null) {
            return;
        }
        for (ChangeListInfo cli : this.getInfos().keySet()) {
            if (cli.getToolbar() == null) continue;
            Iterator j = cli.getToolbar().getSections().iterator();
            while (j.hasNext()) {
                for (String actionId : ((SectionInfo)j.next()).getActionRefs()) {
                    Integer cmdId = Ide.findCmdID((String)actionId);
                    if (cmdId == null) continue;
                    this.setEllipsisVisible(this.getLocalAction(cmdId), this._pendingChangesInfo == null || this._pendingChangesInfo.getAdapter() == null || !this._pendingChangesInfo.getAdapter().isActionSilent(this.getChangeList(cli.getID()), actionId));
                }
            }
        }
    }

    @Override
    protected void addToolbarActions(Toolbar toolbar) {
        this.updateVisibleToolbarActions(toolbar);
    }

    @Override
    protected void setCommentsVisible(boolean visible) {
        super.setCommentsVisible(visible);
        this.updateEllipsisItems();
    }

    private ChangeList getActiveChangeList() {
        return this._profile.getChangeList((String)this.getModeId());
    }

    private ChangeListInfo getChangeListInfo(ChangeList changeList) {
        for (Map.Entry<ChangeListInfo, ChangeList> entry : this.getInfos().entrySet()) {
            if (changeList != entry.getValue()) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    protected void updateVisibleToolbarActions(Toolbar toolbar) {
        super.updateVisibleToolbarActions(toolbar);
    }

    @Override
    protected void addCommentsToolbarAction(Toolbar toolbar) {
        ChangeList cl = this.getActiveChangeList();
        if (this.getChangeListInfo(cl).includeCommentsUI()) {
            super.addCommentsToolbarAction(toolbar);
        }
    }

    @Override
    protected void addContextMenuListeners(ContextMenu menu) {
        super.addContextMenuListeners(menu);
    }

    @Override
    protected void removeContextMenuListeners(ContextMenu menu) {
        super.removeContextMenuListeners(menu);
    }

    @Override
    protected String[] getPreferencesPath() {
        return this._pendingChangesInfo.getAdapter().getPreferencesPath();
    }

    static GenericClient ra$_profile(StatusBasedChangeListWindow statusBasedChangeListWindow) {
        return statusBasedChangeListWindow._profile;
    }

    final class 1
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent e) {
            if ("optionsVisible".equals(e.getPropertyName())) {
                Ide.getDTCache().putBoolean(StatusBasedChangeListWindow.ra$_profile(StatusBasedChangeListWindow.this).getID() + StatusBasedChangeListWindow.OPTIONS_VISIBLE_DT_PROP, (Boolean)e.getNewValue());
            }
        }
    }

    final class 2
    implements ChangeListener {
        public void stateChanged(ChangeEvent e) {
            StatusBasedChangeListWindow.this.prefsChanged();
        }
    }
}

