/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.generic.changelist;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Iterator;
import java.util.logging.Level;
import javax.swing.Icon;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToggleToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.view.View;
import oracle.jdeveloper.vcs.changelist.ChangeList;
import oracle.jdeveloper.vcs.changelist.ChangeListCommentsCustomizer;
import oracle.jdeveloper.vcs.changelist.ChangeListContextMenuListener;
import oracle.jdeveloper.vcs.changelist.ChangeListEventQueue;
import oracle.jdeveloper.vcs.changelist.ChangeListLocalStatusCache;
import oracle.jdeveloper.vcs.changelist.ChangeListWindow;
import oracle.jdeveloper.vcs.generic.MultiChangeList;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSOverlayItemProducer;
import oracle.jdeveloper.vcs.spi.VCSURLBasedCache;
import oracle.jdeveloper.vcs.vop.DisplayProperty;
import oracle.jdevimpl.vcs.generic.changelist.CLUtil;
import oracle.jdevimpl.vcs.generic.changelist.ExtendedDisplayProperty;
import oracle.jdevimpl.vcs.generic.changelist.MenuSectionMapping;
import oracle.jdevimpl.vcs.generic.profile.ChangeListInfo;
import oracle.jdevimpl.vcs.generic.profile.SectionInfo;
import oracle.jdevimpl.vcs.generic.profile.SectionsInfo;
import oracle.jdevimpl.vcs.generic.util.VCSGenericUtil;

public final class StatusBasedMultiChangeList
extends MultiChangeList {
    public static VCSProfile sContextProfile = null;
    public static ChangeListInfo sContextInfo = null;
    private VCSProfile _profile;
    private ChangeListInfo _info;
    private ChangeListLocalStatusCache _localCache;
    private ExtendedDisplayProperty[] _properties;
    private ContextMenuListener _contextMenu;
    private String _optVisDTCacheKey;
    private ToggleToolButton _toggleToolButton;

    public StatusBasedMultiChangeList(VCSProfile profile, ChangeListInfo info) {
        super(info.getID());
        this._profile = profile;
        this._info = info;
        if (this._localCache == null) {
            this._localCache = new ChangeListLocalStatusCache(this._profile.getStatusCache());
        }
        if (this._info.includeCommentsUI()) {
            this.addPropertyChangeListener("optionsVisible", new 1());
        }
    }

    public void addToolbarActions(ChangeListWindow window, Toolbar toolbar) {
        toolbar.removeAll();
        super.addToolbarActions(window, toolbar);
        if (this.getInfo().includeCommentsUI()) {
            if (this._toggleToolButton == null) {
                this._toggleToolButton = new ToggleToolButton((ToggleAction)this.getLocalAction((View)window, ChangeListWindow.TOGGLE_COMMENTS_CMD_ID));
            }
            toolbar.addSeparator();
            toolbar.add((Component)this._toggleToolButton);
        }
        Iterator i = this.getInfo().getToolbar().getSections().iterator();
        while (i.hasNext()) {
            toolbar.addSeparator();
            Iterator j = ((SectionInfo)i.next()).getActionRefs().iterator();
            while (j.hasNext()) {
                toolbar.add((ToggleAction)this.getLocalAction((View)window, Ide.findCmdID((String)((String)j.next()))));
            }
        }
    }

    protected Icon getModeIcon() {
        return null;
    }

    protected String getModeLabel() {
        return this.getInfo().getDisplayName();
    }

    protected String getBusyStatusMessage() {
        return this.getInfo().getBusyMessage();
    }

    protected void initializeChangeList() {
        this.setStatusCache(this.getLocalCache());
        try {
            this.setOverlayItemProducer(VCSGenericUtil.newOverlayProducer(this._profile, this._info.getOverlayProducerClass()));
        }
        catch (ClassNotFoundException cnfe) {
            this._profile.getLogger().warning("could not find overlay producer class. using a default instance");
            this.setOverlayItemProducer(new VCSOverlayItemProducer(this._profile.getStatusCache()));
        }
        this.setVisibleStatuses(CLUtil.toStatusArray(this.getProfile(), this.getInfo().getVisibleStatuses().getStatusRefs()));
        if (this.getInfo().includeCommentsUI()) {
            this.setOptionsCustomizer(new ChangeListCommentsCustomizer());
            this.setOptionsVisible(this.readOptionVisibilityFromDTCache());
        }
    }

    protected DisplayProperty[] createDisplayProperties() {
        if (this._properties == null) {
            try {
                this._properties = CLUtil.createDisplayProperties(this.getInfo().getDisplayProperties());
            }
            catch (ClassNotFoundException cnfe) {
                this.getProfile().getLogger().log(Level.SEVERE, "display property resolver class not found", cnfe);
                DisplayProperty[] displayPropertyArray = new DisplayProperty[]{};
                return displayPropertyArray;
            }
        }
        return this._properties;
    }

    protected ChangeListEventQueue createEventQueue() {
        return CLUtil.createEventQueue(this.getProfile(), this, this.getInfo());
    }

    protected void addContextMenuListeners(ContextMenu menu) {
        this._contextMenu = new ContextMenuHandler(this, null);
        menu.addContextMenuListener(this._contextMenu);
    }

    protected void removeContextMenuListeners(ContextMenu menu) {
        menu.removeContextMenuListener(this._contextMenu);
        this._contextMenu = null;
    }

    protected Object getModelValue(URL item, DisplayProperty property) throws Exception {
        if (property instanceof ExtendedDisplayProperty) {
            ExtendedDisplayProperty prop = (ExtendedDisplayProperty)property;
            return this._profile.getPendingChangesAdapter().resolvePropertyValue(this._info.getID(), prop.getID(), item);
        }
        return super.getModelValue(item, property);
    }

    private boolean readOptionVisibilityFromDTCache() {
        return Ide.getDTCache().getBoolean(this.getOptionVisibilityCacheKey(), false);
    }

    private void writeOptionVisibilityToDTCache(boolean visible) {
        Ide.getDTCache().putBoolean(this.getOptionVisibilityCacheKey(), visible);
    }

    private String getOptionVisibilityCacheKey() {
        if (this._optVisDTCacheKey == null) {
            this._optVisDTCacheKey = this.getProfile().getID() + "." + this.getInfo().getID() + ".optionsVisible";
        }
        return this._optVisDTCacheKey;
    }

    private IdeAction getLocalAction(View view, int cmdId) {
        IdeAction action = IdeAction.find((int)cmdId);
        if (action != null) {
            return action.newLocalAction(view);
        }
        throw new IllegalArgumentException("Command with id " + cmdId + " not found");
    }

    private VCSProfile getProfile() {
        if (this._profile == null) {
            if (sContextProfile == null) {
                throw new IllegalStateException();
            }
            this._profile = sContextProfile;
        }
        return this._profile;
    }

    private ChangeListInfo getInfo() {
        if (this._info == null) {
            if (sContextInfo == null) {
                throw new IllegalStateException();
            }
            this._info = sContextInfo;
        }
        return this._info;
    }

    private VCSURLBasedCache getLocalCache() {
        if (this._localCache == null) {
            this._localCache = new ChangeListLocalStatusCache(this.getProfile().getStatusCache());
        }
        return this._localCache;
    }

    protected String[] getPreferencesPath() {
        return this._profile.getPendingChangesAdapter().getPreferencesPath();
    }

    protected String getTabToggleKey() {
        return this._info.getTabToggleKey();
    }

    static ChangeListInfo mav$getInfo(StatusBasedMultiChangeList statusBasedMultiChangeList) {
        return statusBasedMultiChangeList.getInfo();
    }

    static void mav$writeOptionVisibilityToDTCache(StatusBasedMultiChangeList statusBasedMultiChangeList, boolean bl) {
        statusBasedMultiChangeList.writeOptionVisibilityToDTCache(bl);
    }

    final class 1
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent pce) {
            if ("optionsVisible".equals(pce.getPropertyName())) {
                StatusBasedMultiChangeList.mav$writeOptionVisibilityToDTCache(StatusBasedMultiChangeList.this, (Boolean)pce.getNewValue());
            }
        }
    }

    private final class ContextMenuHandler
    extends ChangeListContextMenuListener {
        private ContextMenuHandler(ChangeList changeList) {
            super(changeList);
        }

        protected void menuWillShowImpl(ContextMenu popup) {
            if (StatusBasedMultiChangeList.this.getPreferencesPath() != null) {
                this.addMenuItemPreferences(popup);
            }
            if (popup.getContext().getSelection().length == 0 || this.getChangeList().isFocusInOptions()) {
                return;
            }
            SectionsInfo sections = StatusBasedMultiChangeList.mav$getInfo(StatusBasedMultiChangeList.this).getContextMenu();
            if (sections == null) {
                return;
            }
            for (SectionInfo sectionInfo : sections.getSections()) {
                float section = MenuSectionMapping.getSection(sectionInfo.getID());
                Iterator j = sectionInfo.getActionRefs().iterator();
                while (j.hasNext()) {
                    popup.add((Component)popup.createMenuItem((ToggleAction)this.getLocalAction(popup, (int)Ide.findCmdID((String)((String)j.next())))), section);
                }
            }
            this.addMenuItemCompare(popup);
        }

        ContextMenuHandler(ChangeList changeList, 1 var3_3) {
            this(changeList);
        }

        public final class 1 {
        }
    }
}

