/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.generic.util;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.jdeveloper.vcs.spi.VCSCancelException;
import oracle.jdeveloper.vcs.spi.VCSCancellable;

public final class DirectoryCopier {
    private final URL _sourceDirectory;
    private final URL _targetDirectory;
    private final URLFilter _filter;
    private final VCSCancellable _cancellable;
    private boolean _copyEmptyDirecotries;

    public DirectoryCopier(URL sourceDirectory, URL targetDirectory, URLFilter filter, VCSCancellable cancellable) {
        if (!this.existant(sourceDirectory) || !URLFileSystem.canRead((URL)sourceDirectory)) {
            throw new IllegalArgumentException(URLFileSystem.getPlatformPathName((URL)sourceDirectory));
        }
        if (!this.existant(targetDirectory) || !URLFileSystem.canWrite((URL)targetDirectory)) {
            throw new IllegalArgumentException(URLFileSystem.getPlatformPathName((URL)targetDirectory));
        }
        this._sourceDirectory = sourceDirectory;
        this._targetDirectory = targetDirectory;
        this._filter = filter != null ? filter : new 1();
        this._cancellable = cancellable;
        this._copyEmptyDirecotries = false;
    }

    public DirectoryCopier(URL sourceDirectory, URL targetDirectory, URLFilter filter, VCSCancellable cancellable, boolean copyEmptyDirecotries) {
        this(sourceDirectory, targetDirectory, filter, cancellable);
        this._copyEmptyDirecotries = copyEmptyDirecotries;
    }

    public void performCopy() throws IOException, VCSCancelException {
        Collection copyable = this.getCopyableURLs();
        Iterator it = copyable.iterator();
        String srcDirPath = URLFileSystem.getPath((URL)this._sourceDirectory);
        while (it.hasNext()) {
            if (this._cancellable.isCancelled()) {
                throw new VCSCancelException();
            }
            URL source = (URL)it.next();
            String relativePath = URLFileSystem.getPath((URL)source).substring(srcDirPath.length());
            URL destination = URLFactory.newURL((URL)this._targetDirectory, (String)relativePath);
            if (URLFileSystem.isDirectoryPath((URL)source)) {
                URLFileSystem.mkdirs((URL)destination);
                continue;
            }
            URLFileSystem.copy((URL)source, (URL)destination);
        }
    }

    private Collection getCopyableURLs() throws VCSCancelException {
        LinkedHashSet copyable = new LinkedHashSet(100);
        this.listFiles(this._sourceDirectory, copyable);
        return copyable;
    }

    private void listFiles(URL directory, Collection listing) throws VCSCancelException {
        if (this._cancellable.isCancelled()) {
            throw new VCSCancelException();
        }
        URL[] children = URLFileSystem.list((URL)directory, (URLFilter)this._filter);
        int i = 0;
        while (i < children.length) {
            if (URLFileSystem.isDirectory((URL)children[i])) {
                if (this._copyEmptyDirecotries && URLFileSystem.list((URL)children[i], (URLFilter)this._filter).length == 0) {
                    listing.add(children[i]);
                } else {
                    this.listFiles(children[i], listing);
                }
            } else {
                if (this._cancellable.isCancelled()) {
                    throw new VCSCancelException();
                }
                listing.add(children[i]);
            }
            ++i;
        }
    }

    private boolean existant(URL dirUrl) {
        return URLFileSystem.exists((URL)dirUrl) && URLFileSystem.isDirectory((URL)dirUrl);
    }

    final class 1
    implements URLFilter {
        public boolean accept(URL url) {
            return true;
        }
    }
}

