/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.generic.util;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.cmd.FileOpenHistory;
import oracle.ide.cmd.NewWorkspaceCommand;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.ProjectMigrator;
import oracle.ide.model.ProjectVersion;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.util.Assert;
import oracle.ide.util.IdeUtil;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.ResourcePicker;
import oracle.jdeveloper.compiler.BuildSystemConfiguration;
import oracle.jdeveloper.model.ApplicationContent;
import oracle.jdeveloper.model.JavaProject;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdeveloper.vcs.spi.VCSFileEventSender;
import oracle.jdeveloper.vcs.spi.VCSNewProjectPanel;
import oracle.jdevimpl.compiler.CompilerOptionManager;
import oracle.jdevimpl.vcs.generic.GenericClient;
import oracle.jdevimpl.vcs.generic.util.VCSDirectoryWatcher;
import oracle.jdevimpl.vcs.util.FileHandler;
import oracle.jdevimpl.vcs.util.SimpleChoiceDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NewFilesHandler
extends FileHandler {
    private final VCSDirectoryWatcher _watcher;
    private final URLFilter _versionedFilter;
    private String _hintText;
    private URL _projectDirURL;

    private void $init$() {
        this._hintText = null;
    }

    public NewFilesHandler(VCSDirectoryWatcher watcher, URLFilter versionedFilter) {
        this.$init$();
        this._watcher = watcher;
        this._versionedFilter = versionedFilter;
    }

    public void setNewProjectDirectory(URL url) {
        this._projectDirURL = url;
    }

    public void setDialogHintText(String text) {
        this._hintText = text;
    }

    public void handleNewFiles(Context context, String name) throws Exception {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new 1(this, context, name));
        } else {
            this.handleNewFilesImpl(context, name);
        }
    }

    private void handleNewFilesImpl(Context context, String name) throws Exception {
        VCSFileEventSender.fireFileStructureChanged(this._watcher.getNewRegularURLs().toArray(new URL[0]));
        if (this._watcher.hasNewWorkspaces()) {
            NewFilesHandler.openWorkspaces(context, this._watcher.getNewWorkspaces());
            return;
        }
        Workspace activeWorkspace = this.getActiveWorkspace(context);
        if (activeWorkspace == null) {
            IdeUtil.invokeAfterRepaint((Runnable)new 2(this, context, name));
            return;
        }
        if (!this._watcher.hasNewProjects()) {
            this.handleNoProjects(context, this._watcher, activeWorkspace, name);
        }
        this.openProjectsInWorkspace(context, activeWorkspace, this._watcher);
    }

    private URL createWorkspaceURL(URL baseDir, String name) {
        return URLFactory.newURL((URL)baseDir, (String)(NewFilesHandler.convertToFileName(name) + ".jws"));
    }

    private void openProjectsInWorkspace(Context context, Workspace workspace, VCSDirectoryWatcher watcher) throws IllegalAccessException, InstantiationException {
        if (!watcher.hasNewProjects()) {
            return;
        }
        for (URL url : watcher.getNewProjects()) {
            NodeFactory.uncache((URL)url);
            Node node = NodeFactory.findOrCreate((URL)url);
            if (node == null || !(node instanceof Project) || workspace.containsChild((Element)node) || !NewFilesHandler.migrateSystemFile(node)) continue;
            workspace.add((Element)node, true);
            FileOpenHistory.getInstance().updateProjectHistory(node.getURL());
            NewFilesHandler.selectNavigatorTNode(context, (Element)node);
        }
    }

    private Workspace getActiveWorkspace(Context context) {
        Workspace contextWorkspace = context.getWorkspace();
        if (contextWorkspace == null) {
            contextWorkspace = Ide.getActiveWorkspace();
        }
        Iterator it = Ide.getWorkspaces().getChildren();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof Workspace) || contextWorkspace != null && o != contextWorkspace) continue;
            return (Workspace)o;
        }
        return null;
    }

    private void handleNoProjects(Context context, VCSDirectoryWatcher watcher, Workspace activeWorkspace, String name) throws IOException, IllegalAccessException, InstantiationException {
        SimpleChoiceDialog dialog;
        ResourcePicker picker = ResourcePicker.getPicker(GenericClient.class);
        ArrayList<String> cText = new ArrayList<String>();
        cText.add(picker.getString("NEW_FILES_CHOICE_OPEN_FILES"));
        cText.add(picker.getString("NEW_FILES_CHOICE_CREATE_NEW_PROJECT"));
        cText.add(picker.getString("NEW_FILES_CHOICE_EDIT_FILES"));
        cText.add(picker.getString("NEW_FILES_CHOICE_DO_NOT_OPEN"));
        Project activeProject = NewFilesHandler.determineActiveProject(context);
        Collection<URL> urls = watcher.getFileListing();
        if (activeProject != null) {
            ContentSet contentSet = ProjectContent.getInstance((PropertyStorage)activeProject).getContentSet(PathsConfiguration.JAVA_CONTENT_SET_KEY);
            Assert.check((contentSet != null ? 1 : 0) != 0);
            URL newProjectDirectoryUrl = this.getNewProjectDirectory(urls);
            Assert.check((newProjectDirectoryUrl != null ? 1 : 0) != 0);
            if (newProjectDirectoryUrl == null) {
                return;
            }
            if (contentSet.canHaveMember(newProjectDirectoryUrl)) {
                return;
            }
        }
        if (activeProject == null) {
            cText.remove(picker.getString("NEW_FILES_CHOICE_OPEN_FILES"));
        }
        if ((dialog = new SimpleChoiceDialog(picker.getString("NEW_FILES_TITLE"), picker.getString("NEW_FILE_PROMPT"), cText.toArray(new String[0]), null)).show()) {
            int choice = dialog.getChoice();
            if (choice == cText.indexOf(picker.getString("NEW_FILES_CHOICE_OPEN_FILES"))) {
                URL newProjectDirectoryUrl = this.getNewProjectDirectory(urls);
                ContentSet contentSet = ProjectContent.getInstance((PropertyStorage)activeProject).getContentSet(PathsConfiguration.JAVA_CONTENT_SET_KEY);
                contentSet.getURLPath().add(newProjectDirectoryUrl);
                UpdateMessage.fireStructureChanged((Subject)activeProject);
            } else if (choice == cText.indexOf(picker.getString("NEW_FILES_CHOICE_CREATE_NEW_PROJECT"))) {
                this.createNewProject(context, urls, activeWorkspace, name);
            } else if (choice == cText.indexOf(picker.getString("NEW_FILES_CHOICE_EDIT_FILES"))) {
                this.openNewFiles(urls);
            } else if (choice == cText.indexOf(picker.getString("NEW_FILES_CHOICE_DO_NOT_OPEN"))) {
                // empty if block
            }
        }
    }

    private void openNewFiles(Collection<URL> urls) {
        IdeUtil.invokeAfterRepaint((Runnable)new 3(this, urls));
    }

    private void createNewProject(Context context, Collection<URL> urls, Workspace activeWorkspace, String name) throws IOException, IllegalAccessException, InstantiationException {
        ResourcePicker picker = ResourcePicker.getPicker(GenericClient.class);
        URL newProjectDirectoryUrl = this.getNewProjectDirectory(urls);
        URL projectUrl = VCSNewProjectPanel.getProjectURL(newProjectDirectoryUrl, NewFilesHandler.convertToFileName(name), picker.getString("PROJECT_MSG_FILE_TYPE"), this._hintText != null ? this._hintText : picker.getString("PROJECT_TITLE_DIALOG"));
        if (projectUrl == null) {
            return;
        }
        Project defaultProject = Ide.getDefaultProject();
        Project project = defaultProject != null ? (Project)NodeFactory.clone((Node)defaultProject, (URL)projectUrl) : (Project)NodeFactory.findOrCreate(Project.class, (URL)projectUrl);
        project.applyBatchChanges((Runnable)new 4(this, project, activeWorkspace));
        NodeFactory.recache((URL)projectUrl, (URL)projectUrl, (Node)project);
        activeWorkspace.add((Element)project, true);
        ContentSet contentSet = ProjectContent.getInstance((PropertyStorage)project).getContentSet(PathsConfiguration.JAVA_CONTENT_SET_KEY);
        contentSet.getURLPath().setEntries(new URL[0]);
        contentSet.getURLPath().add(newProjectDirectoryUrl);
        project.save();
        UpdateMessage.fireStructureChanged((Subject)project);
        NewFilesHandler.selectNavigatorTNode(context, (Element)project);
    }

    private final URL getNewProjectDirectory(Collection urls) {
        URL durl;
        if (this._projectDirURL != null) {
            return this._projectDirURL;
        }
        if (urls.size() <= 0) {
            return null;
        }
        URL url = (URL)urls.iterator().next();
        URL directoryUrl = null;
        while ((durl = URLFileSystem.getParent((URL)url)) != null && this._versionedFilter.accept(url)) {
            directoryUrl = url = durl;
        }
        return directoryUrl;
    }

    static VCSDirectoryWatcher ra$_watcher(NewFilesHandler newFilesHandler) {
        return newFilesHandler._watcher;
    }

    static URL mav$createWorkspaceURL(NewFilesHandler newFilesHandler, URL uRL, String string) {
        return newFilesHandler.createWorkspaceURL(uRL, string);
    }

    static void mav$openProjectsInWorkspace(NewFilesHandler newFilesHandler, Context context, Workspace workspace, VCSDirectoryWatcher vCSDirectoryWatcher) {
        newFilesHandler.openProjectsInWorkspace(context, workspace, vCSDirectoryWatcher);
    }

    static void mav$handleNoProjects(NewFilesHandler newFilesHandler, Context context, VCSDirectoryWatcher vCSDirectoryWatcher, Workspace workspace, String string) {
        newFilesHandler.handleNoProjects(context, vCSDirectoryWatcher, workspace, string);
    }

    static void mav$handleNewFilesImpl(NewFilesHandler newFilesHandler, Context context, String string) {
        newFilesHandler.handleNewFilesImpl(context, string);
    }

    final class 1
    implements Runnable {
        private final /* synthetic */ Context v$context;
        private final /* synthetic */ String v$name;
        final /* synthetic */ NewFilesHandler this$0;

        public void run() {
            try {
                NewFilesHandler.mav$handleNewFilesImpl(this.this$0, this.v$context, this.v$name);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public 1(NewFilesHandler newFilesHandler, Context context, String string) {
            this.v$name = string;
            this.v$context = context;
            this.this$0 = newFilesHandler;
        }
    }

    final class 2
    implements Runnable {
        private final /* synthetic */ Context v$context;
        private final /* synthetic */ String v$name;
        final /* synthetic */ NewFilesHandler this$0;

        public void run() {
            try {
                Workspace workspace = NewWorkspaceCommand.createEmptyWorkspace((Context)this.v$context, (URL)NewFilesHandler.mav$createWorkspaceURL(this.this$0, NewFilesHandler.ra$_watcher(this.this$0).getWatchedDirectory(), this.v$name));
                NewFilesHandler.mav$openProjectsInWorkspace(this.this$0, this.v$context, workspace, NewFilesHandler.ra$_watcher(this.this$0));
                if (!NewFilesHandler.ra$_watcher(this.this$0).hasNewProjects()) {
                    NewFilesHandler.mav$handleNoProjects(this.this$0, this.v$context, NewFilesHandler.ra$_watcher(this.this$0), workspace, this.v$name);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public 2(NewFilesHandler newFilesHandler, Context context, String string) {
            this.v$name = string;
            this.v$context = context;
            this.this$0 = newFilesHandler;
        }
    }

    final class 3
    implements Runnable {
        private final /* synthetic */ Collection v$urls;
        final /* synthetic */ NewFilesHandler this$0;

        public void run() {
            for (URL url : this.v$urls) {
                String suffix = URLFileSystem.getSuffix((URL)url);
                if (suffix.equals(".jpr") || suffix.equals(".jws")) continue;
                try {
                    EditorManager.getEditorManager().openDefaultEditorInFrame(url);
                }
                catch (Exception e) {
                    Assert.printStackTrace((Throwable)e);
                }
            }
        }

        public 3(NewFilesHandler newFilesHandler, Collection collection) {
            this.v$urls = collection;
            this.this$0 = newFilesHandler;
        }
    }

    final class 4
    implements Runnable {
        private final /* synthetic */ Project v$project;
        private final /* synthetic */ Workspace v$activeWorkspace;
        final /* synthetic */ NewFilesHandler this$0;

        public void run() {
            CompilerOptionManager optionManager = CompilerOptionManager.getInstance((PropertyStorage)this.v$project);
            optionManager.setToDefaultOptions();
            BuildSystemConfiguration buildConfig = BuildSystemConfiguration.getInstance((PropertyStorage)this.v$project);
            if (buildConfig != null) {
                buildConfig.setCurrentEncoding(IdeUtil.getIdeEncoding());
            }
            ProjectContent.initializeContentSets((Project)this.v$project);
            ProjectVersion.initializeVersions((PropertyStorage)this.v$project, (String)ProjectMigrator.MIGRATOR_NAME);
            ApplicationContent content = ApplicationContent.getInstance((Workspace)this.v$activeWorkspace);
            String pkgName = content.getAppPackagePrefix();
            pkgName = pkgName != null ? pkgName : "";
            this.v$project.getProperties().putString("defaultPackage", pkgName);
            JavaProject.getInstance((Project)this.v$project).setMostRecentPackage(pkgName);
        }

        public 4(NewFilesHandler newFilesHandler, Project project, Workspace workspace) {
            this.v$activeWorkspace = workspace;
            this.v$project = project;
            this.this$0 = newFilesHandler;
        }
    }
}

