/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.generic.util;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import oracle.ide.config.GlobalIgnoreList;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.net.VirtualFileSystemHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VCSDirectoryWatcher {
    public static final int OPTION_CONSIDER_FILES = 1;
    public static final int OPTION_CONSIDER_DIRECTORIES = 2;
    public static final int OPTION_RECURSIVE = 4;
    private final Collection<Collection> _listings;
    private final Collection _newWorkspaces;
    private final Collection _newProjects;
    private final Collection _newRegulars;
    private final URL _watchedDirectory;
    private int _options;
    private boolean _watching;

    private void $init$() {
        this._listings = new ArrayList<Collection>(5);
        this._newWorkspaces = new ArrayList(10);
        this._newProjects = new ArrayList(10);
        this._newRegulars = new ArrayList(10);
    }

    public VCSDirectoryWatcher(URL directory) {
        this.$init$();
        this._watchedDirectory = directory;
        this._watching = false;
        this._options = 5;
    }

    public VCSDirectoryWatcher(URL directory, int options) {
        this.$init$();
        this._watchedDirectory = directory;
        this._watching = false;
        this._options = options;
    }

    public URL getWatchedDirectory() {
        return this._watchedDirectory;
    }

    public Collection<URL> getFileListing() {
        ArrayList<URL> urls = new ArrayList<URL>();
        Iterator<Collection> list = this._listings.iterator();
        while (list.hasNext()) {
            urls.addAll(list.next());
        }
        return urls;
    }

    public synchronized void beginWatch() {
        if (this._watching) {
            throw new IllegalStateException();
        }
        this._watching = true;
        this._listings.clear();
        this._newWorkspaces.clear();
        this._newProjects.clear();
        this._listings.add(this.createSnapshot());
    }

    public synchronized void endWatch() {
        if (!this._watching) {
            throw new IllegalStateException();
        }
        this._listings.add(this.createSnapshot());
        Iterator<Collection> it = this._listings.iterator();
        this.inspectListings(it.next(), it.next());
        this._watching = false;
    }

    public boolean hasNewWorkspaces() {
        return this._newWorkspaces.size() > 0;
    }

    public Collection getNewWorkspaces() {
        return Collections.unmodifiableCollection(this._newWorkspaces);
    }

    public boolean hasNewProjects() {
        return this._newProjects.size() > 0;
    }

    public Collection getNewProjects() {
        return Collections.unmodifiableCollection(this._newProjects);
    }

    public boolean hasNewRegularURLs() {
        return this._newRegulars.size() > 0;
    }

    public Collection getNewRegularURLs() {
        return Collections.unmodifiableCollection(this._newRegulars);
    }

    private void inspectListings(Collection listing, Collection laterListing) {
        Collection newUrls = laterListing;
        newUrls.removeAll(listing);
        for (URL newUrl : newUrls) {
            String name = URLFileSystem.getPlatformPathName((URL)newUrl);
            if (name.endsWith(".jws")) {
                this._newWorkspaces.add(newUrl);
                continue;
            }
            if (name.endsWith(".jpr")) {
                this._newProjects.add(newUrl);
                continue;
            }
            this._newRegulars.add(newUrl);
        }
    }

    public String toString() {
        StringBuffer buff = new StringBuffer(100);
        buff.append(super.toString()).append(": [base=");
        buff.append(URLFileSystem.getPlatformPathName((URL)this._watchedDirectory));
        buff.append("] ");
        if (this._watching) {
            buff.append(" [watch in progress]");
            return buff.toString();
        }
        if (this.hasNewWorkspaces()) {
            buff.append(" [workspaces=");
            Iterator it = this._newWorkspaces.iterator();
            while (it.hasNext()) {
                buff.append(URLFileSystem.getPlatformPathName((URL)((URL)it.next())));
                if (!it.hasNext()) continue;
                buff.append(',');
            }
            buff.append(']');
        }
        if (this.hasNewProjects()) {
            buff.append(" [projects=");
            Iterator it = this._newProjects.iterator();
            while (it.hasNext()) {
                buff.append(URLFileSystem.getPlatformPathName((URL)((URL)it.next())));
                if (!it.hasNext()) continue;
                buff.append(',');
            }
            buff.append(']');
        }
        if (!this.hasNewWorkspaces() && !this.hasNewProjects()) {
            buff.append(" [no new interesting urls]");
        }
        return buff.toString();
    }

    private Collection createSnapshot() {
        if (this.isRecursive()) {
            VirtualFileSystemHelper.invalidateDirectoryTree((URL)this._watchedDirectory);
        } else {
            VirtualFileSystemHelper.invalidateDirectory((URL)this._watchedDirectory);
        }
        ArrayList urls = new ArrayList(100);
        this.listFiles(this._watchedDirectory, urls);
        return urls;
    }

    private void listFiles(URL directory, Collection urls) {
        URL[] listing = URLFileSystem.list((URL)directory, (URLFilter)GlobalIgnoreList.getURLFilter());
        if (listing == null || listing.length == 0) {
            return;
        }
        int i = 0;
        while (i < listing.length) {
            boolean isDirectoryPath = URLFileSystem.isDirectoryPath((URL)listing[i]);
            if (this.considerDirectories() && isDirectoryPath) {
                urls.add(listing[i]);
            }
            if (this.considerFiles() && !isDirectoryPath) {
                urls.add(listing[i]);
            }
            if (this.isRecursive() && isDirectoryPath) {
                this.listFiles(listing[i], urls);
            }
            ++i;
        }
    }

    private boolean isRecursive() {
        return (this._options & 4) > 0;
    }

    private boolean considerFiles() {
        return (this._options & 1) > 0;
    }

    private boolean considerDirectories() {
        return (this._options & 2) > 0;
    }
}

