/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.generic.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Locatable;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSOverlayItemProducer;
import oracle.jdeveloper.vcs.spi.VCSStatusCache;
import oracle.jdeveloper.vcs.util.VCSContextUtils;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdeveloper.vcs.util.VCSModelUtils;

public class VCSGenericUtil {
    public static VCSOverlayItemProducer newOverlayProducer(VCSProfile profile, Class theClass) {
        try {
            if (theClass == null) {
                profile.getLogger().fine("using a default overlay item producer");
                VCSOverlayItemProducer vCSOverlayItemProducer = new VCSOverlayItemProducer(profile.getStatusCache());
                return vCSOverlayItemProducer;
            }
            try {
                Constructor theConstructor = theClass.getConstructor(VCSStatusCache.class);
                VCSOverlayItemProducer vCSOverlayItemProducer = (VCSOverlayItemProducer)theConstructor.newInstance(profile.getStatusCache());
                return vCSOverlayItemProducer;
            }
            catch (NoSuchMethodException nsme) {
                profile.getLogger().warning("using default constructor for " + theClass.getName());
                VCSOverlayItemProducer theInstance = (VCSOverlayItemProducer)theClass.newInstance();
                try {
                    Method theMethod = theClass.getMethod("setStatusCache", VCSStatusCache.class);
                    theMethod.invoke((Object)theInstance, profile.getStatusCache());
                    VCSOverlayItemProducer vCSOverlayItemProducer = theInstance;
                    return vCSOverlayItemProducer;
                }
                catch (NoSuchMethodException nsme1) {
                    profile.getLogger().warning("could not find method 'setStatusCache' on " + theClass.getName() + ", assuming no arg constructor sufficient");
                    VCSOverlayItemProducer vCSOverlayItemProducer = theInstance;
                    return vCSOverlayItemProducer;
                }
            }
        }
        catch (Exception e) {
            Exception cause = e instanceof InvocationTargetException ? ((InvocationTargetException)e).getTargetException() : e;
            profile.getLogger().log(Level.SEVERE, "unable to instantiate overlay item producer, using a default instance", cause);
            VCSOverlayItemProducer vCSOverlayItemProducer = new VCSOverlayItemProducer(profile.getStatusCache());
            return vCSOverlayItemProducer;
        }
    }

    public static URL getContextDirectoryURL(Context context, VCSProfile profile) {
        URL defaultUrl = URLFactory.newDirURL((String)Ide.getWorkDirectory());
        if (defaultUrl == null || !URLFileSystem.exists((URL)defaultUrl)) {
            defaultUrl = URLFactory.newDirURL((String)System.getProperty("user.home"));
        }
        if (context == null) {
            return defaultUrl;
        }
        if (VCSModelUtils.findCachedProjects().length <= 0) {
            return defaultUrl;
        }
        Locatable[] locatables = VCSContextUtils.getContextLocatables(context, profile.getURLFilter("oracle.jdeveloper.vcs.filters.url.DEFAULT"));
        if (locatables.length <= 0) {
            return defaultUrl;
        }
        URL[] contextUrls = VCSModelUtils.convertNodesToURLs(locatables);
        ArrayList<URL> contextDirectoryUrls = new ArrayList<URL>();
        int i = 0;
        while (i < contextUrls.length) {
            URL contextDirectoryUrl;
            URL contextUrl = locatables[i].getURL();
            URL uRL = contextDirectoryUrl = URLFileSystem.isDirectoryPath((URL)contextUrl) || URLFileSystem.isDirectory((URL)contextUrl) ? contextUrl : URLFileSystem.getParent((URL)contextUrl);
            if (URLFileSystem.exists((URL)contextDirectoryUrl)) {
                contextDirectoryUrls.add(contextDirectoryUrl);
            }
            ++i;
        }
        URL[] coalescedUrls = VCSFileSystemUtils.coalesceURLs(contextDirectoryUrls.toArray(new URL[0]));
        return coalescedUrls.length > 0 ? coalescedUrls[0] : defaultUrl;
    }
}

