/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.util;

import java.awt.Component;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.MenuElement;
import oracle.ide.Ide;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToolButton;
import oracle.ide.controls.ToolbarGroup;

public class CheckBoxMenuToolButton
extends ToolButton
implements ToolbarGroup {
    protected ToggleAction[] actions;
    protected ArrayList hiddenItems;

    public CheckBoxMenuToolButton(ToggleAction[] actions, ToggleAction defaultAction) {
        super((Action)defaultAction);
        this.setMenuStyle(true);
        this.actions = actions;
        int i = 0;
        while (i < actions.length) {
            ToggleAction action = actions[i];
            JMenuItem item = this.addPopupItem(action);
            ++i;
        }
    }

    public JMenuItem addPopupItem(ToggleAction action) {
        JMenuItem item;
        if (this.popup == null) {
            this.createPopupMenu();
        }
        if ((item = this.findPopupItem(action)) == null) {
            Object hidden;
            item = Ide.getMenubar().createMenuItem(action);
            Object object = hidden = action != null ? action.getValue("Hidden") : null;
            if (hidden instanceof Boolean && ((Boolean)hidden).booleanValue()) {
                if (this.hiddenItems == null) {
                    this.hiddenItems = new ArrayList(1);
                }
                this.hiddenItems.add(item);
            } else {
                this.popup.add(item);
                this.layoutToolbar();
            }
        }
        return item;
    }

    public void removePopupItem(ToggleAction action) {
        JMenuItem item = this.findPopupItem(action);
        if (item != null) {
            if (this.hiddenItems != null && this.hiddenItems.contains(item)) {
                this.hiddenItems.remove(item);
            } else {
                this.popup.remove(item);
                this.layoutToolbar();
            }
        }
    }

    public JMenuItem findPopupItem(ToggleAction action) {
        if (this.popup != null) {
            MenuElement[] elements = this.popup.getSubElements();
            int i = 0;
            while (i < elements.length) {
                JMenuItem item;
                Action itemAction;
                Component c = elements[i].getComponent();
                if (c instanceof JMenuItem && (itemAction = (item = (JMenuItem)c).getAction()) != null && itemAction.equals(action)) {
                    return item;
                }
                ++i;
            }
        }
        if (this.hiddenItems != null) {
            int i = this.hiddenItems.size() - 1;
            while (i >= 0) {
                JMenuItem item;
                Action itemAction;
                Object object = this.hiddenItems.get(i);
                if (object instanceof JMenuItem && (itemAction = (item = (JMenuItem)object).getAction()) != null && itemAction.equals(action)) {
                    return item;
                }
                --i;
            }
        }
        return null;
    }

    public void setAction(Action action) {
        super.setAction(action);
        if (action == null) {
            int i = 0;
            while (this.actions != null && i < this.actions.length) {
                Action menuItemAction;
                JMenuItem menuItem = this.findPopupItem(this.actions[i]);
                if (menuItem != null && (menuItemAction = menuItem.getAction()) != null) {
                    menuItem.setAction(null);
                }
                ++i;
            }
        }
    }

    protected void updateIcon(Object source) {
        if (source instanceof AbstractButton) {
            Action action = ((AbstractButton)source).getAction();
            Icon icon = (Icon)action.getValue("SmallIcon");
            this.setIcon(icon);
            this.setPressedIcon(icon);
            this.setSelectedIcon(icon);
            this.setAction(action);
        }
    }

    public Action[] getActions() {
        return this.actions;
    }
}

