/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.util;

public class DelimitedStrings {
    private static final DelimitedStrings CSV = new DelimitedStrings(",", new Character('\"'));
    private static final DelimitedStrings TSV = new DelimitedStrings("\t", new Character('\"'));
    private final String _delimiters;
    private final Character _qualifier;

    public DelimitedStrings(char delimiter, char qualifier) {
        this("" + delimiter, new Character(qualifier));
    }

    public DelimitedStrings(String delimiters, Character qualifier) {
        if (delimiters.length() == 0) {
            throw new IllegalArgumentException();
        }
        this._delimiters = delimiters;
        this._qualifier = qualifier;
    }

    /*
     * Unable to fully structure code
     */
    private final int countFields(String s) {
        count = 0;
        quoted = 0;
        ptr = 0;
        strlen = s.length();
        if (strlen != 0) ** GOTO lbl20
        return 1;
lbl-1000:
        // 1 sources

        {
            if (this._qualifier != null) {
                if (ptr < strlen - 1 && s.charAt(ptr) == this._qualifier.charValue() && s.charAt(ptr + 1) == this._qualifier.charValue()) {
                    ptr += 2;
                    continue;
                }
                if (s.charAt(ptr) == this._qualifier.charValue()) {
                    quoted = 1 - quoted;
                } else if (this._delimiters.indexOf(s.charAt(ptr)) >= 0) {
                    count += 1 - quoted;
                }
            } else if (this._delimiters.indexOf(s.charAt(ptr)) >= 0) {
                ++count;
            }
            ++ptr;
lbl20:
            // 3 sources

            ** while (ptr < strlen)
        }
lbl21:
        // 1 sources

        return count + 1;
    }

    /*
     * Unable to fully structure code
     */
    private final String[] smashFields(String s, String[] array) {
        idx = 0;
        ptr = 0;
        strlen = s.length();
        sb = new StringBuffer();
        if (strlen != 0) ** GOTO lbl18
        while (idx < array.length) {
            array[idx] = "";
            ++idx;
        }
        return array;
lbl-1000:
        // 1 sources

        {
            sb.setLength(0);
            if (this._qualifier != null && s.charAt(ptr) == this._qualifier.charValue()) {
                ptr = this.cutQuoted(s, ptr, sb);
                array[idx++] = sb.toString();
                continue;
            }
            ptr = this.cutComma(s, ptr, sb);
            array[idx++] = sb.toString().trim();
lbl18:
            // 3 sources

            ** while (idx < array.length && ptr >= 0 && ptr < strlen)
        }
lbl19:
        // 2 sources

        while (idx < array.length) {
            array[idx++] = "";
        }
        return array;
    }

    private final int cutQuoted(String s, int ptr, StringBuffer sb) {
        int strlen = s.length();
        ++ptr;
        while (ptr < strlen) {
            if (ptr < strlen - 1 && s.charAt(ptr) == this._qualifier.charValue() && s.charAt(ptr + 1) == this._qualifier.charValue()) {
                sb.append(this._qualifier.charValue());
                ptr += 2;
                continue;
            }
            if (s.charAt(ptr) == this._qualifier.charValue()) {
                while (++ptr < strlen && this._delimiters.indexOf(s.charAt(ptr)) < 0) {
                }
                return ++ptr;
            }
            sb.append(s.charAt(ptr++));
        }
        return -1;
    }

    private final int cutComma(String s, int ptr, StringBuffer sb) {
        int strlen = s.length();
        while (ptr < strlen) {
            if (this._delimiters.indexOf(s.charAt(ptr)) >= 0) {
                return ++ptr;
            }
            sb.append(s.charAt(ptr++));
        }
        return ptr;
    }

    public final String[] parse(String values) {
        if (this._delimiters.length() == 0) {
            throw new IllegalArgumentException();
        }
        int len = this.countFields(values);
        String[] array = new String[len];
        return this.smashFields(values, array);
    }

    public final String format(String[] values) {
        StringBuffer sb = new StringBuffer();
        char delimiter = this._delimiters.charAt(0);
        int i = 0;
        while (i < values.length) {
            if (i != 0) {
                sb.append(delimiter);
            }
            if (values[i] != null) {
                boolean quote = false;
                int pos = sb.length();
                int strlen = values[i].length();
                int j = 0;
                while (j < strlen) {
                    char c = values[i].charAt(j);
                    if (this._qualifier != null) {
                        if (c == this._qualifier.charValue()) {
                            quote = true;
                            sb.append(this._qualifier.charValue());
                        } else if (c == this._qualifier.charValue() || c <= ' ') {
                            quote = true;
                        }
                    }
                    sb.append(c);
                    ++j;
                }
                if (quote) {
                    sb.insert(pos, this._qualifier.charValue());
                    sb.append(this._qualifier.charValue());
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static final DelimitedStrings getCommaSeparatedInstance() {
        return CSV;
    }

    public static final DelimitedStrings getTabSeparatedInstance() {
        return TSV;
    }
}

