/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.ewt.shuttle.ListPicker;
import oracle.bali.ewt.shuttle.Shuttle;
import oracle.ide.help.HelpSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.util.Assert;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.vcs.util.VCSIgnoreFilters;
import oracle.jdevimpl.vcs.util.CreateFilterPanel;
import oracle.jdevimpl.vcs.util.DefaultCreateFilterPanel;
import oracle.jdevimpl.vcs.util.FileOrFolderFilter;
import oracle.jdevimpl.vcs.util.res.UtilArb;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterPanel
extends JPanel {
    private Shuttle _shuttle;
    private JList _availableList;
    private JList _selectedList;
    private JLabel _labelAvailable;
    private JLabel _labelSelected;
    private JButton _newFilterButton;
    private Class _filterPanelClass;

    private void $init$() {
        this._shuttle = new Shuttle();
        this._availableList = new JList();
        this._selectedList = new JList();
        this._labelAvailable = new JLabel();
        this._labelSelected = new JLabel();
        this._newFilterButton = new JButton();
        this._filterPanelClass = DefaultCreateFilterPanel.class;
    }

    public FilterPanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this._newFilterButton.addActionListener(new 1());
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        ResourceUtils.resLabel((JLabel)this._labelAvailable, (Component)this._availableList, (String)UtilArb.getString(5));
        ResourceUtils.resLabel((JLabel)this._labelSelected, (Component)this._selectedList, (String)UtilArb.getString(2));
        ResourceUtils.resButton((AbstractButton)this._newFilterButton, (String)UtilArb.getString(10));
        this._shuttle.setFromPicker((ItemPicker)new ListPicker(this._availableList));
        this._shuttle.setToPicker((ItemPicker)new ListPicker(this._selectedList));
        this._labelAvailable.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        this._labelSelected.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        this._shuttle.add((Component)this._labelAvailable, (Object)"FromHeader");
        this._shuttle.add((Component)this._labelSelected, (Object)"ToHeader");
        String proto = UtilArb.format(9, "*.www");
        this._availableList.setPrototypeCellValue(proto);
        this._availableList.setPrototypeCellValue(proto);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BorderLayout());
        buttonPanel.add((Component)this._newFilterButton, "East");
        buttonPanel.add(Box.createVerticalStrut(5), "North");
        this._shuttle.add((Component)buttonPanel, (Object)"ToFooter");
        int height = this._newFilterButton.getPreferredSize().height + 5;
        this._shuttle.add(Box.createVerticalStrut(height), (Object)"FromFooter");
        this.add((Component)this._shuttle, "Center");
    }

    public void setFilterPanelClass(Class filterPanelClass) {
        this._filterPanelClass = filterPanelClass;
    }

    public Class getFilterPanelClass() {
        return this._filterPanelClass;
    }

    public Collection getSelectedFilters() {
        ListModel listModel = this._selectedList.getModel();
        int size = listModel.getSize();
        ArrayList al = new ArrayList(size);
        int i = 0;
        while (i < size) {
            al.add(listModel.getElementAt(i));
            ++i;
        }
        return al;
    }

    public Collection getAvailableFilters() {
        ListModel listModel = this._availableList.getModel();
        int size = listModel.getSize();
        ArrayList al = new ArrayList(size);
        int i = 0;
        while (i < size) {
            al.add(listModel.getElementAt(i));
            ++i;
        }
        return al;
    }

    public Collection getAllFilters() {
        Collection all = this.getAvailableFilters();
        all.addAll(this.getSelectedFilters());
        return all;
    }

    public void setAvailableFilters(Collection filters) {
        this._availableList.setModel(FilterPanel.createListModel(filters));
    }

    public void setSelectedFilters(Collection filters) {
        this._selectedList.setModel(FilterPanel.createListModel(filters));
    }

    public void setFilterPatterns(Collection filterPatterns, boolean sort) {
        this.setSelectedFilters(this.createFileOrFolderFilters(filterPatterns, sort));
    }

    public Collection<FileOrFolderFilter> createFileOrFolderFilters(Collection<String> filterPatterns, boolean sort) {
        if (sort) {
            Collator stringCollator = (Collator)Collator.getInstance().clone();
            stringCollator.setStrength(0);
            ArrayList<String> l = new ArrayList<String>(filterPatterns);
            Collections.sort(l, stringCollator);
            filterPatterns = l;
        }
        ArrayList<FileOrFolderFilter> importFilters = new ArrayList<FileOrFolderFilter>();
        Iterator<String> itr = filterPatterns.iterator();
        while (itr.hasNext()) {
            String filterPattern = itr.next().toString();
            importFilters.add(new FileOrFolderFilter(this.getPrefixText(filterPattern), filterPattern, true, true));
        }
        return importFilters;
    }

    public Collection getFilterPatterns() {
        Collection importFilters = this.getSelectedFilters();
        ArrayList<String> importFilterPatterns = new ArrayList<String>();
        Iterator itr = importFilters.iterator();
        while (itr.hasNext()) {
            importFilterPatterns.add(((FileOrFolderFilter)itr.next()).getFilter());
        }
        return importFilterPatterns;
    }

    public void setNewFilterButtonText(String text) {
        ResourceUtils.resButton((AbstractButton)this._newFilterButton, (String)text);
    }

    private static ListModel createListModel(Collection coll) {
        DefaultListModel listModel = new DefaultListModel();
        if (coll != null) {
            Iterator i = coll.iterator();
            while (i.hasNext()) {
                listModel.addElement(i.next());
            }
        }
        return listModel;
    }

    public boolean runDialog(Component parent) {
        JEWTDialog dialog = JEWTDialog.createDialog((Component)parent, (String)UtilArb.getString(3), (int)7);
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_scmdfilterfiles_html");
        dialog.setContent((Component)this);
        dialog.setPreferredSize(400, 300);
        dialog.setResizable(true);
        try {
            dialog.runDialog();
        }
        finally {
            dialog.dispose();
        }
        return dialog.isCancelled() ^ true;
    }

    protected String getPrefixText(String text) {
        return UtilArb.format(7, text);
    }

    static Class ra$_filterPanelClass(FilterPanel filterPanel) {
        return filterPanel._filterPanelClass;
    }

    static JList ra$_selectedList(FilterPanel filterPanel) {
        return filterPanel._selectedList;
    }

    final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent ae) {
            try {
                CreateFilterPanel pan = (CreateFilterPanel)FilterPanel.ra$_filterPanelClass(FilterPanel.this).newInstance();
                URLFilter filter = pan.runDialog(FilterPanel.this);
                if (filter != null) {
                    ((DefaultListModel)FilterPanel.ra$_selectedList(FilterPanel.this).getModel()).addElement(filter);
                    VCSIgnoreFilters.addFilterPattern(((FileOrFolderFilter)filter).getFilter());
                }
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
            }
        }
    }
}

