/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import oracle.ide.Ide;

public class NestedException
extends Exception {
    private Throwable m_target;
    private String m_myTrace;
    private int m_severity;
    public static final int SEV_DONT_DISPLAY = 0;
    public static final int SEV_INFORMATIONAL = 1;
    public static final int SEV_WARNING = 2;
    public static final int SEV_ERROR = 3;
    public static final int SEV_FATAL = 4;
    protected static final int DEFAULT_SEVERITY = 2;
    private String m_title;

    private void $init$() {
        this.m_title = Ide.getProgramName();
    }

    public NestedException() {
        this.$init$();
        this.m_severity = 0;
    }

    public NestedException(String error, int severity) {
        this(error, (Throwable)null, severity);
    }

    public NestedException(String error, Object[] subst, int severity) {
        this(MessageFormat.format(error, subst), (Throwable)null, severity);
    }

    public NestedException(Throwable target, int severity) {
        this.$init$();
        this.setSeverity(severity);
        this.m_target = target;
    }

    public NestedException(String error, Throwable target, int severity) {
        super(error);
        this.$init$();
        this.m_target = target;
        this.setSeverity(severity);
    }

    public NestedException(String error, Object[] subst, Throwable target, int severity) {
        this(MessageFormat.format(error, subst), target, severity);
    }

    public NestedException(String error) {
        this(error, 2);
    }

    public NestedException(String error, Object[] subst) {
        this(error, subst, 2);
    }

    public NestedException(Throwable target) {
        this(target, 2);
    }

    public NestedException(String error, Throwable target) {
        this(error, target, 2);
    }

    public NestedException(String error, Object[] subst, Throwable target) {
        this(error, subst, target, 2);
    }

    public void setSeverity(int severity) {
        this.m_severity = severity;
    }

    public int getSeverity() {
        return this.m_severity;
    }

    public void setTarget(Throwable target) {
        this.m_target = target;
    }

    public Throwable getTarget() {
        return this.m_target;
    }

    public static String getStackTrace(Throwable t) {
        if (t == null) {
            return "";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.close();
        return sw.toString();
    }

    public void setTitle(String title) {
        this.m_title = title;
    }

    public String getTitle() {
        return this.m_title;
    }
}

