/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.util;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.JComponent;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.view.View;

public class PopupMenuListener
extends MouseAdapter {
    private final View m_view;

    public PopupMenuListener(View view) {
        this.m_view = view;
    }

    public final void mousePressed(MouseEvent e) {
        this.checkPopup(e);
        if (e.getSource() instanceof Component) {
            ((Component)e.getSource()).requestFocus();
        }
    }

    public final void mouseClicked(MouseEvent e) {
        this.checkDefault(e);
        this.checkPopup(e);
    }

    public final void mouseReleased(MouseEvent e) {
        this.checkPopup(e);
    }

    protected boolean isDefaultAction(MouseEvent me) {
        return me.getClickCount() == 2;
    }

    private final void checkDefault(MouseEvent e) {
        if (this.isDefaultAction(e)) {
            Context context = this.m_view.getContext((EventObject)e);
            if (context == null) {
                return;
            }
            this.m_view.getContextMenu().fireDefaultAction(context);
        }
    }

    private final void checkPopup(MouseEvent e) {
        JComponent jc;
        if (!e.isPopupTrigger()) {
            return;
        }
        Context context = this.m_view.getContext((EventObject)e);
        if (context == null) {
            return;
        }
        if (e.getSource() instanceof JComponent && !(jc = (JComponent)e.getSource()).hasFocus()) {
            jc.requestFocus();
            EventQueue.invokeLater(new 1(this, e, context));
            return;
        }
        this.showPopup(e, context);
    }

    private void showPopup(MouseEvent e, Context context) {
        ContextMenu menu = this.m_view.getContextMenu();
        menu.show(context);
    }

    static void mav$showPopup(PopupMenuListener popupMenuListener, MouseEvent mouseEvent, Context context) {
        popupMenuListener.showPopup(mouseEvent, context);
    }

    final class 1
    implements Runnable {
        private final /* synthetic */ MouseEvent v$e;
        private final /* synthetic */ Context v$context;
        final /* synthetic */ PopupMenuListener this$0;

        public void run() {
            PopupMenuListener.mav$showPopup(this.this$0, this.v$e, this.v$context);
        }

        public 1(PopupMenuListener popupMenuListener, MouseEvent mouseEvent, Context context) {
            this.v$context = context;
            this.v$e = mouseEvent;
            this.this$0 = popupMenuListener;
        }
    }
}

