/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.util;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.PushbackReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import oracle.ide.runner.RunProcess;
import oracle.jdeveloper.vcs.migrate.VCSStreamMonitor;
import oracle.jdeveloper.vcs.spi.VCSException;
import oracle.jdevimpl.vcs.util.RunnerTimeoutTask;

public class RunnerOutputTask
implements Runnable {
    private final RunProcess _process;
    private final Collection _monitors;
    private final InputStream _in;
    private StringBuffer _outputBuffer;
    private ByteArrayOutputStream _outputStreamBytes;
    private boolean _bufferBytes;
    private Exception _exception;
    private RunnerTimeoutTask _timeoutTask;
    private boolean _exit;

    public RunnerOutputTask(RunProcess process, Collection monitors, InputStream in) {
        this._process = process;
        this._monitors = new ArrayList(monitors);
        this._in = in;
    }

    public void setBufferBytes(boolean bufferBytes) {
        this._bufferBytes = bufferBytes;
    }

    public void run() {
        if (this._bufferBytes) {
            this._outputStreamBytes = new ByteArrayOutputStream();
            this.runByteReader();
        } else {
            this._outputBuffer = new StringBuffer();
            this.runCharacterReader();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runByteReader() {
        try {
            try {
                PushbackInputStream pushbackInputStream = new PushbackInputStream(this._in);
                byte[] byteBuffer = new byte[(int)Math.pow(2.0, 10.0)];
                while (true) {
                    int c;
                    if ((c = pushbackInputStream.read()) < 0) {
                    }
                    if (this._exit) {
                    }
                    pushbackInputStream.unread(c);
                    int n = pushbackInputStream.read(byteBuffer);
                    if (n == 0) continue;
                    if (this._timeoutTask != null) {
                        this._timeoutTask.restart();
                    }
                    this._outputStreamBytes.write(byteBuffer, 0, n);
                }
            }
            finally {
                if (this._timeoutTask == null) return;
                this._timeoutTask.restart();
                this._timeoutTask.setExitFlag();
            }
        }
        catch (Exception e) {
            if (this._exit) {
                return;
            }
            this._exception = e;
        }
        this.runExiting();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runCharacterReader() {
        try {
            try {
                InputStreamReader inputStreamReader = new InputStreamReader(this._in);
                CharSequenceLineIterator itr = new CharSequenceLineIterator(this._outputBuffer);
                PushbackReader pushbackReader = new PushbackReader(inputStreamReader);
                char[] charBuffer = new char[(int)Math.pow(2.0, 10.0)];
                int _minRemainderCharIndex = 0;
                while (true) {
                    int c;
                    if ((c = pushbackReader.read()) < 0) {
                    }
                    if (this._exit) {
                    }
                    pushbackReader.unread(c);
                    int n = pushbackReader.read(charBuffer);
                    if (n == 0) continue;
                    if (this._timeoutTask != null) {
                        this._timeoutTask.restart();
                    }
                    this.log(new String(charBuffer, 0, n));
                    this._outputBuffer.append(charBuffer, 0, n);
                    while (itr.hasNext()) {
                        String line = itr.next().toString();
                        this.doLineUpdate(line);
                        this.doPatternCheck(line);
                    }
                    String remainder = itr.remainder(_minRemainderCharIndex);
                    if (remainder != null) {
                        this.doPatternCheck(remainder);
                    }
                    _minRemainderCharIndex = this._outputBuffer.length();
                }
            }
            finally {
                if (this._timeoutTask == null) return;
                this._timeoutTask.restart();
                this._timeoutTask.setExitFlag();
            }
        }
        catch (VCSException ce) {
            this._exception = ce;
        }
        catch (Exception e) {
            if (this._exit) {
                return;
            }
            this._exception = e;
        }
        this.runExiting();
    }

    public Collection getMonitors() {
        return Collections.unmodifiableCollection(this._monitors);
    }

    protected void log(String message) {
    }

    protected void doLineUpdate(String s) throws Exception {
        if (this._monitors == null) {
            return;
        }
        Iterator itr = this._monitors.iterator();
        while (itr.hasNext()) {
            ((VCSStreamMonitor)itr.next()).dispatchEvent(2, s, this._process);
        }
    }

    protected void doPatternCheck(String s) throws Exception {
        if (this._monitors == null) {
            return;
        }
        for (VCSStreamMonitor monitor : this._monitors) {
            String pattern = monitor.getPattern();
            if (pattern == null || s.indexOf(pattern) < 0) continue;
            monitor.dispatchEvent(1, null, this._process);
        }
    }

    protected Integer getExitCode() {
        return this._process.getStarter().getExitCode();
    }

    protected void runExiting() {
        RunnerOutputTask.terminateRunProcess(this._process);
    }

    public void setTimeoutTask(RunnerTimeoutTask timeoutTask) {
        this._timeoutTask = timeoutTask;
    }

    public void setExitFlag() {
        this._exit = true;
    }

    public Exception getException() {
        return this._exception;
    }

    public String getOutput() {
        if (this._bufferBytes) {
            return this._outputStreamBytes != null ? new String(this._outputStreamBytes.toByteArray()) : null;
        }
        return this._outputBuffer != null ? this._outputBuffer.toString() : null;
    }

    public byte[] getOutputBytes() {
        if (this._bufferBytes) {
            return this._outputStreamBytes != null ? this._outputStreamBytes.toByteArray() : null;
        }
        return this._outputBuffer != null ? this._outputBuffer.toString().getBytes() : null;
    }

    public static final void terminateRunProcess(RunProcess process) {
        1 r = new 1(process);
        new Thread(r).start();
    }

    static final class 1
    implements Runnable {
        private final /* synthetic */ RunProcess v$process;

        public final void run() {
            this.v$process.terminate();
        }

        public 1(RunProcess runProcess) {
            this.v$process = runProcess;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CharSequenceLineIterator
    implements Iterator {
        private final CharSequence _sequence;
        private int _i;

        CharSequenceLineIterator(CharSequence sequence) {
            this._sequence = sequence;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.seekNextNL() >= this._i;
        }

        public Object next() {
            int n = this.seekNextNL();
            String next = this._sequence.subSequence(this._i, n).toString();
            this._i = this.skipNL(n);
            return next;
        }

        public String remainder(int min) {
            int n = this._sequence.length();
            int i = Math.max(min, this._i);
            return i >= n ? null : this._sequence.subSequence(i, n).toString();
        }

        private int seekNextNL() {
            int n = this._sequence.length();
            int i = this._i;
            while (i < n) {
                char c = this._sequence.charAt(i);
                if (c == '\n' || c == '\r') {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        private int skipNL(int i) {
            int n = this._sequence.length();
            if (i >= n) {
                return i;
            }
            char c = this._sequence.charAt(i);
            if (c == '\r') {
                if (++i >= n) {
                    return i;
                }
                c = this._sequence.charAt(i);
            }
            if (c == '\n') {
                ++i;
            }
            return i;
        }
    }
}

