/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.util;

public abstract class RunnerTimeoutTask
implements Runnable {
    private final long _delay;
    private long _startTime;
    private boolean _suspend;
    private boolean _exit;

    public RunnerTimeoutTask(long delay) {
        this._delay = delay;
    }

    public void run() {
        this._startTime = System.currentTimeMillis();
        while (!this._exit) {
            if (!this._suspend && System.currentTimeMillis() > this._startTime + this._delay) {
                this.doTimeout();
                return;
            }
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
        return;
    }

    public void suspend() {
        this._suspend = true;
    }

    public void resume() {
        this.restart();
        this._suspend = false;
    }

    protected abstract void doTimeout();

    void restart() {
        this._startTime = System.currentTimeMillis();
    }

    void setExitFlag() {
        this._exit = true;
    }
}

