/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.util;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.vcs.util.VCSDialogRunner;

public class SimpleChoiceDialog {
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    private String _title;
    private String _label;
    private String[] _choiceText;
    private String _helpId;
    private int _buttonAxis;
    private int _defaultChoice;
    private int _choice;

    private void $init$() {
        this._buttonAxis = 1;
        this._defaultChoice = 0;
    }

    public SimpleChoiceDialog(String title, String label, String[] choiceText, String helpId) {
        this.$init$();
        if (choiceText.length <= 0) {
            throw new IllegalArgumentException();
        }
        this._title = title;
        this._label = label;
        this._choiceText = choiceText;
        this._helpId = helpId;
    }

    public void setDefaultChoice(int defaultChoice) {
        this._defaultChoice = defaultChoice;
    }

    public void setButtonAxis(int buttonAxis) {
        this._buttonAxis = buttonAxis;
    }

    public boolean show() {
        this._choice = -1;
        JRadioButton[] radioButtons = new JRadioButton[this._choiceText.length];
        ButtonGroup radioButtonGroup = new ButtonGroup();
        int i = 0;
        while (i < radioButtons.length) {
            radioButtons[i] = new JRadioButton();
            radioButtonGroup.add(radioButtons[i]);
            ResourceUtils.resButton((AbstractButton)radioButtons[i], (String)this._choiceText[i]);
            ++i;
        }
        radioButtons[this._defaultChoice].setSelected(true);
        radioButtonGroup = null;
        JLabel hintLabel = null;
        if (this._label != null) {
            hintLabel = new JLabel();
            ResourceUtils.resLabel((JLabel)hintLabel, (Component)radioButtons[0], (String)this._label);
        }
        Box panel = new Box(this._buttonAxis);
        if (hintLabel != null) {
            panel.add(hintLabel);
            panel.add(Box.createVerticalStrut(10));
            panel.add(Box.createHorizontalStrut(10));
        }
        int i2 = 0;
        while (i2 < radioButtons.length) {
            panel.add(radioButtons[i2]);
            if (this._buttonAxis == 0 && i2 < radioButtons.length - 1) {
                panel.add(Box.createHorizontalStrut(4));
            }
            ++i2;
        }
        panel.setPreferredSize(new Dimension(Math.max(300, panel.getPreferredSize().width), panel.getPreferredSize().height));
        JEWTDialog dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)panel, null, (String)this._title);
        int buttonMask = 7;
        dlg.setInitialFocus((Component)radioButtons[this._defaultChoice]);
        dlg.setButtonMask(this._helpId != null ? buttonMask : buttonMask - (buttonMask & 4));
        if (this._helpId != null) {
            HelpSystem.getHelpSystem().registerTopic((JComponent)panel, this._helpId);
        }
        dlg.setDefaultButton(1);
        dlg.pack();
        if (!VCSDialogRunner.runDialog((JDialog)dlg)) {
            return false;
        }
        int i3 = 0;
        while (i3 < radioButtons.length) {
            if (radioButtons[i3].isSelected()) {
                this._choice = i3;
                break;
            }
            ++i3;
        }
        return true;
    }

    public int getChoice() {
        return this._choice;
    }
}

