/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.util.search;

import java.util.HashMap;
import java.util.Map;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

abstract class ColumnHideDecorator
extends AbstractTableModel
implements TableModelListener {
    private final TableModel m_baseModel;
    private Map m_modelListenerMap;
    private int[] m_columnMap;

    private void $init$() {
        this.m_modelListenerMap = new HashMap();
    }

    ColumnHideDecorator(TableModel baseModel) {
        this.$init$();
        this.m_baseModel = baseModel;
        this.m_baseModel.addTableModelListener(this);
    }

    TableModel getBaseModel() {
        return this.m_baseModel;
    }

    public Object getValueAt(int row, int column) {
        return this.m_baseModel.getValueAt(row, this.getBaseColumnIndex(column));
    }

    public void setValueAt(Object value, int row, int column) {
        this.m_baseModel.setValueAt(value, row, this.getBaseColumnIndex(column));
    }

    public void tableChanged(TableModelEvent tme) {
        this.allocate();
    }

    public int getRowCount() {
        return this.m_baseModel.getRowCount();
    }

    public int getColumnCount() {
        if (this.m_columnMap == null) {
            this.allocate();
        }
        return this.m_columnMap.length;
    }

    public String getColumnName(int column) {
        return this.m_baseModel.getColumnName(this.getBaseColumnIndex(column));
    }

    public Class getColumnClass(int column) {
        return this.m_baseModel.getColumnClass(this.getBaseColumnIndex(column));
    }

    public boolean isCellEditable(int row, int column) {
        return this.m_baseModel.isCellEditable(row, this.getBaseColumnIndex(column));
    }

    public void addTableModelListener(TableModelListener tml) {
        super.addTableModelListener(tml);
        this.m_baseModel.addTableModelListener(tml);
    }

    public void removeTableModelListener(TableModelListener tml) {
        super.removeTableModelListener(tml);
        this.m_baseModel.removeTableModelListener(tml);
    }

    private void allocate() {
        int visibleCount = 0;
        int i = 0;
        while (i < this.m_baseModel.getColumnCount()) {
            if (this.isColumnVisible(i)) {
                ++visibleCount;
            }
            ++i;
        }
        this.m_columnMap = new int[visibleCount];
        int mapIndex = 0;
        int i2 = 0;
        while (i2 < this.m_baseModel.getColumnCount()) {
            if (this.isColumnVisible(i2)) {
                this.m_columnMap[mapIndex++] = i2;
            }
            ++i2;
        }
    }

    private int getBaseColumnIndex(int visibleColumnIndex) {
        try {
            int n = this.m_columnMap[visibleColumnIndex];
            return n;
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            int n = -1;
            return n;
        }
    }

    protected abstract boolean isColumnVisible(int var1);

    protected void setColumnVisible(int columnIndex, boolean isVisible) {
        this.allocate();
        super.fireTableStructureChanged();
    }
}

