/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.util.search;

import java.awt.Component;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import oracle.ide.config.ClientSetting;
import oracle.ide.controller.IdeAction;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockingParam;
import oracle.ide.help.HelpInfo;
import oracle.ide.view.View;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.util.Copyable;
import oracle.jdevimpl.vcs.util.search.ColumnHideDecorator;
import oracle.jdevimpl.vcs.util.search.SearchActions;
import oracle.jdevimpl.vcs.util.search.SearchController;
import oracle.jdevimpl.vcs.util.search.SearchException;
import oracle.jdevimpl.vcs.util.search.SearchLister;
import oracle.jdevimpl.vcs.util.search.SearchPanel;
import oracle.jdevimpl.vcs.util.search.SearchSetup;
import oracle.jdevimpl.vcs.util.search.SearchTable;
import oracle.jdevimpl.vcs.util.search.SearchTableModel;
import oracle.jdevimpl.vcs.util.search.SearchWindow;
import oracle.jdevimpl.vcs.util.search.SearchWorker;

public final class SearchControl {
    private Map _args;
    private Thread _thread;
    private final SearchLister _lister;
    private final SearchSetup _setup;
    private final Object[] _optionalKeys;
    private boolean[] _columnVisible;
    private SearchWindow _window;
    private SearchPanel _panel;
    private SearchTableModel _tableModel;
    private final SearchActions _actions;
    private final String _extensionId;

    private void $init$() {
        this._args = null;
        this._thread = null;
    }

    public SearchControl(SearchLister lister, String extensionId) {
        this.$init$();
        this._lister = lister;
        this._setup = lister.getSearchSetup();
        this._optionalKeys = this._setup.getOptionalResultKeys();
        this._columnVisible = new boolean[this._optionalKeys.length];
        this._extensionId = extensionId;
        int i = 0;
        while (i < this._columnVisible.length) {
            String persistKey = this._setup.getControlId() + "_" + this._optionalKeys[i].toString();
            BooleanCopyable bc = (BooleanCopyable)ClientSetting.findOrCreate((String)this._extensionId).getData(persistKey);
            this._columnVisible[i] = bc != null ? bc.getValue() : true;
            ++i;
        }
        if (this._lister == null || this._setup == null) {
            throw new IllegalArgumentException();
        }
        this._window = this.createSearchWindow(this._setup.getControlId());
        this._actions = new SearchActions(this.getSearchView());
        this._panel = new 1(this._actions.getActionArray());
        String topic = this._setup.getHelpTopic();
        if (this._window != null) {
            this._window.initPanel(this._panel);
            if (topic != null) {
                this._window.setHelpInfo(new HelpInfo(topic));
            }
            this._window.setController(new SearchController(this));
        }
    }

    protected SearchWindow createSearchWindow(String id) {
        return new 2(id);
    }

    protected View getSearchView() {
        return this._window;
    }

    public final boolean isBusy() {
        return this._thread != null;
    }

    public final void refresh(Map args) {
        SwingUtilities.invokeLater(new 3(this, args));
    }

    public final Map getArguments() {
        return this._args;
    }

    public final void close() {
        if (this._window != null) {
            DockStation.getDockStation().undock((Dockable)this._window);
            this._window.close();
        }
    }

    public final void setVisible(boolean visible) {
        if (this._window == null) {
            return;
        }
        if (!DockStation.getDockStation().isDockableVisible((Dockable)this._window) && visible) {
            DockingParam dockingParam = this._setup.getDockingParam();
            DockStation dockStation = DockStation.getDockStation();
            dockStation.dock((Dockable)this._window, dockingParam);
        }
        DockStation.getDockStation().setDockableVisible((Dockable)this._window, visible);
        if (visible) {
            DockStation.getDockStation().activateDockable((Dockable)this._window);
        }
    }

    final SearchWindow getWindow() {
        return this._window;
    }

    final SearchPanel getPanel() {
        return this._panel;
    }

    final SearchActions getActions() {
        return this._actions;
    }

    private final void refreshImpl(Map args) {
        this.setVisible(true);
        this._args = args;
        if (this._lister == null) {
            return;
        }
        this.getPanel().setEnabled(false);
        String status = this._setup != null ? this._setup.getStatusBusy(this._args) : null;
        this.getPanel().getStatusBar().setText(status);
        if (this.getPanel().getTable() == null) {
            this._tableModel = new SearchTableModel(this._setup);
            4 dec = new 4(this._tableModel);
            this.getPanel().setTable(new 5(dec));
        }
        SearchTable table = this.getPanel().getTable();
        SearchWorker worker = this._lister.getSearchWorker();
        this.setThread(new 6(this, args, worker));
        this._tableModel.markDirty();
        this._thread.start();
    }

    private final void setThread(Thread thread) {
        this._thread = thread;
    }

    private boolean isColumnVisible(int column) {
        if (column == 0) {
            return true;
        }
        return this._columnVisible[column - 1];
    }

    private void setColumnVisible(int column, boolean visible) {
        if (column == 0) {
            return;
        }
        this._columnVisible[column - 1] = visible;
        ClientSetting.findOrCreate((String)this._extensionId).putData(this._setup.getControlId() + "_" + this._optionalKeys[column - 1].toString(), (Copyable)(visible ? BooleanCopyable.TRUE : BooleanCopyable.FALSE));
        try {
            ClientSetting.findOrCreate((String)this._extensionId).save();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    static void mav$setColumnVisible(SearchControl searchControl, int n, boolean bl) {
        searchControl.setColumnVisible(n, bl);
    }

    static boolean mav$isColumnVisible(SearchControl searchControl, int n) {
        return searchControl.isColumnVisible(n);
    }

    static SearchTableModel ra$_tableModel(SearchControl searchControl) {
        return searchControl._tableModel;
    }

    static SearchSetup ra$_setup(SearchControl searchControl) {
        return searchControl._setup;
    }

    static void mav$setThread(SearchControl searchControl, Thread thread) {
        searchControl.setThread(thread);
    }

    static void mav$refreshImpl(SearchControl searchControl, Map map) {
        searchControl.refreshImpl(map);
    }

    final class 1
    extends SearchPanel {
        protected final void refresh() {
            SearchControl.this.refresh(SearchControl.this.getArguments());
        }

        public 1(IdeAction[] ideActionArray) {
            super(ideActionArray);
        }
    }

    final class 2
    extends SearchWindow {
        public final String getTabName() {
            return SearchControl.ra$_setup(SearchControl.this).getWindowTitle();
        }

        public final String getTitleName() {
            return SearchControl.ra$_setup(SearchControl.this).getWindowTitle();
        }

        public final Icon getTabIcon() {
            return SearchControl.ra$_setup(SearchControl.this).getWindowIcon();
        }

        public 2(String string) {
            super(string);
        }
    }

    final class 3
    implements Runnable {
        private final /* synthetic */ Map v$args;
        final /* synthetic */ SearchControl this$0;

        public final void run() {
            try {
                SearchControl.mav$refreshImpl(this.this$0, this.v$args);
            }
            catch (RuntimeException re) {
                ExceptionDialog.showExceptionDialog((Component)this.this$0.getPanel(), (Throwable)re, (String)re.getMessage());
            }
        }

        public 3(SearchControl searchControl, Map map) {
            this.v$args = map;
            this.this$0 = searchControl;
        }
    }

    final class 4
    extends ColumnHideDecorator {
        protected boolean isColumnVisible(int column) {
            return SearchControl.mav$isColumnVisible(SearchControl.this, column);
        }

        protected void setColumnVisible(int column, boolean visible) {
            SearchControl.mav$setColumnVisible(SearchControl.this, column, visible);
            super.setColumnVisible(column, visible);
        }

        public 4(TableModel tableModel) {
            super(tableModel);
        }
    }

    final class 5
    extends SearchTable {
        protected final boolean isViewActive() {
            return SearchControl.this.getWindow() != null && SearchControl.this.getWindow().isViewActive();
        }

        public 5(TableModel tableModel) {
            super(tableModel);
        }
    }

    final class 6
    extends Thread {
        private final /* synthetic */ Map v$args;
        private Map arguments;
        private final /* synthetic */ SearchWorker v$worker;
        final /* synthetic */ SearchControl this$0;

        private void $init$() {
            this.arguments = this.v$args != null ? new HashMap(this.v$args) : null;
        }

        public final void run() {
            try {
                try {
                    this.v$worker.search(this.arguments, SearchControl.ra$_tableModel(this.this$0));
                    SearchControl.ra$_tableModel(this.this$0).flushDirty();
                    String status = SearchControl.ra$_setup(this.this$0) != null ? SearchControl.ra$_setup(this.this$0).getStatusIdle(this.arguments) : "";
                    this.this$0.getPanel().getStatusBar().setText(status);
                }
                catch (SearchException se) {
                    this.this$0.getPanel().getStatusBar().setText(se.getMessage());
                }
                catch (RuntimeException re) {
                    ExceptionDialog.showExceptionDialog((Component)this.this$0.getPanel(), (Throwable)re, (String)re.getMessage());
                }
            }
            finally {
                this.this$0.getPanel().setEnabled(true);
                SearchControl.mav$setThread(this.this$0, null);
            }
        }

        public 6(SearchControl searchControl, Map map, SearchWorker searchWorker) {
            this.v$worker = searchWorker;
            this.v$args = map;
            this.this$0 = searchControl;
            this.$init$();
        }
    }

    public static class BooleanCopyable
    implements Copyable {
        private boolean _value;
        static final BooleanCopyable TRUE = new BooleanCopyable(true);
        static final BooleanCopyable FALSE = new BooleanCopyable(false);

        public BooleanCopyable() {
            this._value = false;
        }

        public BooleanCopyable(boolean value) {
            this._value = value;
        }

        public boolean getValue() {
            return this._value;
        }

        public void setValue(boolean value) {
            this._value = value;
        }

        public boolean equals(Object o) {
            return o != null && o instanceof BooleanCopyable && ((BooleanCopyable)o)._value == this._value;
        }

        public Object copyTo(Object target) {
            BooleanCopyable copy = target != null ? (BooleanCopyable)target : new BooleanCopyable();
            copy._value = this._value;
            return copy;
        }
    }
}

