/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.util.search;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.EventObject;
import java.util.Iterator;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import oracle.bali.ewt.util.MenuUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.StatusBar;
import oracle.ide.controls.StatusBarControl;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToggleMenuItem;
import oracle.ide.controls.Toolbar;
import oracle.ide.datatransfer.TransferableContext;
import oracle.ide.model.Element;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.view.View;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdevimpl.vcs.util.search.ColumnHideDecorator;
import oracle.jdevimpl.vcs.util.search.SearchTable;

abstract class SearchPanel
extends JPanel {
    private Toolbar m_toolbar = new Toolbar();
    private StatusBarControl m_statusbar;
    private JPanel m_panel;
    private SearchTable m_table;
    private IdeAction[] m_actions;
    private MouseListener m_activationFixListener;

    SearchPanel(IdeAction[] actions) {
        this.m_toolbar.setBorder(null);
        this.m_panel = new JPanel(new BorderLayout());
        this.m_statusbar = new StatusBarControl();
        this.m_actions = actions;
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_toolbar, "North");
        this.add((Component)this.m_panel, "Center");
        this.add((Component)this.m_statusbar.getGUI(), "South");
        this.createToolbarActions();
        this.setEnabled(false);
    }

    final void setTable(SearchTable table) {
        this.m_panel.removeAll();
        this.m_table = table;
        if (this.m_table != null) {
            JScrollPane scrollpane = this.m_table.getScrollPaneForTable();
            this.m_panel.add((Component)scrollpane, "Center");
            PopupListener pl = new PopupListener(null);
            this.m_table.addMouseListener(pl);
            this.m_table.getTableHeader().addMouseListener(pl);
            if (this.m_activationFixListener != null) {
                scrollpane.getViewport().addMouseListener(this.m_activationFixListener);
            }
            DragSource dragSource = DragSource.getDefaultDragSource();
            dragSource.createDefaultDragGestureRecognizer((Component)((Object)this.m_table), 3, new DragListener(null));
        }
        this.setEnabled(this.isEnabled());
        this.m_panel.validate();
        this.repaint();
    }

    final SearchTable getTable() {
        return this.m_table;
    }

    final StatusBar getStatusBar() {
        return this.m_statusbar;
    }

    protected abstract void refresh();

    public final void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.m_table != null) {
            this.m_table.setEnabled(enabled);
        }
        int i = 0;
        while (i < this.m_actions.length) {
            this.m_actions[i].setEnabled(enabled && this.m_table != null);
            ++i;
        }
        if (!enabled) {
            this.grabFocus();
        }
    }

    private void createToolbarActions() {
        int i = 0;
        while (i < this.m_actions.length) {
            IdeAction a = this.m_actions[i];
            if (a == null) {
                this.m_toolbar.addSeparator();
            } else {
                this.m_toolbar.add((ToggleAction)a);
            }
            ++i;
        }
    }

    final Context getContext(EventObject e) {
        return this.getContext(null, e);
    }

    final Context getContext(View view, EventObject e) {
        Context context = null;
        SearchTable table = this.getTable();
        if (table == null) {
            return context;
        }
        Element[] selection = table.getSelectedElements();
        if (selection.length == 1) {
            context = Context.newIdeContext((Element)selection[0]);
            if (view != null) {
                context.setView(view);
            }
            context.setEvent(e);
        } else {
            context = Context.newIdeContext((View)view, (EventObject)e);
        }
        context.setSelection(selection);
        return context;
    }

    private JPopupMenu createColumnHeaderPopup() {
        JPopupMenu popup = new JPopupMenu();
        ColumnHideDecorator chd = (ColumnHideDecorator)this.getTable().getModel();
        int columnCount = chd.getBaseModel().getColumnCount();
        1 al = new 1(this, popup, chd);
        int i = 1;
        while (i < columnCount) {
            String colName = chd.getBaseModel().getColumnName(i);
            IdeAction action = IdeAction.get((int)Ide.findOrCreateCmdID((String)colName), (String)colName, (Integer)new Integer(0));
            action.putValue("Check", (Object)Boolean.TRUE);
            ToggleMenuItem item = new ToggleMenuItem((ToggleAction)action);
            action.setState(chd.isColumnVisible(i));
            item.addActionListener((ActionListener)al);
            popup.add((JMenuItem)item);
            ++i;
        }
        return popup;
    }

    final void initActivationFixListener(MouseListener l) {
        this.m_activationFixListener = l;
    }

    static JPopupMenu mav$createColumnHeaderPopup(SearchPanel searchPanel) {
        return searchPanel.createColumnHeaderPopup();
    }

    final class 1
    implements ActionListener {
        private final /* synthetic */ JPopupMenu v$popup;
        private final /* synthetic */ ColumnHideDecorator v$chd;
        final /* synthetic */ SearchPanel this$0;

        public void actionPerformed(ActionEvent ae) {
            try {
                int index = this.v$popup.getComponentIndex((Component)ae.getSource()) + 1;
                this.v$chd.setColumnVisible(index, ((JCheckBoxMenuItem)ae.getSource()).isSelected());
            }
            catch (RuntimeException re) {
                ExceptionDialog.showExceptionDialog((Component)this.this$0, (Throwable)re, (String)re.getMessage());
            }
        }

        public 1(SearchPanel searchPanel, JPopupMenu jPopupMenu, ColumnHideDecorator columnHideDecorator) {
            this.v$chd = columnHideDecorator;
            this.v$popup = jPopupMenu;
            this.this$0 = searchPanel;
        }
    }

    private final class PopupListener
    implements MouseListener {
        public final void mousePressed(MouseEvent e) {
            this.checkPopup(e);
        }

        public final void mouseClicked(MouseEvent e) {
            this.checkDefault(e);
            this.checkPopup(e);
        }

        public final void mouseEntered(MouseEvent e) {
        }

        public final void mouseExited(MouseEvent e) {
        }

        public final void mouseReleased(MouseEvent e) {
            this.checkPopup(e);
        }

        private final void checkDefault(MouseEvent e) {
            try {
                if (e.getClickCount() <= 1) {
                    return;
                }
                if (e.getSource() == SearchPanel.this.getTable().getTableHeader()) {
                    return;
                }
                Context context = SearchPanel.this.getContext(e);
                if (context == null) {
                    return;
                }
                if (SearchPanel.this.getTable() == null || !SearchPanel.this.getTable().isEnabled()) {
                    return;
                }
                NavigatorManager.getApplicationNavigatorManager().getNavigatorWindow().getContextMenu().fireDefaultAction(context);
            }
            catch (RuntimeException re) {
                ExceptionDialog.showExceptionDialog((Component)SearchPanel.this, (Throwable)re, (String)re.getMessage());
            }
        }

        private final void checkPopup(MouseEvent e) {
            try {
                if (!e.isPopupTrigger()) {
                    return;
                }
                if (e.getSource() == SearchPanel.this.getTable().getTableHeader()) {
                    MenuUtils.showPopupMenu((JPopupMenu)SearchPanel.mav$createColumnHeaderPopup(SearchPanel.this), (Component)((Component)e.getSource()), (int)e.getX(), (int)e.getY());
                    return;
                }
                Context context = SearchPanel.this.getContext(e);
                if (context == null) {
                    return;
                }
                if (SearchPanel.this.getTable() == null || !SearchPanel.this.getTable().isEnabled()) {
                    return;
                }
                NavigatorManager.getApplicationNavigatorManager().getNavigatorWindow().getContextMenu().show(context);
            }
            catch (RuntimeException re) {
                ExceptionDialog.showExceptionDialog((Component)SearchPanel.this, (Throwable)re, (String)re.getMessage());
            }
        }

        private PopupListener() {
        }

        PopupListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class DragListener
    implements DragGestureListener {
        public void dragGestureRecognized(DragGestureEvent e) {
            Iterator<InputEvent> iterator = e.iterator();
            while (iterator.hasNext()) {
                MouseEvent mouseEvent = (MouseEvent)iterator.next();
                if (mouseEvent.getID() != 505) continue;
                return;
            }
            Context context = SearchPanel.this.getContext(e);
            if (context == null) {
                return;
            }
            if (SearchPanel.this.getTable() == null || !SearchPanel.this.getTable().isEnabled()) {
                return;
            }
            TransferableContext transferable = new TransferableContext(context);
            DragSource dragSource = DragSource.getDefaultDragSource();
            try {
                dragSource.startDrag(e, null, (Transferable)transferable, new SourceListener(null));
            }
            catch (InvalidDnDOperationException dnde) {
                // empty catch block
            }
        }

        private DragListener() {
        }

        DragListener(1 var2_2) {
            this();
        }

        private final class SourceListener
        implements DragSourceListener {
            public void dragEnter(DragSourceDragEvent e) {
            }

            public void dropActionChanged(DragSourceDragEvent e) {
            }

            public void dragDropEnd(DragSourceDropEvent e) {
            }

            public void dragExit(DragSourceEvent e) {
            }

            public void dragOver(DragSourceDragEvent e) {
            }

            private SourceListener() {
            }

            SourceListener(1 var2_2) {
                this();
            }

            public final class 1 {
            }
        }

        public final class 1 {
        }
    }
}

