/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.replace;

import java.awt.Component;
import java.net.URL;
import javax.swing.JMenu;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.MenuConstants;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.net.URLFileSystem;
import oracle.ide.replace.ReplaceMenuManager;
import oracle.ideimpl.replace.ReplaceMenuAddin;

final class ReplaceContextMenuListener
implements ContextMenuListener {
    public void menuWillShow(ContextMenu contextMenu) {
        Context context = contextMenu.getContext();
        Element[] selection = context.getSelection();
        if (context != null && selection.length > 0) {
            JMenu contextReplaceMenu = ReplaceMenuManager.getInstance().getContextReplaceMenu();
            ReplaceMenuAddin.removeLeadingSeparator(contextReplaceMenu);
            if (contextReplaceMenu.getItemCount() > 0) {
                boolean validLocatables = false;
                int i = 0;
                while (i < selection.length && !validLocatables) {
                    URL url;
                    if (selection[i] instanceof Locatable && (url = ((Locatable)selection[i]).getURL()) != null && !URLFileSystem.isDirectoryPath((URL)url) && URLFileSystem.exists((URL)url)) {
                        validLocatables = true;
                    }
                    ++i;
                }
                if (validLocatables) {
                    contextMenu.add((Component)contextReplaceMenu, MenuConstants.SECTION_ADDITIONAL_CTXT_MENU);
                }
            }
        }
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    ReplaceContextMenuListener() {
    }
}

