/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.boot;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.Properties;
import oracle.classloader.ConfigurationPolicy;
import oracle.classloader.ConfigurationType;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.SharedCodeSourceFactory;
import oracle.classloader.SharedCodeSourceURL;
import oracle.classloader.util.ClassLoadEnvironment;
import oracle.classloader.util.InitialLoadersConfiguration;
import oracle.classloader.util.InitialLoadersFactory;
import oracle.classloader.util.MainClass;
import oracle.classloader.util.XMLConfiguration;
import oracle.ide.boot.IdeSharedCodeSourceFactory;
import oracle.ide.boot.Launcher;
import oracle.ide.boot.URLStreamHandlerFactoryQueue;

public class IdeLauncher {
    public static void main(String[] args) {
        IdeLauncher launcher = new IdeLauncher();
        launcher.launch(args);
    }

    public final void launch(String[] args) {
        try {
            this.launchImpl(args);
        }
        catch (Throwable t) {
            System.err.println("IDE boot startup failed.");
            t.printStackTrace(System.err);
            System.exit(1);
        }
    }

    protected void launchImpl(String[] args) throws Exception {
        this.initSystemProperties();
        this.initURLStreamHandlerFactory();
        this.initPackagesTxtOptimization();
        this.bootClassLoadersAndMain(args);
    }

    protected void initSystemProperties() {
        Properties systemProperties = System.getProperties();
        if (systemProperties.getProperty("ide.product") == null) {
            System.out.println("*****");
            System.out.println("***** WARNING: The ide.product is not specified.  This is likely to result in a failed startup.");
            System.out.println("*****");
        }
        if (!systemProperties.containsKey("class.load.environment")) {
            systemProperties.setProperty("class.load.environment", "oracle.ide.boot.IdeClassLoadEnvironment");
        }
        System.setProperty("class.transfer", "delegate");
        if (!systemProperties.containsKey("java.library.path")) {
            String path = System.getenv("PATH");
            systemProperties.setProperty("java.library.path", path);
        }
    }

    protected void initURLStreamHandlerFactory() {
        URLStreamHandlerFactoryQueue.addHandler("code-source", SharedCodeSourceURL.HANDLER);
    }

    protected void initPackagesTxtOptimization() {
        SharedCodeSourceFactory.register("file", new IdeSharedCodeSourceFactory());
    }

    protected void bootClassLoadersAndMain(String[] args) throws Exception {
        InitialLoadersConfiguration config = this.getLoaderConfig(args);
        InitialLoadersFactory.configureMainAsSystemLoader();
        MainClass main = InitialLoadersFactory.create(config);
        main.invoke();
    }

    protected InitialLoadersConfiguration getLoaderConfig(String[] args) throws Exception {
        InputStream bootXml = Launcher.class.getClassLoader().getResourceAsStream("META-INF/ide-boot.xml");
        1 config = new 1(args, bootXml, new File("."), "META-INF/ide-boot.xml in ide-boot.jar", true, new Class[0], new String[0]);
        return config;
    }

    static ConfigurationPolicy newConfigurationPolicy(ConfigurationType[] supportedTypes, int sharedPolicy, boolean inheritImports, int defaultEqualityPolicy, boolean autoCommit, int category) {
        Class[] newArgTypes = new Class[]{ConfigurationType[].class, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Boolean.TYPE, Integer.TYPE};
        Constructor ctor = null;
        try {
            ctor = ConfigurationPolicy.class.getConstructor(newArgTypes);
            Object[] newArgs = new Object[]{supportedTypes, sharedPolicy, inheritImports, defaultEqualityPolicy, autoCommit, category};
            ConfigurationPolicy configurationPolicy = (ConfigurationPolicy)ctor.newInstance(newArgs);
            return configurationPolicy;
        }
        catch (NoSuchMethodException ex) {
            Class[] oldArgTypes = new Class[]{ConfigurationType[].class, Boolean.TYPE, Boolean.TYPE, Integer.TYPE, Boolean.TYPE, Integer.TYPE};
            try {
                ctor = ConfigurationPolicy.class.getConstructor(oldArgTypes);
                Object[] oldArgs = new Object[]{supportedTypes, Boolean.TRUE, inheritImports, defaultEqualityPolicy, autoCommit, category};
                ConfigurationPolicy configurationPolicy = (ConfigurationPolicy)ctor.newInstance(oldArgs);
                return configurationPolicy;
            }
            catch (Exception ex2) {
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return null;
    }

    private static boolean isDebugBuild() {
        return Boolean.getBoolean("ide.debugbuild");
    }

    final class 1
    extends XMLConfiguration {
        public String getApiExtensionProperty() {
            String apiExtDirs = super.getApiExtensionProperty();
            return apiExtDirs != null ? apiExtDirs : ClassLoadEnvironment.getDefaultApiExtensionKey();
        }

        public String getDefaultApiExtensionDirectory() {
            String libApiExt = super.getDefaultApiExtensionDirectory();
            return libApiExt != null ? libApiExt : ClassLoadEnvironment.getDefaultApiExtensionDirectory();
        }

        public MainClass configureLoaders() throws Exception {
            MainClass mainClass = super.configureLoaders();
            PolicyClassLoader mainLoader = mainClass.getLoader();
            this.setSharedAndNoAutoCommit(mainLoader);
            return mainClass;
        }

        private void setSharedAndNoAutoCommit(PolicyClassLoader pcl) {
            ConfigurationPolicy origConfigPolicy = pcl.getConfigurationPolicy();
            ConfigurationPolicy newConfigPolicy = IdeLauncher.newConfigurationPolicy(origConfigPolicy.getTypes(), 1, origConfigPolicy.shouldInheritImports(), 1, false, origConfigPolicy.getCategory());
            pcl.resetConfiguration(pcl.getName(), pcl.getVersionNumber(), newConfigPolicy);
        }

        public 1(String[] stringArray, InputStream inputStream, File file, String string, boolean bl, Class[] classArray, String[] stringArray2) throws Exception {
            super(stringArray, inputStream, file, string, bl, classArray, stringArray2);
        }
    }
}

