/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.boot;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.Arrays;

final class JarDirs {
    private static final int BUFFER_SIZE = 1024;
    private static final CharsetDecoder _decoder;
    private int _numEntries;
    private int _centralDirSize;
    private long _centralDirOffset;
    private int[] _dirHashes;
    private int _numHashes;

    static {
        CharsetDecoder decoder = null;
        try {
            Charset charset;
            InputStreamReader isr = new InputStreamReader(new ByteArrayInputStream(new byte[0]));
            String defaultEncoding = isr.getEncoding();
            if (!"Cp1252".equals(defaultEncoding) && (charset = Charset.forName(defaultEncoding)) != null) {
                decoder = charset.newDecoder();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        _decoder = decoder;
    }

    JarDirs(File jarFile) {
        this.getDirsImpl(jarFile);
    }

    int[] getHashes() {
        return this._dirHashes;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void getDirsImpl(File jarFile) {
        jar = null;
        try {
            try {
                block20: {
                    block19: {
                        jar = new RandomAccessFile(jarFile, "r");
                        if (this._centralDirSize == 0 && !this.findCDIR(jar, jarFile)) {
                            return;
                        }
                        cdir = new byte[this._centralDirSize];
                        jar.seek(this._centralDirOffset);
                        jar.readFully(cdir);
                        numLoops = 0;
                        chars = new char[1024];
                        this._dirHashes = new int[this._numEntries];
                        this._numHashes = 0;
                        if (JarDirs._decoder != null) break block19;
                        j = 0;
                        if (true) ** GOTO lbl36
                    }
                    byteBuffer = ByteBuffer.allocate(1024);
                    charBuffer = CharBuffer.wrap(chars);
                    j = 0;
                    if (true) ** GOTO lbl58
                    do {
                        filenameLen = JarDirs.get2LE(cdir, j + 28);
                        extraFieldLen = JarDirs.get2LE(cdir, j + 30);
                        commentLen = JarDirs.get2LE(cdir, j + 32);
                        entryNameOffset = j + 46;
                        i = filenameLen - 1;
                        while (i >= 0) {
                            chars[i] = (char)(cdir[entryNameOffset + i] & 255);
                            --i;
                        }
                        this.recordDir(chars, filenameLen);
                        j = entryNameOffset + filenameLen + extraFieldLen + commentLen;
                        ++numLoops;
lbl36:
                        // 2 sources

                    } while (j < this._centralDirSize && numLoops < this._numEntries);
                    break block20;
                    do {
                        filenameLen = JarDirs.get2LE(cdir, j + 28);
                        extraFieldLen = JarDirs.get2LE(cdir, j + 30);
                        commentLen = JarDirs.get2LE(cdir, j + 32);
                        entryNameOffset = j + 46;
                        byteBuffer.put(cdir, entryNameOffset, filenameLen);
                        byteBuffer.flip();
                        JarDirs._decoder.decode(byteBuffer, charBuffer, true);
                        byteBuffer.clear();
                        charBuffer.flip();
                        this.recordDir(chars, filenameLen);
                        charBuffer.clear();
                        j = entryNameOffset + filenameLen + extraFieldLen + commentLen;
                        ++numLoops;
lbl58:
                        // 2 sources

                    } while (j < this._centralDirSize && numLoops < this._numEntries);
                }
                this._dirHashes = JarDirs.sortAndTrim(this._numHashes, this._dirHashes);
                return;
            }
            finally {
                if (jar == null) return;
                try {
                    jar.close();
                    return;
                }
                catch (IOException var20_3) {
                    var20_3.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    static int[] sortAndTrim(int numHashes, int[] dirHashes) {
        int numUniqueHashes = 0;
        if (numHashes > 0) {
            Arrays.sort(dirHashes, 0, numHashes);
            int lastHash = dirHashes[0];
            ++numUniqueHashes;
            int i = 1;
            while (i < numHashes) {
                int curHash = dirHashes[i];
                if (curHash != lastHash) {
                    dirHashes[numUniqueHashes++] = curHash;
                    lastHash = curHash;
                }
                ++i;
            }
        }
        int[] trimmedHashes = new int[numUniqueHashes];
        System.arraycopy(dirHashes, 0, trimmedHashes, 0, numUniqueHashes);
        return trimmedHashes;
    }

    private static final int get2LE(byte[] b, int i) {
        return (b[i] & 0xFF) + ((b[i + 1] & 0xFF) << 8);
    }

    private static final int get4LE(byte[] b, int i) {
        return (b[i] & 0xFF) + ((b[i + 1] & 0xFF) << 8) + ((b[i + 2] & 0xFF) << 16) + (b[i + 3] << 24);
    }

    private boolean findCDIR(RandomAccessFile jar, File jarFile) throws IOException {
        long length = jar.length();
        long seek = length - (long)22;
        byte[] bytes = new byte[22];
        int remainingZipCommentLength = 65535;
        boolean centralDirectoryFound = false;
        while (seek >= 0L && remainingZipCommentLength > 0) {
            jar.seek(seek);
            jar.readFully(bytes);
            if (bytes[0] == 80 && bytes[1] == 75 && bytes[2] == 5 && bytes[3] == 6) {
                this._numEntries = JarDirs.get2LE(bytes, 10);
                this._centralDirSize = JarDirs.get4LE(bytes, 12);
                this._centralDirOffset = JarDirs.get4LE(bytes, 16);
                int actualCommentLength = 65535 - remainingZipCommentLength;
                if (actualCommentLength > 0) {
                    int commentLength = JarDirs.get2LE(bytes, 20);
                    if (commentLength != actualCommentLength) break;
                    centralDirectoryFound = true;
                    break;
                }
                centralDirectoryFound = true;
                break;
            }
            --seek;
            --remainingZipCommentLength;
        }
        if (!centralDirectoryFound) {
            System.err.println("****  WARNING -- Unable to find central directory for " + jarFile.getAbsolutePath());
        } else if (this._centralDirSize <= 0 || (long)this._centralDirSize >= length) {
            System.err.println("****  WARNING -- Bad central directory size (" + this._centralDirSize + ") for " + jarFile.getAbsolutePath());
        }
        return centralDirectoryFound;
    }

    private void recordDir(char[] chars, int len) {
        int lastSlash = len;
        while (lastSlash > 0) {
            if (chars[--lastSlash] == '/') break;
        }
        int hash = 0;
        int i = 0;
        while (i < lastSlash) {
            hash = 31 * hash + chars[i];
            ++i;
        }
        this._dirHashes[this._numHashes++] = hash;
    }
}

