/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.boot;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import oracle.classloader.ClassLoaderQuery;
import oracle.classloader.ConfigurationOrigin;
import oracle.classloader.ConfigurationType;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PCLMain {
    private static final String[] BOOT_ENTRIES = new String[]{"../classes/", "ide/lib/javax-ide.jar", "ide/lib/javatools.jar", "lib/java/shared/oracle.javatools/11.1.1.0.0/javatools-nodeps.jar", "ide/lib/ideimpl.jar", "ide/lib/idert.jar", "ide/extensions/oracle.ide.jar", "ide/lib/oicons.jar", "ide/lib/uic.jar", "ide/lib/audit-boot.jar", "ide/lib/indexing-migrator-boot.jar", "jlib/jewt4.jar", "jlib/share.jar", "jlib/help4.jar", "jlib/inspect4.jar", "lib/xmlparserv2.jar"};
    private static final String[] CFU_INSTALLER_JARS = new String[]{"jlib/share.jar", "jlib/jewt4.jar", "lib/xmlparserv2.jar", "ide/lib/javatools.jar", "lib/java/shared/oracle.javatools/11.1.1.0.0/javatools-nodeps.jar", "ide/lib/idert.jar", "ide/lib/ideimpl.jar", "ide/extensions/oracle.ide.webupdate.jar"};
    private static final String DEFERRED_UPDATE_MAIN_CLASS = "oracle.ideimpl.webupdate.DeferredUpdater";

    public static void main(String[] args) throws Exception {
        ClassLoader pcl = PCLMain.createExtensionManagerLoader();
        PCLMain.callMain(pcl, args);
    }

    private static void callMain(ClassLoader pcl, String[] args) throws Exception {
        Class<?> mainClass = Class.forName("oracle.ideimpl.Main", false, pcl);
        Method mainMethod = mainClass.getDeclaredMethod("main", String[].class);
        Thread.currentThread().setContextClassLoader(pcl);
        mainMethod.invoke(null, new Object[]{args});
    }

    private static ClassLoader createExtensionManagerLoader() {
        ConfigurationOrigin confOrig = new ConfigurationOrigin(ConfigurationType.MAIN_CLASS_PATH_ELEMENT, "PCLMain.createExtensionManagerLoader()");
        PolicyClassLoader classLoader = ClassLoaderQuery.findLoader("main");
        PCLMain.checkForDeferredUpdates(classLoader);
        ArrayList<File> classpath = new ArrayList<File>();
        PCLMain.addIdeLibs(classpath);
        PCLMain.addJdkLibs(classpath);
        for (File entry : classpath) {
            if (PCLMain.isDebugBuild()) {
                try {
                    if (entry.isDirectory()) {
                        PCLMain.generatePackagesTxtIfMissing(entry);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            try {
                classLoader.addCodeSource(entry, confOrig);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        PCLMain.addIdeNativeLibs(classLoader, confOrig);
        return classLoader;
    }

    private static void addJdkLibs(List<File> classpath) {
        String javaHome = System.getProperty("java.home");
        classpath.add(new File(javaHome, "../lib/tools.jar"));
        classpath.add(new File(javaHome, "../lib/dt.jar"));
    }

    private static void addIdeLibs(List<File> classpath) {
        File[] patchJars;
        File patchesDir;
        String patchesDirPath;
        Object[] moduleDirs;
        File builtDir;
        File file;
        String oracleHomeStr = System.getProperty("oracle.home");
        File oracleHome = new File(oracleHomeStr);
        String hotClasses = System.getProperty("edt.hot.classes");
        if (hotClasses != null && (file = new File(hotClasses)).isDirectory()) {
            classpath.add(file);
        }
        if (PCLMain.isDebugBuild() && !Boolean.getBoolean("ide.exclude.built.classes") && (builtDir = new File(oracleHome, "built")).isDirectory() && (moduleDirs = builtDir.listFiles()) != null) {
            boolean useInstrumented = System.getProperty("emma.coverage.out.file") != null;
            Arrays.sort(moduleDirs);
            int n = moduleDirs.length;
            int i = 0;
            while (i < n) {
                File classesIgnoreFile;
                Object moduleDir = moduleDirs[i];
                if (((File)moduleDir).isDirectory() && !(classesIgnoreFile = new File((File)moduleDir, ".ignore-built-classes")).exists()) {
                    if (useInstrumented) {
                        PCLMain.addClassesDirectory((File)moduleDir, "classes-instrumented", classpath);
                    }
                    PCLMain.addClassesDirectory((File)moduleDir, "classes", classpath);
                }
                ++i;
            }
        }
        if ((patchesDirPath = System.getProperty("ide.patches.dir")) != null && (patchesDir = new File(oracleHome, patchesDirPath)).isDirectory() && (patchJars = patchesDir.listFiles()) != null) {
            int n = patchJars.length;
            int i = 0;
            while (i < n) {
                File patchJar = patchJars[i];
                String patchJarPath = patchJar.getPath();
                if (patchJarPath.endsWith(".jar") || patchJarPath.endsWith(".zip")) {
                    classpath.add(patchJar);
                }
                ++i;
            }
        }
        String[] stringArray = BOOT_ENTRIES;
        int n = 0;
        while (n < stringArray.length) {
            String relativePath = stringArray[n];
            File file2 = new File(oracleHome, relativePath);
            if (file2.exists()) {
                file2 = FileUtils.getCanonicalFile(file2);
                classpath.add(file2);
            }
            ++n;
        }
        String ideJarsStr = System.getProperty("initial.classpath");
        if (ideJarsStr != null) {
            StringTokenizer st = new StringTokenizer(ideJarsStr);
            while (st.hasMoreTokens()) {
                String itemRelPath = st.nextToken();
                File file3 = new File(oracleHome, itemRelPath);
                if (!file3.exists()) continue;
                file3 = FileUtils.getCanonicalFile(file3);
                classpath.add(file3);
            }
        }
    }

    private static void addClassesDirectory(File moduleDir, String dir, List<File> classpath) {
        File moduleClassesDir = new File(moduleDir, dir);
        if (moduleClassesDir.isDirectory()) {
            boolean containsDirectory = false;
            File[] files = moduleClassesDir.listFiles();
            if (files != null) {
                int numFiles = files.length;
                int j = 0;
                while (j < numFiles) {
                    File file = files[j];
                    if (file != null && file.isDirectory()) {
                        containsDirectory = true;
                        break;
                    }
                    ++j;
                }
            }
            if (containsDirectory) {
                classpath.add(moduleClassesDir);
            }
        }
    }

    private static void generatePackagesTxtIfMissing(File classesDir) {
        PrintWriter out = null;
        try {
            try {
                File packagesTxt = new File(classesDir, "packages.txt");
                if (!packagesTxt.exists()) {
                    boolean mustTranslateToSlash = File.separatorChar != '/';
                    ArrayList subdirs = new ArrayList();
                    PCLMain.getAllDirs(classesDir, subdirs);
                    subdirs.remove(classesDir);
                    String classesDirStr = classesDir.getAbsolutePath();
                    int len = classesDirStr.length() + 1;
                    out = new PrintWriter(packagesTxt);
                    out.println("# This packages.txt was auto-generated at runtime.");
                    for (File f : subdirs) {
                        String packagePath = f.getAbsolutePath().substring(len);
                        if (mustTranslateToSlash) {
                            packagePath = packagePath.replace(File.separatorChar, '/');
                        }
                        out.println(packagePath);
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    private static void getAllDirs(File dir, ArrayList subdirs) {
        boolean hasFile = false;
        File[] fileArray = dir.listFiles();
        int n = 0;
        while (n < fileArray.length) {
            File f = fileArray[n];
            if (f.isDirectory()) {
                PCLMain.getAllDirs(f, subdirs);
            } else {
                hasFile = true;
            }
            ++n;
        }
        if (hasFile) {
            subdirs.add(dir);
        }
    }

    private static void addIdeNativeLibs(PolicyClassLoader pcl, ConfigurationOrigin confOrig) {
        String envLdLibraryPath;
        String envOracleHome;
        String oracleHomeStr = System.getProperty("oracle.home");
        File oracleHome = new File(oracleHomeStr);
        File oracleHomeLib = new File(oracleHome, "lib");
        try {
            pcl.addNativeCodeSource(oracleHomeLib, confOrig);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if ('\\' == File.separatorChar && (envOracleHome = System.getenv("ORACLE_HOME")) != null) {
            File oracleHomeBin = new File(envOracleHome, "bin");
            try {
                pcl.addNativeCodeSource(oracleHomeBin, confOrig);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if ('/' == File.separatorChar && (envLdLibraryPath = System.getenv("LD_LIBRARY_PATH")) != null) {
            try {
                pcl.addNativeCodeSource(envLdLibraryPath, confOrig);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void checkForDeferredUpdates(ClassLoader parentClassLoader) {
        File deferredUpdatesFile;
        String baseDir = System.getProperty("ide.user.dir");
        if (baseDir == null || baseDir.trim().length() == 0) {
            baseDir = System.getProperty("oracle.home");
        }
        if ((deferredUpdatesFile = new File(baseDir, "deferred-updates.xml")).exists()) {
            try {
                PCLMain.installUpdates(parentClassLoader, deferredUpdatesFile);
            }
            catch (IOException ioe) {
                deferredUpdatesFile.delete();
                ioe.printStackTrace();
            }
        }
    }

    private static void installUpdates(ClassLoader parentClassLoader, File script) throws IOException {
        String oracleHome = System.getProperty("oracle.home");
        URL[] cpEntries = new URL[CFU_INSTALLER_JARS.length];
        int i = 0;
        while (i < cpEntries.length) {
            cpEntries[i] = PCLMain.createTemporaryJarCopy(new File(oracleHome + "/" + CFU_INSTALLER_JARS[i])).toURL();
            ++i;
        }
        URLClassLoader updateLoader = new URLClassLoader(cpEntries, parentClassLoader);
        Thread.currentThread().setContextClassLoader(updateLoader);
        try {
            Class<?> duClazz = Class.forName(DEFERRED_UPDATE_MAIN_CLASS, true, updateLoader);
            Method mainMethod = duClazz.getMethod("install", null);
            mainMethod.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            IOException ioe = new IOException("Error launching installer");
            ioe.initCause(e);
            throw ioe;
        }
    }

    private static File createTemporaryJarCopy(File jarFile) throws IOException {
        AbstractInterruptibleChannel srcChannel = null;
        AbstractInterruptibleChannel dstChannel = null;
        File tempFile = File.createTempFile("oide", ".jar");
        tempFile.deleteOnExit();
        srcChannel = new FileInputStream(jarFile).getChannel();
        dstChannel = new FileOutputStream(tempFile).getChannel();
        ((FileChannel)dstChannel).transferFrom((ReadableByteChannel)((Object)srcChannel), 0L, ((FileChannel)srcChannel).size());
        File file = tempFile;
        try {
            return file;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            if (srcChannel != null) {
                try {
                    srcChannel.close();
                }
                catch (IOException iOException) {}
            }
            if (dstChannel != null) {
                try {
                    dstChannel.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static boolean isDebugBuild() {
        return Boolean.getBoolean("ide.debugbuild");
    }

    PCLMain() {
    }
}

