/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.filenav;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.raptor.BaseRaptorFilter;
import oracle.dbtools.raptor.filenav.DirectoryFolder;
import oracle.dbtools.raptor.filenav.FileElementFactory;
import oracle.dbtools.raptor.filenav.NavRoot;
import oracle.ide.explorer.TNode;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.javatools.data.PropertyStorage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryFilter
extends BaseRaptorFilter {
    private List<Element> m_children;

    public void closeChildren() {
        this.m_children = null;
    }

    public Iterator getChildren() {
        if (this.m_children == null) {
            this.m_children = this.loadChildren();
        }
        return this.m_children.iterator();
    }

    protected Object getKey(Object object) {
        if (object instanceof Locatable) {
            return ((Locatable)object).getURL();
        }
        return null;
    }

    private List<Element> loadChildren() {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        TNode tNode = this.getOwner();
        Project project = DirectoryFilter.getOwningProject(tNode);
        if (project != null) {
            DirectoryFolder directoryFolder = (DirectoryFolder)tNode.getData();
            ProjectContent projectContent = ProjectContent.getInstance((PropertyStorage)project);
            ContentSet contentSet = projectContent.getContentSet("RaptorFiles");
            if (contentSet != null) {
                String string = directoryFolder.getRelativePath();
                final URL uRL = directoryFolder.getRootURL();
                FileElementFactory fileElementFactory = FileElementFactory.getInstance();
                for (Object e : contentSet.getFilesAndDirectories(string, null, new URLFilter(){

                    public boolean accept(URL uRL2) {
                        return URLFileSystem.isBaseURLFor((URL)uRL, (URL)uRL2);
                    }
                })) {
                    URL uRL2 = (URL)e;
                    Element element = fileElementFactory.createElement(uRL2, uRL);
                    if (element == null) continue;
                    arrayList.add(element);
                }
            }
        }
        return arrayList;
    }

    private static Project getOwningProject(TNode tNode) {
        NavRoot navRoot = (NavRoot)tNode.getAncestor(NavRoot.class);
        return navRoot != null ? navRoot.getProject() : null;
    }
}

