/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.filenav;

import java.net.URL;
import oracle.ide.model.DefaultFolder;
import oracle.ide.model.Locatable;
import oracle.ide.net.URLFileSystem;

class DirectoryFolder
extends DefaultFolder
implements Locatable {
    private URL m_url;
    private URL m_root;
    private String m_label;
    private String m_relPath;

    protected DirectoryFolder(URL uRL) {
        this.setURL(uRL);
        this.m_root = uRL;
        this.m_relPath = "";
    }

    public DirectoryFolder(URL uRL, URL uRL2) {
        this.setURL(uRL);
        this.m_root = uRL2 != null ? uRL2 : URLFileSystem.getParent((URL)uRL);
        this.m_relPath = URLFileSystem.toRelativeSpec((URL)this.m_url, (URL)this.m_root);
    }

    protected String getSystemDisplayName() {
        return URLFileSystem.getSystemDisplayName((URL)this.m_url);
    }

    public String getLongLabel() {
        return this.getSystemDisplayName();
    }

    public String getShortLabel() {
        return this.m_label;
    }

    String getRelativePath() {
        return this.m_relPath;
    }

    public String getToolTipText() {
        return this.getLongLabel();
    }

    public URL getRootURL() {
        return this.m_root;
    }

    public URL getURL() {
        return this.m_url;
    }

    public void setURL(URL uRL) {
        this.m_url = uRL;
        this.setLabel(URLFileSystem.getFileName((URL)uRL));
    }

    protected void setLabel(String string) {
        this.m_label = string;
    }
}

