/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.filenav;

import oracle.dbtools.raptor.filenav.FileNavigatorManager;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.vcs.VCSManager;

public final class FileNavigatorContextMenuListener
implements ContextMenuListener {
    public boolean handleDefaultAction(Context context) {
        for (ContextMenuListener contextMenuListener : FileNavigatorContextMenuListener.getVCSContextMenuListeners()) {
            if (!contextMenuListener.handleDefaultAction(context)) continue;
            return true;
        }
        return false;
    }

    public void menuWillHide(ContextMenu contextMenu) {
        for (ContextMenuListener contextMenuListener : FileNavigatorContextMenuListener.getVCSContextMenuListeners()) {
            contextMenuListener.menuWillHide(contextMenu);
        }
    }

    public void menuWillShow(ContextMenu contextMenu) {
        Context context = contextMenu.getContext();
        if (FileNavigatorManager.isFileNavigatorContext(context)) {
            for (ContextMenuListener contextMenuListener : FileNavigatorContextMenuListener.getVCSContextMenuListeners()) {
                contextMenuListener.menuWillShow(contextMenu);
            }
        }
    }

    private static ContextMenuListener[] getVCSContextMenuListeners() {
        return VCSManager.getVCSManager().getContextMenuListeners();
    }
}

