/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.filenav;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.raptor.BaseRaptorFilter;
import oracle.dbtools.raptor.filenav.DirectoryRoot;
import oracle.dbtools.raptor.filenav.FileElementFactory;
import oracle.dbtools.raptor.filenav.NavRoot;
import oracle.dbtools.raptor.utils.URLChooserShortcuts;
import oracle.ide.Ide;
import oracle.ide.dialogs.URLChooserShortcut;
import oracle.ide.explorer.TNode;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectRootFilter
extends BaseRaptorFilter {
    private List<Element> m_children;

    protected Object getKey(Object object) {
        if (object instanceof Locatable) {
            return ((Locatable)object).getURL();
        }
        return null;
    }

    public void closeChildren() {
        this.m_children = null;
    }

    public Iterator getChildren() {
        if (this.m_children == null) {
            this.m_children = this.loadChildren();
        }
        return this.m_children.iterator();
    }

    private List<Element> loadChildren() {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        TNode tNode = this.getOwner();
        Element element = tNode.getData();
        if (element instanceof NavRoot) {
            ArrayList<DirectoryRoot> arrayList2 = new ArrayList<DirectoryRoot>();
            Object object = ((NavRoot)element).getChildren();
            while (object.hasNext()) {
                arrayList2.add((DirectoryRoot)((Object)object.next()));
            }
            object = URLChooserShortcuts.getShortcuts((boolean)false);
            Object object2 = object.iterator();
            while (object2.hasNext()) {
                URLChooserShortcut uRLChooserShortcut = (URLChooserShortcut)object2.next();
                URL uRL = uRLChooserShortcut.url();
                ProjectRootFilter.addFolder(uRL, arrayList2, arrayList);
            }
            object2 = URLFactory.newDirURL((String)Ide.getWorkDirectory());
            if (URLFileSystem.exists((URL)object2)) {
                ProjectRootFilter.addFolder((URL)object2, arrayList2, arrayList);
            }
            arrayList.addAll(arrayList2);
        }
        return arrayList;
    }

    private static void addFolder(URL uRL, List<DirectoryRoot> list, List<Element> list2) {
        URL uRL2 = ProjectRootFilter.findRoot(uRL, list);
        if (uRL2 != null) {
            list2.add((Element)FileElementFactory.getInstance().findOrCreateFolder(uRL, uRL2));
        }
    }

    public Comparator getComparator() {
        return null;
    }

    private static URL findRoot(URL uRL, List<DirectoryRoot> list) {
        for (DirectoryRoot directoryRoot : list) {
            URL uRL2 = directoryRoot.getRootURL();
            if (!URLFileSystem.isBaseURLFor((URL)uRL2, (URL)uRL)) continue;
            return uRL2;
        }
        return null;
    }

    static boolean isRoot(URL uRL) {
        Collection collection = URLChooserShortcuts.getShortcuts((boolean)false);
        for (URLChooserShortcut uRLChooserShortcut : collection) {
            if (!URLFileSystem.equals((URL)uRLChooserShortcut.url(), (URL)uRL)) continue;
            return true;
        }
        return false;
    }
}

