/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.VetoableChangeListener;
import javax.swing.AbstractAction;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.inspector.ActionContext;
import oracle.bali.inspector.InspectorBundle;

public abstract class AbstractCustomEditorAction
extends AbstractAction {
    public AbstractCustomEditorAction() {
        this(InspectorBundle.get("CUSTOM_EDITOR_TEXT"));
    }

    public AbstractCustomEditorAction(String name) {
        super(name);
    }

    public abstract Component getCustomEditor();

    private ActionContext context() {
        return ActionContext.contextFrom(this);
    }

    public void actionPerformed(ActionEvent e) {
        ActionContext context = this.context();
        Object oldValue = context.propertyEditorFactory().getValue();
        Component editorComponent = context.editorComponent();
        JEWTDialog editDialog = this.editPropertyDialog();
        Component customEditor = this.getCustomEditor();
        VetoableChangeListener vetoListener = this.vetoableChangeListenerFrom(customEditor);
        editDialog.setContent(customEditor);
        editDialog.pack();
        if (vetoListener != null) {
            editDialog.addVetoableChangeListener(vetoListener);
        }
        if (editDialog.runDialog()) {
            context.updateModelWithEditorFactoryValue();
        } else if (oldValue != context.propertyEditorFactory().getValue()) {
            context.propertyEditorFactory().setValue(oldValue);
        }
        if (vetoListener != null) {
            editDialog.removeVetoableChangeListener(vetoListener);
        }
        editDialog.dispose();
        if (editorComponent != null) {
            editorComponent.repaint();
        }
    }

    private VetoableChangeListener vetoableChangeListenerFrom(Component customEditor) {
        return customEditor instanceof VetoableChangeListener ? (VetoableChangeListener)((Object)customEditor) : null;
    }

    private JEWTDialog editPropertyDialog() {
        JEWTDialog dialog = JEWTDialog.createDialog((Component)this.context().customEditorButton(), (String)InspectorBundle.get("CUSTOM_EDITOR_DIALOG_TITLE"), (int)3);
        dialog.setModal(true);
        dialog.setResizable(true);
        return dialog;
    }
}

