/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector;

import java.awt.Component;
import javax.swing.Action;
import javax.swing.JButton;
import oracle.bali.inspector.PropertyEditorFactory2;
import oracle.bali.inspector.PropertyModel;

public final class ActionContext {
    private static final String ACTION_CONTEXT_PROPERTY = ActionContext.class.getName();
    private PropertyEditorFactory2 propertyEditorFactory;
    private PropertyModel propertyModel;
    private int propertyModelRow;
    private Component editorComponent;
    private JButton customEditorButton;

    public static ActionContext contextFrom(Action action) {
        return (ActionContext)action.getValue(ACTION_CONTEXT_PROPERTY);
    }

    public static Action updateContextIn(Action action, ActionContext context) {
        action.putValue(ACTION_CONTEXT_PROPERTY, context);
        return action;
    }

    public ActionContext(PropertyEditorFactory2 propertyEditorFactory, PropertyModel propertyModel, int propertyModelRow, Component editorComponent, JButton customEditorButton) {
        this.propertyEditorFactory = propertyEditorFactory;
        this.propertyModel = propertyModel;
        this.propertyModelRow = propertyModelRow;
        this.editorComponent = editorComponent;
        this.customEditorButton = customEditorButton;
    }

    public void updateModelWithEditorFactoryValue() {
        try {
            this.propertyModel.setPropertyValue(this.propertyModelRow, this.propertyEditorFactory.getValue());
        }
        catch (Throwable t) {
            System.err.println("Exception setting property value: " + t);
        }
    }

    public void dispose() {
        this.propertyEditorFactory = null;
        this.propertyModel = null;
        this.editorComponent = null;
        this.customEditorButton = null;
    }

    public PropertyEditorFactory2 propertyEditorFactory() {
        return this.propertyEditorFactory;
    }

    public PropertyModel propertyModel() {
        return this.propertyModel;
    }

    public int propertyModelRow() {
        return this.propertyModelRow;
    }

    public Component editorComponent() {
        return this.editorComponent;
    }

    public JButton customEditorButton() {
        return this.customEditorButton;
    }
}

