/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector;

import java.util.Hashtable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import oracle.bali.inspector.PropertyModel;

class ColumnModel
extends DefaultTableColumnModel {
    private Hashtable _columnCache;
    private Object[] _visibleColumns;
    private PropertyModel _model;
    private ColumnSetListener _propertyModelListener;

    public ColumnModel() {
        this.$init$();
        this._visibleColumns = new Object[]{PropertyModel.COLUMN_DISPLAY_NAME, PropertyModel.COLUMN_VALUE};
        this._propertyModelListener = new ColumnSetListener(null);
    }

    public void setPropertyModel(PropertyModel newModel) {
        if (newModel != this._model) {
            if (this._model != null) {
                this._model.removeTableModelListener(this._propertyModelListener);
            }
            this._model = newModel;
            if (newModel != null) {
                this._model.addTableModelListener(this._propertyModelListener);
            }
            this._updateVisibleColumns();
        }
    }

    public void setVisibleColumnIDs(Object[] visibleColumns) {
        if (!this._equals(this._visibleColumns, visibleColumns)) {
            this._visibleColumns = visibleColumns;
            this._updateVisibleColumns();
        }
    }

    public Object[] getVisibleColumnIDs() {
        return this._visibleColumns;
    }

    public TableColumn getTableColumn(Object columnID) {
        int modelIndex = this._model != null ? this._model.getColumnIndex(columnID) : -1;
        return this._getColumn(columnID, modelIndex);
    }

    private void _updateVisibleColumns() {
        int columnCount = this.getColumnCount();
        int i = columnCount - 1;
        while (i >= 0) {
            this.removeColumn(this.getColumn(i));
            --i;
        }
        PropertyModel model = this._model;
        if (model != null) {
            int i2 = 0;
            while (i2 < this._visibleColumns.length) {
                Object visibleColumnID = this._visibleColumns[i2];
                int modelIndex = model.getColumnIndex(visibleColumnID);
                if (modelIndex != -1) {
                    this.addColumn(this._getColumn(visibleColumnID, modelIndex));
                }
                ++i2;
            }
        }
    }

    private TableColumn _getColumn(Object columnID, int modelIndex) {
        TableColumn cachedColumn = (TableColumn)this._columnCache.get(columnID);
        if (cachedColumn == null) {
            cachedColumn = new TableColumn(modelIndex);
            cachedColumn.setIdentifier(columnID);
            this._columnCache.put(columnID, cachedColumn);
        } else {
            cachedColumn.setModelIndex(modelIndex);
        }
        return cachedColumn;
    }

    private boolean _equals(Object[] a1, Object[] a2) {
        if (a1 == a2) {
            return true;
        }
        if (a1 == null || a2 == null) {
            return false;
        }
        int length = a1.length;
        if (a2.length != length) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (a1[i] != a2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void $init$() {
        this._columnCache = new Hashtable(13);
    }

    static void mav$_updateVisibleColumns(ColumnModel columnModel) {
        columnModel._updateVisibleColumns();
    }

    private class ColumnSetListener
    implements TableModelListener {
        public void tableChanged(TableModelEvent e) {
            if (e.getFirstRow() == -1) {
                ColumnModel.mav$_updateVisibleColumns(ColumnModel.this);
            }
        }

        private ColumnSetListener() {
        }

        ColumnSetListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

