/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.ewt.button.PushButton;
import oracle.bali.ewt.help.HelpUnavailableException;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.ewt.util.WindowUtils;
import oracle.bali.inspector.PropertyEditorFactory;
import oracle.bali.inspector.PropertyInspector;
import oracle.bali.inspector.PropertyModel;
import oracle.bali.inspector.multi.MultiObjectModel;
import oracle.bali.inspector.multi.SelectionModel;
import oracle.bali.share.nls.LocaleUtils;
import oracle.bali.share.nls.StringUtils;
import oracle.bali.share.thread.Task;
import oracle.bali.share.thread.TaskEvent;
import oracle.bali.share.thread.TaskScheduler;

public class InspectorGroup {
    private static boolean _sMethodInitialized = false;
    private static Method _sGetCauseMethod;
    private static final String _OK_COMMAND = "OK";
    private static final String _CANCEL_COMMAND = "Cancel";
    private static final String _HELP_COMMAND = "Help";
    private static final String _SIMULATE_HELP_COMMAND = "SimulateHelp";
    private static final String _KEY_HELP = "HELP";
    private static final String _KEY_OK = "OK";
    private static final String _KEY_CANCEL = "CANCEL";
    private static final String _KEY_SHORT_ERROR = "SHORT_ERROR";
    private static final String _KEY_LONG_ERROR = "LONG_ERROR";
    private static final String _KEY_SHORT_ERROR_REASON = "SHORT_ERROR_REASON";
    private static final String _KEY_LONG_ERROR_REASON = "LONG_ERROR_REASON";
    private SelectionModel _selectionModel;
    private PropertyModel _model;
    private Vector _inspectors;
    private Hashtable _isPinned;
    private Hashtable _tearOffEditors;
    private Hashtable _propertyIDs;
    private Hashtable _listeners;
    private Object _advancedID;
    private PropertyEditorFactory _advancedFactory;
    private PropertyInspector _advancedInspector;
    private int _tearOffVisibleCount;
    private boolean _inShowAdvancedEditor;
    private CustomDialogHandler _dialogHandler;
    private JDialog _advancedDialog;
    private boolean _ok;

    public static void showErrorMessage(Object propertyID, PropertyEditorFactory editorFactory, JTable table, Throwable throwable, Object value) {
        boolean emptyReason;
        Throwable cause = InspectorGroup._getCause(throwable);
        TaskScheduler ts = new TaskScheduler();
        ts.setName("Error thread");
        PropertyModel ds = (PropertyModel)table.getModel();
        Locale locale = LocaleUtils.getDefaultableLocale((Component)table);
        int index = ds.getPropertyIndex(propertyID);
        String propertyName = ds.getPropertyDisplayName(index, locale);
        String dataString = value != null ? value.toString() : null;
        String reason = cause.getLocalizedMessage();
        if (reason == null || "".equals(reason)) {
            reason = cause.getMessage();
        }
        boolean bl = emptyReason = reason == null || "".equals(reason);
        String key = dataString == null ? (emptyReason ? _KEY_SHORT_ERROR : _KEY_SHORT_ERROR_REASON) : (emptyReason ? _KEY_LONG_ERROR : _KEY_LONG_ERROR_REASON);
        String text = InspectorGroup._getTranslatedString(locale, key);
        MessageFormat form = new MessageFormat(text);
        Object[] args = dataString == null ? (emptyReason ? new Object[]{propertyName} : new Object[]{propertyName, reason}) : (emptyReason ? new Object[]{propertyName, dataString} : new Object[]{propertyName, dataString, reason});
        String message = form.format(args);
        JTable tbl = table;
        ts.schedule((Task)new 1(tbl, message), 100);
    }

    public InspectorGroup() {
        this.$init$();
    }

    public void setSelectionModel(SelectionModel newSelection) {
        if (newSelection != this._selectionModel) {
            this._model = this.createPropertyModel(newSelection);
        }
    }

    public SelectionModel getSelectionModel() {
        return this._selectionModel;
    }

    public void setInspectorPinned(PropertyInspector pinee, boolean isPinned) {
        boolean wasPinned = (Boolean)this._isPinned.get(pinee);
        if (isPinned != wasPinned) {
            this._isPinned.put(pinee, isPinned ? Boolean.TRUE : Boolean.FALSE);
            PropertyModel newModel = this.getPropertyModel();
            if (isPinned) {
                SelectionModel currSelection = this.getSelectionModel();
                SelectionModel newSelection = currSelection != null ? currSelection.copyContents() : null;
                newModel = this.createPropertyModel(newSelection);
            }
            pinee.setUnderlyingPropertyModel(newModel);
        }
    }

    public boolean isInspectorPinned(PropertyInspector pinee) {
        Object o = this._isPinned.get(pinee);
        return o == null ? false : Boolean.TRUE.equals(o);
    }

    public PropertyModel getPropertyModel() {
        return this._model;
    }

    public void showTearOffEditor(Object propertyID, PropertyEditorFactory editorFactory, PropertyInspector inspector) {
        Container tearOffContainer = (Container)this._tearOffEditors.get(propertyID);
        if (tearOffContainer != null) {
            TearOffListener l = (TearOffListener)this._listeners.remove(tearOffContainer);
            l.dispose();
        }
        if (tearOffContainer == null) {
            PropertyModel ds = inspector.getPropertyModel();
            int columnIndex = ds.getColumnIndex(PropertyModel.COLUMN_VALUE);
            Object value = ds.getPropertyByID(columnIndex, propertyID);
            editorFactory.setEditorValue(value);
            Component tearOffEditor = editorFactory.getTearOffEditor();
            SwingUtilities.updateComponentTreeUI(tearOffEditor);
            tearOffContainer = this.createEditorParent(inspector, tearOffEditor);
            tearOffContainer.setLocale(LocaleUtils.getDefaultableLocale((Component)inspector));
            this._tearOffEditors.put(propertyID, tearOffContainer);
            this._propertyIDs.put(tearOffContainer, propertyID);
            this.sizeAndPositionTearOffEditor(tearOffContainer, inspector);
            tearOffContainer.setVisible(true);
        }
        String title = this.getTearOffTitle(propertyID, editorFactory, inspector);
        if (tearOffContainer instanceof Frame) {
            ((Frame)tearOffContainer).setTitle(title);
        } else if (tearOffContainer instanceof Dialog) {
            ((Dialog)tearOffContainer).setTitle(title);
        }
        TearOffListener tol = new TearOffListener(propertyID, editorFactory, inspector);
        this._listeners.put(tearOffContainer, tol);
        ++this._tearOffVisibleCount;
        this.sizeAndPositionTearOffEditor(tearOffContainer, inspector);
        this.raiseTearOffEditor(tearOffContainer);
    }

    protected void addInspector(PropertyInspector newInspector) {
        if (newInspector == null) {
            throw new IllegalArgumentException();
        }
        if (this._inspectors.indexOf(newInspector) == -1) {
            this._inspectors.addElement(newInspector);
            this._isPinned.put(newInspector, Boolean.FALSE);
        }
    }

    protected void removeInspector(PropertyInspector oldInspector) {
        if (oldInspector == null) {
            throw new IllegalArgumentException();
        }
        if (this._inspectors.indexOf(oldInspector) != -1) {
            this._inspectors.removeElement(oldInspector);
            this._isPinned.remove(oldInspector);
        }
    }

    protected boolean isHelpDisplayed(Object propertyID, PropertyEditorFactory editorFactory, PropertyInspector inspector) {
        return false;
    }

    protected PropertyModel createPropertyModel(SelectionModel selection) {
        if (selection != null) {
            MultiObjectModel model = new MultiObjectModel();
            model.setSelectionModel(selection);
            return model;
        }
        return null;
    }

    protected String getAdvancedEditorTitle(Object propertyID, PropertyEditorFactory editorFactory, PropertyInspector inspector) {
        int columnIndex;
        PropertyModel ds = inspector.getPropertyModel();
        Object value = ds.getPropertyByID(columnIndex = ds.getColumnIndex(PropertyModel.COLUMN_DISPLAY_NAME), propertyID);
        return value == null || value == PropertyModel.DOES_NOT_EXIST ? null : value.toString();
    }

    protected boolean showAdvancedEditor(Object propertyID, PropertyEditorFactory editorFactory, PropertyInspector inspector) {
        this._ok = true;
        this.showAdvancedEditorDialog(propertyID, editorFactory, inspector);
        return this._ok;
    }

    protected void showAdvancedEditorDialog(Object propertyID, PropertyEditorFactory editorFactory, PropertyInspector inspector) {
        if (this._inShowAdvancedEditor) {
            return;
        }
        this._ok = false;
        this._inShowAdvancedEditor = true;
        try {
            Locale locale = LocaleUtils.getDefaultableLocale((Component)inspector);
            Frame parentFrame = WindowUtils.parentFrame((Component)inspector);
            JDialog editorDialog = new JDialog(parentFrame, this.getAdvancedEditorTitle(propertyID, editorFactory, inspector), true);
            PropertyModel ds = inspector.getPropertyModel();
            int columnIndex = ds.getColumnIndex(PropertyModel.COLUMN_VALUE);
            Object value = ds.getPropertyByID(columnIndex, propertyID);
            editorFactory.setEditorValue(value);
            Component advancedEditor = editorFactory.getAdvancedEditor();
            DialogButtonBar okCancelBar = new DialogButtonBar();
            CustomDialogHandler dialogHandler = new CustomDialogHandler(propertyID, editorFactory, inspector, advancedEditor);
            String label = InspectorGroup._getTranslatedString(locale, "OK");
            PushButton okButton = new PushButton(label);
            okButton.setActionCommand("OK");
            okButton.addActionListener((ActionListener)dialogHandler);
            okButton.setDefaultCapable(true);
            editorDialog.getRootPane().setDefaultButton((JButton)okButton);
            okCancelBar.add((Component)okButton, DialogButtonBar.CONSTRAINT_YES);
            label = InspectorGroup._getTranslatedString(locale, _KEY_CANCEL);
            PushButton cancelButton = new PushButton(label);
            cancelButton.addActionListener((ActionListener)dialogHandler);
            cancelButton.setActionCommand(_CANCEL_COMMAND);
            cancelButton.registerKeyboardAction((ActionListener)dialogHandler, _CANCEL_COMMAND, KeyStroke.getKeyStroke(27, 0), 2);
            okCancelBar.add((Component)cancelButton, DialogButtonBar.CONSTRAINT_CANCEL);
            PushButton helpButton = null;
            if (this.isHelpDisplayed(propertyID, editorFactory, inspector)) {
                String helpLabel = InspectorGroup._getTranslatedString(locale, _KEY_HELP);
                helpButton = new PushButton(StringUtils.stripMnemonic((String)helpLabel));
                helpButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)helpLabel));
                helpButton.setActionCommand(_HELP_COMMAND);
                helpButton.addActionListener((ActionListener)dialogHandler);
                helpButton.registerKeyboardAction((ActionListener)dialogHandler, _SIMULATE_HELP_COMMAND, KeyStroke.getKeyStroke(112, 0), 2);
                helpButton.registerKeyboardAction((ActionListener)dialogHandler, _SIMULATE_HELP_COMMAND, KeyStroke.getKeyStroke(156, 0), 2);
                okCancelBar.add((Component)helpButton, DialogButtonBar.CONSTRAINT_HELP);
            }
            SwingUtilities.updateComponentTreeUI(advancedEditor);
            editorDialog.getContentPane().add("Center", advancedEditor);
            editorDialog.getContentPane().add("South", (Component)okCancelBar);
            editorDialog.addWindowListener(dialogHandler);
            editorDialog.setLocale(locale);
            editorDialog.pack();
            WindowUtils.centerWindow((Window)editorDialog, (Component)inspector);
            this._advancedInspector = inspector;
            this._advancedFactory = editorFactory;
            this._advancedID = propertyID;
            this._dialogHandler = dialogHandler;
            this._advancedDialog = editorDialog;
            editorDialog.setVisible(true);
            cancelButton.removeActionListener((ActionListener)dialogHandler);
            cancelButton.unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0));
            okButton.removeActionListener((ActionListener)dialogHandler);
            if (helpButton != null) {
                helpButton.removeActionListener((ActionListener)dialogHandler);
                helpButton.unregisterKeyboardAction(KeyStroke.getKeyStroke(112, 0));
                helpButton.unregisterKeyboardAction(KeyStroke.getKeyStroke(156, 0));
            }
            dialogHandler.dispose();
            this._dialogHandler = null;
            this._advancedDialog = null;
            this._advancedInspector = null;
            this._advancedFactory = null;
            this._advancedID = null;
        }
        finally {
            this._inShowAdvancedEditor = false;
        }
    }

    protected void hideAdvancedEditorDialog(boolean isOK) {
        if (this._dialogHandler != null && this._advancedDialog != null) {
            CustomDialogHandler.mav$_dismissDialog(this._dialogHandler, this._advancedDialog, isOK);
        }
    }

    protected String getTearOffTitle(Object propertyID, PropertyEditorFactory editorFactory, PropertyInspector inspector) {
        int columnIndex;
        PropertyModel ds = inspector.getPropertyModel();
        Object value = ds.getPropertyByID(columnIndex = ds.getColumnIndex(PropertyModel.COLUMN_DISPLAY_NAME), propertyID);
        return value == null || value == PropertyModel.DOES_NOT_EXIST ? null : value.toString();
    }

    protected Container createEditorParent(PropertyInspector inspector, Component tearOffEditor) {
        Frame parentFrame = WindowUtils.parentFrame((Component)inspector);
        JDialog tearOffContainer = new JDialog(parentFrame, false);
        tearOffContainer.addWindowListener(new WindowCloser(null));
        tearOffContainer.getContentPane().add("Center", tearOffEditor);
        return tearOffContainer;
    }

    protected void disposeEditorParent(Container parent) {
        if (parent instanceof Window) {
            ((Window)parent).dispose();
        }
    }

    protected void sizeAndPositionTearOffEditor(Container tearOffContainer, PropertyInspector inspector) {
        Window containerWindow = (Window)tearOffContainer;
        containerWindow.pack();
        WindowUtils.centerWindow((Window)containerWindow, (Component)inspector);
    }

    protected void raiseTearOffEditor(Container tearOffContainer) {
        if (tearOffContainer instanceof Window) {
            ((Window)tearOffContainer).toFront();
        }
    }

    protected final void closeTearOffEditor(Container tearOffContainer) {
        Object propertyID = this._propertyIDs.remove(tearOffContainer);
        this._tearOffEditors.remove(propertyID);
        TearOffListener tol = (TearOffListener)this._listeners.remove(tearOffContainer);
        tearOffContainer.setVisible(false);
        this.disposeEditorParent(tearOffContainer);
        tol.dispose();
        --this._tearOffVisibleCount;
    }

    protected void showErrorMessage(Object propertyID, PropertyEditorFactory editorFactory, PropertyInspector inspector, Throwable throwable, Object value) {
        InspectorGroup.showErrorMessage(propertyID, editorFactory, inspector.getPropertyTable(), throwable, value);
    }

    boolean __isAdvancedEditorVisible() {
        return this._advancedInspector != null;
    }

    boolean __isTearOffEditorVisible() {
        return this._tearOffVisibleCount > 0;
    }

    private static String _getTranslatedString(Locale locale, String key) {
        ResourceBundle b = ResourceBundle.getBundle("oracle.bali.inspector.resource.InspectorBundle");
        return b.getString(key);
    }

    private static Throwable _getCause(Throwable t) {
        if (!_sMethodInitialized) {
            try {
                Class<Throwable> c = Throwable.class;
                _sGetCauseMethod = c.getMethod("getCause", null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            _sMethodInitialized = true;
        }
        if (_sGetCauseMethod != null) {
            try {
                Throwable cause = (Throwable)_sGetCauseMethod.invoke((Object)t, null);
                if (cause != null) {
                    t = cause;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return t;
    }

    private void $init$() {
        this._inspectors = new Vector();
        this._isPinned = new Hashtable(7);
        this._tearOffEditors = new Hashtable(7);
        this._propertyIDs = new Hashtable(7);
        this._listeners = new Hashtable(7);
        this._tearOffVisibleCount = 0;
    }

    static PropertyInspector ra$_advancedInspector(InspectorGroup inspectorGroup) {
        return inspectorGroup._advancedInspector;
    }

    static PropertyEditorFactory ra$_advancedFactory(InspectorGroup inspectorGroup) {
        return inspectorGroup._advancedFactory;
    }

    static Object ra$_advancedID(InspectorGroup inspectorGroup) {
        return inspectorGroup._advancedID;
    }

    static void wa$_ok(InspectorGroup inspectorGroup, boolean bl) {
        inspectorGroup._ok = bl;
    }

    static final class 1
    implements Task {
        private final /* synthetic */ JTable v$tbl;
        private final /* synthetic */ String v$message;

        public void runTask(TaskEvent e) {
            JOptionPane.showOptionDialog(this.v$tbl, this.v$message, null, -1, 0, null, null, null);
        }

        public 1(JTable jTable, String string) {
            this.v$message = string;
            this.v$tbl = jTable;
        }
    }

    private class TearOffListener
    implements PropertyChangeListener {
        private PropertyEditorFactory _editorFactory;
        private Object _editedProperty;
        private PropertyInspector _editingInspector;

        public TearOffListener(Object propertyID, PropertyEditorFactory editorFactory, PropertyInspector inspector) {
            this._editedProperty = propertyID;
            this._editorFactory = editorFactory;
            this._editingInspector = inspector;
            this._editorFactory.addPropertyChangeListener(this);
        }

        public void dispose() {
            this._editorFactory.removePropertyChangeListener(this);
            PropertyInspector pi = this._editingInspector;
            SwingUtilities.invokeLater(new 1(this, pi));
            this._editedProperty = null;
            this._editorFactory = null;
            this._editingInspector = null;
        }

        public void propertyChange(PropertyChangeEvent e) {
            if (InspectorGroup.ra$_advancedInspector(InspectorGroup.this) == this._editingInspector && InspectorGroup.ra$_advancedFactory(InspectorGroup.this) == this._editorFactory && this._editedProperty == InspectorGroup.ra$_advancedID(InspectorGroup.this)) {
                return;
            }
            PropertyModel model = this._editingInspector.getPropertyModel();
            PropertyEditorFactory f = (PropertyEditorFactory)e.getSource();
            Object newValue = f.getEditorValue();
            int columnIndex = model.getColumnIndex(PropertyModel.COLUMN_VALUE);
            try {
                TableCellEditor editor = this._editingInspector.getPropertyTable().getCellEditor();
                if (editor != null) {
                    editor.cancelCellEditing();
                }
                model.setPropertyByID(columnIndex, this._editedProperty, newValue);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable th) {
                InspectorGroup.this.showErrorMessage(this._editedProperty, this._editorFactory, this._editingInspector, th, newValue);
            }
        }

        final class 1
        implements Runnable {
            private final /* synthetic */ PropertyInspector v$pi;
            final /* synthetic */ TearOffListener this$0;

            public void run() {
                this.v$pi.getPropertyTable().requestFocus();
            }

            public 1(TearOffListener tearOffListener, PropertyInspector propertyInspector) {
                this.v$pi = propertyInspector;
                this.this$0 = tearOffListener;
            }
        }
    }

    private class WindowCloser
    extends WindowAdapter {
        public void windowClosing(WindowEvent event) {
            InspectorGroup.this.closeTearOffEditor(event.getWindow());
            event.getWindow().removeWindowListener(this);
        }

        private WindowCloser() {
        }

        WindowCloser(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class CustomDialogHandler
    extends WindowAdapter
    implements ActionListener {
        private PropertyEditorFactory _editorFactory;
        private Object _editedProperty;
        private PropertyInspector _editingInspector;
        private Component _helpComponent;

        public CustomDialogHandler(Object propertyID, PropertyEditorFactory editorFactory, PropertyInspector inspector, Component helpComponent) {
            this._editedProperty = propertyID;
            this._editorFactory = editorFactory;
            this._editingInspector = inspector;
            this._helpComponent = helpComponent;
        }

        public void dispose() {
            this._editedProperty = null;
            this._editorFactory = null;
            this._helpComponent = null;
        }

        public void windowClosing(WindowEvent event) {
            this._dismissDialog(event.getWindow(), false);
        }

        public void windowClosed(WindowEvent e) {
            e.getWindow().removeWindowListener(this);
            this._editingInspector.getPropertyTable().requestFocus();
            this._editingInspector = null;
        }

        public void actionPerformed(ActionEvent event) {
            String command = event.getActionCommand();
            if ("OK".equals(command) || InspectorGroup._CANCEL_COMMAND.equals(command)) {
                this._dismissDialog(WindowUtils.getWindow((Component)((Component)event.getSource())), command == "OK");
            } else if (InspectorGroup._SIMULATE_HELP_COMMAND.equals(command)) {
                if (event.getSource() instanceof AbstractButton) {
                    ((AbstractButton)event.getSource()).doClick();
                }
            } else if (InspectorGroup._HELP_COMMAND.equals(command)) {
                try {
                    HelpUtils.showHelp((Component)this._helpComponent);
                }
                catch (HelpUnavailableException helpUnavailableException) {
                    // empty catch block
                }
            }
        }

        private void _dismissDialog(Window dialog, boolean isOK) {
            InspectorGroup.wa$_ok(InspectorGroup.this, isOK);
            dialog.setVisible(false);
            if (isOK) {
                PropertyInspector inspector = this._editingInspector;
                PropertyModel model = inspector.getPropertyModel();
                Object property = this._editedProperty;
                PropertyEditorFactory factory = this._editorFactory;
                Object newValue = factory.getEditorValue();
                int columnIndex = model.getColumnIndex(PropertyModel.COLUMN_VALUE);
                TableCellEditor editor = inspector.getPropertyTable().getCellEditor();
                if (editor != null) {
                    editor.cancelCellEditing();
                }
                SwingUtilities.invokeLater(new 1(this, model, columnIndex, property, newValue, factory, inspector));
            }
            dialog.dispose();
        }

        static void mav$_dismissDialog(CustomDialogHandler customDialogHandler, Window window, boolean bl) {
            customDialogHandler._dismissDialog(window, bl);
        }

        final class 1
        implements Runnable {
            private final /* synthetic */ PropertyModel v$model;
            private final /* synthetic */ int v$columnIndex;
            private final /* synthetic */ Object v$property;
            private final /* synthetic */ Object v$newValue;
            private final /* synthetic */ PropertyEditorFactory v$factory;
            private final /* synthetic */ PropertyInspector v$inspector;
            final /* synthetic */ CustomDialogHandler this$0;

            public void run() {
                try {
                    this.v$model.setPropertyByID(this.v$columnIndex, this.v$property, this.v$newValue);
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable th) {
                    this.this$0.InspectorGroup.this.showErrorMessage(this.v$property, this.v$factory, this.v$inspector, th, this.v$newValue);
                }
            }

            public 1(CustomDialogHandler customDialogHandler, PropertyModel propertyModel, int n, Object object, Object object2, PropertyEditorFactory propertyEditorFactory, PropertyInspector propertyInspector) {
                this.v$inspector = propertyInspector;
                this.v$factory = propertyEditorFactory;
                this.v$newValue = object2;
                this.v$property = object;
                this.v$columnIndex = n;
                this.v$model = propertyModel;
                this.this$0 = customDialogHandler;
            }
        }
    }
}

