/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector;

import java.beans.PropertyEditor;
import oracle.bali.inspector.editor.EditorComponentInfo;
import oracle.bali.inspector.editor.TextFieldEditor;
import oracle.bali.inspector.editor.ToStringConverter;

public final class JavaBeansEditorComponentInfo
extends EditorComponentInfo {
    private PropertyEditor javaBeansPropertyEditor;
    private Object initialValue;
    private static final String FORCE_TEXTFIELD_INLINE_EDITOR_CREATION = "";

    public JavaBeansEditorComponentInfo(PropertyEditor javaBeansPropertyEditor) {
        this.updateJavaBeansPropertyEditor(javaBeansPropertyEditor);
    }

    public void updateJavaBeansPropertyEditor(PropertyEditor javaBeansPropertyEditor) {
        this.javaBeansPropertyEditor = javaBeansPropertyEditor;
        this.updateInitialValue(this.javaBeansPropertyEditor.getTags());
    }

    public void updateInitialValue(Object initialValue) {
        if (initialValue instanceof String) {
            this.initialValue = this.initialValue((String)initialValue);
            return;
        }
        if (initialValue instanceof String[]) {
            this.initialValue = this.initialValue((String[])initialValue);
            return;
        }
        this.initialValue = initialValue;
    }

    private Object initialValue(String[] editorTags) {
        if (editorTags != null && editorTags.length > 1) {
            return editorTags;
        }
        if (editorTags != null && editorTags.length == 1) {
            return this.initialValue(editorTags[0]);
        }
        return this.initialValue(this.javaBeansPropertyEditor.getAsText());
    }

    private String initialValue(String s) {
        return TextFieldEditor.cleanNullText(s);
    }

    private static boolean isSunStringEditor(PropertyEditor javaBeansPropertyEditor) {
        if (javaBeansPropertyEditor == null) {
            return false;
        }
        String currentTypeName = javaBeansPropertyEditor.getClass().getName();
        return "sun.beans.editors.StringEditor".equals(currentTypeName);
    }

    public Object initialValue() {
        return this.initialValue;
    }

    public ToStringConverter editorValueToStringConverter() {
        return null;
    }

    public PropertyEditor getPropertyEditor() {
        return this.javaBeansPropertyEditor;
    }
}

