/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.EventObject;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import oracle.bali.inspector.DisplayValueRenderer;
import oracle.bali.inspector.PropertyEditorRenderer;
import oracle.bali.inspector.swing.AbstractTableCellEditor;

class NullEditor
extends AbstractTableCellEditor {
    private JPanel _panel = new JPanel();
    private Component _child;
    private Object _value;
    private JLabel _label;
    private ImageGenerator _listener;
    private static final TableCellEditor _sInstance = new NullEditor();

    public static TableCellEditor getTableCellEditor() {
        return _sInstance;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this._value = value;
        this._clearImage();
        return this._panel;
    }

    public Object getCellEditorValue() {
        return this._value;
    }

    public boolean isCellEditable(EventObject anEvent) {
        return false;
    }

    public void dispose() {
        this._clearImage();
        if (this._label != null) {
            this._panel.removeComponentListener(this._listener);
            this._panel.remove(this._label);
        }
        this._label = null;
        this._child = null;
        this._value = null;
        this._listener = null;
    }

    protected NullEditor(Component child) {
        this();
        this._child = child;
        if (child != null) {
            this._label = new JLabel();
            this._panel.setLayout(new BorderLayout());
            this._panel.add("West", this._label);
            this._listener = new ImageGenerator(null);
            this._panel.addComponentListener(this._listener);
        }
    }

    private NullEditor() {
    }

    private void _clearImage() {
        if (this._label != null) {
            ImageIcon old = (ImageIcon)this._label.getIcon();
            this._label.setIcon(null);
            if (old != null) {
                old.getImage().flush();
            }
            this._listener.init();
        }
    }

    static Component ra$_child(NullEditor nullEditor) {
        return nullEditor._child;
    }

    static Object ra$_value(NullEditor nullEditor) {
        return nullEditor._value;
    }

    static JLabel ra$_label(NullEditor nullEditor) {
        return nullEditor._label;
    }

    private class ImageGenerator
    extends ComponentAdapter {
        private int _width;
        private int _height;

        public void componentResized(ComponentEvent e) {
            if (NullEditor.ra$_child(NullEditor.this) == null) {
                return;
            }
            Component c = e.getComponent();
            this._createImage(c);
        }

        private void _createImage(Component c) {
            Rectangle bounds = c.getBounds();
            int width = bounds.width;
            int height = bounds.height;
            if (width != this._width || height != this._height) {
                boolean buffer;
                this._width = width;
                this._height = height;
                Image newImage = c.createImage(width, height);
                Graphics g = newImage.getGraphics();
                g.setClip(bounds.x, bounds.y, width, height);
                g.setColor(c.getBackground());
                g.fillRect(bounds.x, bounds.y, width, height);
                g.setColor(c.getForeground());
                g.setFont(c.getFont());
                NullEditor.ra$_child(NullEditor.this).setBounds(bounds.x, bounds.y, this._width, this._height);
                NullEditor.ra$_child(NullEditor.this).validate();
                JComponent jc = NullEditor.ra$_child(NullEditor.this) instanceof JComponent ? (JComponent)NullEditor.ra$_child(NullEditor.this) : null;
                boolean bl = buffer = jc == null ? false : jc.isDoubleBuffered();
                if (jc != null) {
                    jc.setDoubleBuffered(false);
                }
                if (NullEditor.ra$_child(NullEditor.this) instanceof PropertyEditorRenderer) {
                    ((PropertyEditorRenderer)NullEditor.ra$_child(NullEditor.this)).__getEditor().setValue(NullEditor.ra$_value(NullEditor.this));
                } else if (NullEditor.ra$_child(NullEditor.this) instanceof DisplayValueRenderer) {
                    String s = NullEditor.ra$_value(NullEditor.this) == null ? "" : NullEditor.ra$_value(NullEditor.this).toString();
                    ((DisplayValueRenderer)NullEditor.ra$_child(NullEditor.this)).setText(s);
                }
                NullEditor.ra$_child(NullEditor.this).paint(g);
                if (jc != null) {
                    jc.setDoubleBuffered(buffer);
                }
                ImageIcon old = (ImageIcon)NullEditor.ra$_label(NullEditor.this).getIcon();
                NullEditor.ra$_label(NullEditor.this).setIcon(new ImageIcon(newImage));
                if (old != null) {
                    old.getImage().flush();
                }
            }
        }

        public void init() {
            this._width = -1;
            this._height = -1;
        }

        private void $init$() {
            this._width = -1;
            this._height = -1;
        }

        private ImageGenerator() {
            this.$init$();
        }

        ImageGenerator(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

