/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector.beans;

import java.awt.Color;
import java.awt.Font;
import java.util.Hashtable;
import java.util.Vector;
import oracle.bali.inspector.PropertyGroup;
import oracle.bali.inspector.ResourceBundlePropertyGroup;
import oracle.bali.inspector.beans.BeansGroupProvider;

public class DefaultBeansGroupProvider
implements BeansGroupProvider {
    private static final String _RESOURCE_BUNDLE = "oracle.bali.inspector.resource.InspectorBundle";
    private static final PropertyGroup _GENERAL_CATEGORY = new ResourceBundlePropertyGroup("oracle.bali.inspector.resource.InspectorBundle", "GENERAL");
    private static final PropertyGroup _VISUAL_CATEGORY = new ResourceBundlePropertyGroup("oracle.bali.inspector.resource.InspectorBundle", "VISUAL");
    private Hashtable _nameGroups;
    private Hashtable _classGroups;
    private Hashtable _bothGroups;
    private Vector _groups = new Vector(3);

    public DefaultBeansGroupProvider() {
        this._nameGroups = new Hashtable(2);
        this._classGroups = new Hashtable(3);
        this._bothGroups = new Hashtable(1);
        this.initialize();
    }

    public PropertyGroup[] getGroups() {
        int count = this._groups.size();
        Object[] groups = new PropertyGroup[count];
        if (count != 0) {
            this._groups.copyInto(groups);
        }
        return groups;
    }

    public void addGroup(PropertyGroup group) {
        if (this._groups.indexOf(group) == -1) {
            this._groups.addElement(group);
        }
    }

    public void removeGroup(PropertyGroup group) {
        int index = this._groups.indexOf(group);
        if (index != -1) {
            this._groups.removeElementAt(index);
        }
    }

    public final void registerProperty(String propertyName, PropertyGroup group) {
        this.registerProperty(propertyName, null, group);
    }

    public final void registerProperty(Class propertyClass, PropertyGroup group) {
        this.registerProperty(null, propertyClass, group);
    }

    public void registerProperty(String propertyName, Class propertyClass, PropertyGroup group) {
        block2: {
            block3: {
                block1: {
                    if (this._groups.indexOf(group) == -1) {
                        this.addGroup(group);
                    }
                    if (propertyName == null || propertyClass == null) break block1;
                    String key = this._getKey(propertyName, propertyClass);
                    this._bothGroups.put(key, group);
                    break block2;
                }
                if (propertyName == null) break block3;
                this._nameGroups.put(propertyName, group);
                break block2;
            }
            if (propertyClass == null) break block2;
            this._classGroups.put(propertyClass, group);
        }
    }

    public void unregisterProperty(String propertyName, Class propertyClass) {
        block1: {
            block2: {
                block0: {
                    if (propertyName == null || propertyClass == null) break block0;
                    String key = this._getKey(propertyName, propertyClass);
                    this._bothGroups.remove(key);
                    break block1;
                }
                if (propertyName == null) break block2;
                this._nameGroups.remove(propertyName);
                break block1;
            }
            if (propertyClass == null) break block1;
            this._classGroups.remove(propertyClass);
        }
    }

    public PropertyGroup getGroup(String propertyName, Class propertyType) {
        PropertyGroup group = null;
        String key = this._getKey(propertyName, propertyType);
        if (key != null) {
            group = (PropertyGroup)this._bothGroups.get(key);
        }
        if (group == null && propertyName != null) {
            group = (PropertyGroup)this._nameGroups.get(propertyName);
        }
        if (group == null && propertyType != null) {
            group = (PropertyGroup)this._classGroups.get(propertyType);
        }
        if (group == null) {
            group = _GENERAL_CATEGORY;
        }
        return group;
    }

    protected void initialize() {
        this.addGroup(_GENERAL_CATEGORY);
        this.addGroup(_VISUAL_CATEGORY);
        this.registerProperty(Color.class, _VISUAL_CATEGORY);
        this.registerProperty(Font.class, _VISUAL_CATEGORY);
        this.registerProperty(Boolean.TYPE, _VISUAL_CATEGORY);
    }

    private String _getKey(String propertyName, Class type) {
        String key;
        String string = key = propertyName == null ? "" : propertyName;
        if (type != null) {
            key = key + type.getName();
        }
        return key;
    }
}

