/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector.beans;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import oracle.bali.inspector.beans.AbstractPropertyEditorFactory;

class FieldPropertyEditorFactory
extends AbstractPropertyEditorFactory {
    private Field _field;

    public FieldPropertyEditorFactory(Object target, Field field) {
        super(target);
        if (field == null) {
            throw new IllegalArgumentException();
        }
        this._field = field;
    }

    public Field getField() {
        return this._field;
    }

    public String getDisplayName() {
        return this.getName();
    }

    public String getName() {
        return this.getField().getName();
    }

    public boolean setValue(Object newValue) throws IllegalAccessException, IllegalArgumentException {
        boolean changed = this.getCachedValue() != newValue;
        this.getField().set(this.getTarget(), newValue);
        this.setCachedValue(newValue);
        this.setCachedDisplayValue(AbstractPropertyEditorFactory.INVALID_PROPERTY);
        return changed;
    }

    public Object getValue(Object target) throws IllegalAccessException, IllegalArgumentException {
        Object cachedValue = this.getCachedValue();
        if (cachedValue == AbstractPropertyEditorFactory.INVALID_PROPERTY) {
            cachedValue = this.getField().get(target);
            this.setCachedValue(cachedValue);
        }
        return cachedValue;
    }

    public boolean isReadable() {
        int modifiers = this.getField().getModifiers();
        boolean readable = Modifier.isPublic(modifiers);
        return readable;
    }

    public boolean isWritable() {
        int modifiers = this.getField().getModifiers();
        boolean writable = Modifier.isPublic(modifiers) && !Modifier.isFinal(modifiers);
        return writable;
    }

    public Class getType() {
        return this.getField().getType();
    }

    protected Object createPropertyID() {
        return new Object();
    }
}

