/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector.editor;

import java.awt.Component;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import oracle.bali.inspector.PropertyEditorFactory2;
import oracle.bali.inspector.editor.ComboBoxEditor;
import oracle.bali.inspector.editor.EditorComponentFactory;
import oracle.bali.inspector.editor.EditorComponentSetupRegistry;
import oracle.bali.inspector.editor.PropertyValueApplier;

public final class ComboBoxEditorFactory
extends EditorComponentFactory {
    public boolean canCreateEditorFrom(Object creationInfo) {
        return this.isComboBoxModel(creationInfo) || this.isStringArray(creationInfo);
    }

    private boolean isComboBoxModel(Object creationInfo) {
        return creationInfo instanceof ComboBoxModel;
    }

    private boolean isStringArray(Object creationInfo) {
        if (creationInfo == null) {
            return false;
        }
        Class<?> creationInfoType = creationInfo.getClass();
        if (!creationInfoType.isArray()) {
            return false;
        }
        return String.class.isAssignableFrom(creationInfoType.getComponentType());
    }

    public JComboBox createInlineEditor(PropertyEditorFactory2 propertyEditor) {
        Object initialValue = this.initialValueFrom(propertyEditor);
        if (!this.canCreateEditorFrom(initialValue)) {
            return null;
        }
        if (this.isComboBoxModel(initialValue)) {
            return this.comboBox((ComboBoxModel)initialValue, propertyEditor);
        }
        if (this.isStringArray(initialValue)) {
            return this.comboBox(propertyEditor, (String[])initialValue);
        }
        return null;
    }

    public JComboBox updateInlineEditor(Component current, PropertyEditorFactory2 propertyEditor) {
        Object initialValue = this.initialValueFrom(propertyEditor);
        if (!this.canCreateEditorFrom(initialValue)) {
            return null;
        }
        JComboBox editor = this.editorFrom(current, propertyEditor);
        if (this.isComboBoxModel(initialValue)) {
            return this.comboBox(editor, (ComboBoxModel)initialValue);
        }
        if (this.isStringArray(initialValue)) {
            return this.comboBox(editor, propertyEditor, (String[])initialValue);
        }
        return null;
    }

    private JComboBox editorFrom(Component current, PropertyEditorFactory2 propertyEditor) {
        if (current instanceof JComboBox) {
            return (JComboBox)current;
        }
        return this.comboBox(propertyEditor);
    }

    JComboBox comboBox(ComboBoxModel model, PropertyEditorFactory2 propertyEditor) {
        return this.comboBox(this.comboBox(propertyEditor), model);
    }

    JComboBox comboBox(JComboBox editor, ComboBoxModel model) {
        editor.setModel(model);
        editor.setSelectedItem(model.getSelectedItem());
        return editor;
    }

    JComboBox comboBox(PropertyEditorFactory2 propertyEditor, String[] model) {
        return this.comboBox(this.comboBox(propertyEditor), propertyEditor, model);
    }

    private JComboBox comboBox(JComboBox editor, PropertyEditorFactory2 propertyEditor, String[] model) {
        ComboBoxEditor.setItems(editor, model);
        editor.setSelectedItem(propertyEditor.getAsText());
        return editor;
    }

    private JComboBox comboBox(PropertyEditorFactory2 propertyEditor) {
        PropertyValueApplier applier = propertyEditor.getPropertyValueApplier();
        ComboBoxEditor editor = new ComboBoxEditor();
        EditorComponentSetupRegistry.instance().configure(editor, applier, propertyEditor);
        return editor;
    }
}

