/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector.editor;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import oracle.bali.inspector.InspectorPropertyEditor;
import oracle.bali.inspector.PropertyEditorFactory2;
import oracle.bali.inspector.PropertyEditorFactory2ValueApplier;
import oracle.bali.inspector.editor.ComboBoxEditor;
import oracle.bali.inspector.editor.EditorComponentInfo;
import oracle.bali.inspector.editor.EditorComponentSetup;
import oracle.bali.inspector.editor.EditorFactoryUtils;
import oracle.bali.inspector.editor.PropertyValueApplier;
import oracle.bali.inspector.editor.PropertyValueApplierUtil;
import oracle.bali.inspector.editor.ToStringConverter;

public class ComboBoxEditorSetup
extends EditorComponentSetup {
    public boolean canConfigure(Component inlineEditor) {
        return inlineEditor instanceof JComboBox;
    }

    public void configure(PropertyEditorFactory2 propertyEditor, PropertyValueApplier applier, Component inlineEditor) {
        if (!this.canConfigure(inlineEditor)) {
            return;
        }
        JComboBox editor = (JComboBox)inlineEditor;
        PropertyValueApplierUtil.storePropertyValueApplier(applier, editor);
        this.removeCurrentListeners(editor);
        Listener eventsListener = new Listener(editor, propertyEditor);
        editor.addPopupMenuListener(eventsListener);
        javax.swing.ComboBoxEditor comboBoxEditor = editor.getEditor();
        if (comboBoxEditor != null) {
            comboBoxEditor.addActionListener(eventsListener);
        }
    }

    private void removeCurrentListeners(JComboBox editor) {
        ArrayList<Listener> toRemove = new ArrayList<Listener>();
        PopupMenuListener[] popupMenuListenerArray = editor.getPopupMenuListeners();
        int n = 0;
        while (n < popupMenuListenerArray.length) {
            PopupMenuListener l = popupMenuListenerArray[n];
            if (l instanceof Listener) {
                toRemove.add((Listener)l);
            }
            ++n;
        }
        javax.swing.ComboBoxEditor comboBoxEditor = editor.getEditor();
        for (Listener l : toRemove) {
            editor.removePopupMenuListener(l);
            if (comboBoxEditor == null) continue;
            comboBoxEditor.removeActionListener(l);
        }
    }

    public static class Listener
    implements PopupMenuListener,
    ActionListener {
        JComboBox editor;
        PropertyEditorFactory2 propertyEditor;
        boolean valueApplied;

        Listener(JComboBox editor, PropertyEditorFactory2 propertyEditor) {
            this.editor = editor;
            this.propertyEditor = propertyEditor;
        }

        public void actionPerformed(ActionEvent e) {
            this.valueApplied = false;
            if (!this.editor.isEditable()) {
                return;
            }
            this.applyValue(this.editor.getEditor().getItem());
            this.valueApplied = true;
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent event) {
            if (this.valueApplied) {
                this.valueApplied = false;
                return;
            }
            this.applyValue(this.editor.getSelectedItem());
        }

        private void applyValue(Object selectedItem) {
            ToStringConverter converter = this.converter();
            this.updateToStringConverterInEditor(converter);
            String selectedItemAsText = this.asString(selectedItem, converter);
            PropertyValueApplier applier = PropertyValueApplierUtil.retrievePropertyValueApplier(this.editor);
            if (applier == null) {
                PropertyEditorFactory2ValueApplier.applyValueFromComboBoxEditor(this.propertyEditor, this.editor, converter);
                return;
            }
            int selectedIndex = this.editor.getSelectedIndex();
            String oldValue = this.propertyEditor.getAsText();
            if (oldValue == null && selectedItemAsText != null || oldValue != null && !oldValue.equals(selectedItemAsText)) {
                try {
                    this.propertyEditor.setAsText(selectedItemAsText);
                    applier.apply(this.propertyEditor.getValue());
                }
                catch (Exception e) {
                    try {
                        this.editor.setSelectedIndex(selectedIndex);
                        this.propertyEditor.setAsText(oldValue);
                    }
                    catch (Exception ignored) {
                        // empty catch block
                    }
                    EditorFactoryUtils.showErrorMessage(this.editor.getParent(), e, selectedItemAsText);
                }
            }
        }

        private void updateToStringConverterInEditor(ToStringConverter converter) {
            if (!(this.editor instanceof ComboBoxEditor)) {
                return;
            }
            ComboBoxEditor comboBoxEditor = (ComboBoxEditor)this.editor;
            comboBoxEditor.setToStringConverter(converter);
        }

        private String asString(Object o, ToStringConverter converter) {
            if (converter != null) {
                return converter.convertToString(o);
            }
            return o != null ? o.toString() : null;
        }

        private ToStringConverter converter() {
            EditorComponentInfo info = this.propertyEditor.getEditorComponentInfo();
            if (info == null) {
                return null;
            }
            ToStringConverter converter = info.editorValueToStringConverter();
            if (converter != null) {
                return converter;
            }
            if (this.propertyEditor instanceof InspectorPropertyEditor) {
                InspectorPropertyEditor e = (InspectorPropertyEditor)this.propertyEditor;
                return e.getSelectedItemToStringConverter();
            }
            return null;
        }

        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }
    }
}

