/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector.editor;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import oracle.bali.inspector.PropertyEditorFactory2;
import oracle.bali.inspector.editor.ComboBoxEditorFactory;
import oracle.bali.inspector.editor.EditorComponentFactory;
import oracle.bali.inspector.editor.EditorComponentInfo;
import oracle.bali.inspector.editor.MappedEditorFactory;
import oracle.bali.inspector.editor.PaintableEditorComponent;
import oracle.bali.inspector.editor.ReadOnlyEditorComponent;
import oracle.bali.inspector.editor.TextFieldEditorFactory;

public final class EditorComponentFactoryRegistry {
    private final List<EditorComponentFactory> registry;
    private final ComboBoxEditorFactory comboBoxEditorFactory;
    private final TextFieldEditorFactory textFieldEditorFactory;
    private EditorComponentFactory defaultEditorFactory;

    private void $init$() {
        this.registry = new ArrayList<EditorComponentFactory>();
        this.comboBoxEditorFactory = new ComboBoxEditorFactory();
        this.textFieldEditorFactory = new TextFieldEditorFactory();
        this.defaultEditorFactory = null;
    }

    public EditorComponentFactory defaultFactory() {
        return this.defaultEditorFactory != null ? this.defaultEditorFactory : this.textFieldEditorFactory;
    }

    TextFieldEditorFactory textFieldEditorFactory() {
        return this.textFieldEditorFactory;
    }

    ComboBoxEditorFactory comboBoxEditorFactory() {
        return this.comboBoxEditorFactory;
    }

    public void addDefaultEditorFactory(EditorComponentFactory factory) {
        this.defaultEditorFactory = factory;
    }

    public void register(EditorComponentFactory factory) {
        if (this.registry.contains(factory)) {
            return;
        }
        this.registry.add(0, factory);
    }

    public Component createInlineEditor(PropertyEditorFactory2 propertyEditor) {
        EditorComponentInfo editorComponentInfo = propertyEditor.getEditorComponentInfo();
        if (editorComponentInfo == null) {
            return this.fromDefaultFactory(propertyEditor);
        }
        EditorComponentFactory factory = this.factoryFor(editorComponentInfo.initialValue());
        if (factory == null) {
            return this.fromDefaultFactory(propertyEditor);
        }
        return factory.createInlineEditor(propertyEditor);
    }

    public Component updateInlineEditor(Component current, PropertyEditorFactory2 propertyEditor) {
        EditorComponentInfo editorComponentInfo = propertyEditor.getEditorComponentInfo();
        if (editorComponentInfo == null) {
            return this.fromDefaultFactory(propertyEditor);
        }
        EditorComponentFactory factory = this.factoryFor(editorComponentInfo.initialValue());
        if (factory == null) {
            return this.fromDefaultFactory(propertyEditor);
        }
        return factory.updateInlineEditor(current, propertyEditor);
    }

    private Component fromDefaultFactory(PropertyEditorFactory2 propertyEditor) {
        return this.defaultFactory().createInlineEditor(propertyEditor);
    }

    public Component createPaintableEditor(PropertyEditorFactory2 propertyEditor, boolean writable) {
        return new PaintableEditorComponent(propertyEditor, writable);
    }

    public Component updatePaintableEditor(Component currentEditor, PropertyEditorFactory2 propertyEditor, boolean writable) {
        if (currentEditor instanceof PaintableEditorComponent) {
            PaintableEditorComponent editor = (PaintableEditorComponent)currentEditor;
            editor.update(propertyEditor);
            return editor;
        }
        return this.createPaintableEditor(propertyEditor, writable);
    }

    public Component createReadOnlyEditor(PropertyEditorFactory2 propertyEditor) {
        return new ReadOnlyEditorComponent(propertyEditor.getAsText());
    }

    private EditorComponentFactory factoryFor(Object initialValue) {
        for (EditorComponentFactory factory : this.registry) {
            if (!factory.canCreateEditorFrom(initialValue)) continue;
            return factory;
        }
        return null;
    }

    public static EditorComponentFactoryRegistry instance() {
        return EditorComponentFactoryRegistrySingleton.instance;
    }

    private EditorComponentFactoryRegistry() {
        this.$init$();
        this.register(new MappedEditorFactory());
        this.register(this.comboBoxEditorFactory());
    }

    public void unregisterAllEditorFactories() {
        this.registry.clear();
    }

    public EditorComponentFactory[] getArrayCopyOfEditorFactories() {
        return this.registry.toArray(new EditorComponentFactory[this.registry.size()]);
    }

    EditorComponentFactoryRegistry(1 var1_1) {
        this();
    }

    private static class EditorComponentFactoryRegistrySingleton {
        static EditorComponentFactoryRegistry instance = new EditorComponentFactoryRegistry(null);

        private EditorComponentFactoryRegistrySingleton() {
        }
    }

    public final class 1 {
    }
}

