/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector.editor;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import oracle.bali.inspector.PropertyEditorFactory2;
import oracle.bali.inspector.editor.ComboBoxEditorSetup;
import oracle.bali.inspector.editor.EditorComponentSetup;
import oracle.bali.inspector.editor.PropertyValueApplier;
import oracle.bali.inspector.editor.TextFieldEditorSetup;

public class EditorComponentSetupRegistry {
    private final List<EditorComponentSetup> registry;

    private void $init$() {
        this.registry = new ArrayList<EditorComponentSetup>();
    }

    public void register(EditorComponentSetup setup) {
        if (this.registry.contains(setup)) {
            return;
        }
        this.registry.add(0, setup);
    }

    public boolean configure(Component editor, PropertyValueApplier applier, PropertyEditorFactory2 propertyEditor) {
        for (EditorComponentSetup setup : this.registry) {
            if (!setup.canConfigure(editor)) continue;
            setup.configure(propertyEditor, applier, editor);
            return true;
        }
        return false;
    }

    public static EditorComponentSetupRegistry instance() {
        return SingletonHolder.instance;
    }

    private EditorComponentSetupRegistry() {
        this.$init$();
        this.register(new ComboBoxEditorSetup());
        this.register(new TextFieldEditorSetup());
    }

    EditorComponentSetupRegistry(1 var1_1) {
        this();
    }

    private static class SingletonHolder {
        static EditorComponentSetupRegistry instance = new EditorComponentSetupRegistry(null);

        private SingletonHolder() {
        }
    }

    public final class 1 {
    }
}

