/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector.editor;

import java.awt.Component;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import oracle.bali.inspector.PropertyEditorFactory2;
import oracle.bali.inspector.editor.ComboBoxEditorFactory;
import oracle.bali.inspector.editor.EditorComponentFactory;
import oracle.bali.inspector.editor.EditorComponentFactoryRegistry;
import oracle.bali.inspector.editor.MappedEditorFactoryInfo;
import oracle.bali.inspector.editor.TextFieldEditorFactory;

public final class MappedEditorFactory
extends EditorComponentFactory {
    public boolean canCreateEditorFrom(Object initialValue) {
        return this.isMappedEditorFactoryInfo(initialValue);
    }

    public Component createInlineEditor(PropertyEditorFactory2 propertyEditor) {
        Object initialValue = this.initialValueFrom(propertyEditor);
        if (!this.isMappedEditorFactoryInfo(initialValue)) {
            return null;
        }
        MappedEditorFactoryInfo targetInfo = (MappedEditorFactoryInfo)initialValue;
        JComboBox editor = this.comboBoxEditor(targetInfo, propertyEditor);
        if (editor != null) {
            return editor;
        }
        if (MappedEditorFactoryInfo.EditorType.TEXT_FIELD.equals((Object)targetInfo.editorType()) || targetInfo.editorType() == null) {
            return this.textFieldEditor(targetInfo);
        }
        return null;
    }

    public Component updateInlineEditor(Component current, PropertyEditorFactory2 propertyEditor) {
        Object initialValue = this.initialValueFrom(propertyEditor);
        if (!this.isMappedEditorFactoryInfo(initialValue)) {
            return null;
        }
        MappedEditorFactoryInfo targetInfo = (MappedEditorFactoryInfo)initialValue;
        JComboBox editor = this.comboBoxEditor(current, targetInfo, propertyEditor);
        if (editor != null) {
            return editor;
        }
        if (MappedEditorFactoryInfo.EditorType.TEXT_FIELD.equals((Object)targetInfo.editorType()) || targetInfo.editorType() == null) {
            return this.textFieldEditor(current, targetInfo);
        }
        return null;
    }

    private boolean isMappedEditorFactoryInfo(Object initialValue) {
        return initialValue instanceof MappedEditorFactoryInfo;
    }

    private JComboBox comboBoxEditor(Component current, MappedEditorFactoryInfo targetInfo, PropertyEditorFactory2 propertyEditor) {
        ComboBoxModel model = this.comboBoxModelFrom(targetInfo);
        if (model == null) {
            return null;
        }
        JComboBox comboBox = null;
        if (current instanceof JComboBox) {
            comboBox = (JComboBox)current;
            return this.comboBoxEditorFactory().comboBox(comboBox, model);
        }
        return this.comboBoxEditor(model, targetInfo, propertyEditor);
    }

    private JComboBox comboBoxEditor(MappedEditorFactoryInfo targetInfo, PropertyEditorFactory2 propertyEditor) {
        ComboBoxModel model = this.comboBoxModelFrom(targetInfo);
        if (model == null) {
            return null;
        }
        return this.comboBoxEditor(model, targetInfo, propertyEditor);
    }

    private JComboBox comboBoxEditor(ComboBoxModel model, MappedEditorFactoryInfo targetInfo, PropertyEditorFactory2 propertyEditor) {
        JComboBox comboBox = this.comboBoxEditorFactory().comboBox(model, propertyEditor);
        if (comboBox == null) {
            return null;
        }
        this.setComboBoxRenderer(comboBox, targetInfo);
        this.setEditable(comboBox, targetInfo);
        return comboBox;
    }

    private ComboBoxEditorFactory comboBoxEditorFactory() {
        return EditorComponentFactoryRegistry.instance().comboBoxEditorFactory();
    }

    private ComboBoxModel comboBoxModelFrom(MappedEditorFactoryInfo targetInfo) {
        if (targetInfo.editorType() != null && !MappedEditorFactoryInfo.EditorType.COMBO_BOX.equals((Object)targetInfo.editorType())) {
            return null;
        }
        Object model = targetInfo.property(MappedEditorFactoryInfo.PropertyName.MODEL);
        if (model instanceof ComboBoxModel) {
            return (ComboBoxModel)model;
        }
        return null;
    }

    private void setComboBoxRenderer(JComboBox comboBox, MappedEditorFactoryInfo targetInfo) {
        Object renderer = targetInfo.property(MappedEditorFactoryInfo.PropertyName.RENDERER);
        if (renderer instanceof ListCellRenderer) {
            comboBox.setRenderer((ListCellRenderer)renderer);
        }
    }

    private void setEditable(JComboBox comboBox, MappedEditorFactoryInfo targetInfo) {
        Object editable = targetInfo.property(MappedEditorFactoryInfo.PropertyName.EDITABLE);
        if (editable instanceof Boolean) {
            comboBox.setEditable((Boolean)editable);
        }
    }

    private JTextField textFieldEditor(Component current, MappedEditorFactoryInfo targetInfo) {
        Object text = targetInfo.property(MappedEditorFactoryInfo.PropertyName.TEXT);
        if (text != null && !(text instanceof String)) {
            return null;
        }
        if (current instanceof JTextField) {
            JTextField textField = (JTextField)current;
            return this.textFieldEditorFactory().textField(textField, (String)text);
        }
        return this.textFieldEditorFactory().textField((String)text);
    }

    private JTextField textFieldEditor(MappedEditorFactoryInfo targetInfo) {
        Object text = targetInfo.property(MappedEditorFactoryInfo.PropertyName.TEXT);
        if (text == null || text instanceof String) {
            return this.textFieldEditorFactory().textField((String)text);
        }
        return null;
    }

    private TextFieldEditorFactory textFieldEditorFactory() {
        return EditorComponentFactoryRegistry.instance().textFieldEditorFactory();
    }
}

