/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JTextField;
import oracle.bali.inspector.PropertyEditorFactory2;

public final class PaintableEditorComponent
extends JComponent {
    private final PaintableField textField;

    public PaintableEditorComponent(PropertyEditorFactory2 propertyEditor, boolean writable) {
        this.textField = new PaintableField(propertyEditor, writable);
        this.setLayout(new BorderLayout());
        this.add((Component)this.textField, "Center");
    }

    public void update(PropertyEditorFactory2 propertyEditor) {
        this.textField.update(propertyEditor);
    }

    private static final class PaintableField
    extends JTextField {
        private PropertyEditorFactory2 propertyEditor;
        static final /* synthetic */ boolean $assertionsDisabled;

        PaintableField(PropertyEditorFactory2 propertyEditor, boolean writable) {
            this.update(propertyEditor);
            this.setFocusable(false);
            this.setEditable(writable);
            this.setCursor(Cursor.getDefaultCursor());
        }

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Insets insets = this.getInsets();
            int width = this.getWidth() - insets.left - insets.right;
            int height = this.getHeight() - insets.top - insets.bottom;
            Rectangle box = new Rectangle(insets.left, insets.top, width, height);
            this.propertyEditor.paintValue(g, box);
        }

        static {
            $assertionsDisabled = PaintableField.class.desiredAssertionStatus() ^ true;
        }

        void update(PropertyEditorFactory2 propertyEditor) {
            if (!($assertionsDisabled || propertyEditor != null && propertyEditor.isPaintable())) {
                throw new AssertionError();
            }
            this.propertyEditor = propertyEditor;
        }
    }
}

