/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector.editor;

import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import oracle.bali.inspector.editor.PropertyValueApplier;

public class TextFieldEditor
extends JTextField {
    private boolean dirty;
    private PropertyValueApplier propertyValueApplier;

    public TextFieldEditor() {
        this.addMarkDirtyListener();
    }

    public TextFieldEditor(Document doc, String text, int columns) {
        super(doc, text, columns);
        this.addMarkDirtyListener();
    }

    public TextFieldEditor(String text, int columns) {
        super(text, columns);
        this.addMarkDirtyListener();
    }

    public TextFieldEditor(String text) {
        super(text);
        this.addMarkDirtyListener();
    }

    public TextFieldEditor(int columns) {
        super(columns);
        this.addMarkDirtyListener();
    }

    public final void setDirty(boolean newdirty) {
        this.dirty = newdirty;
    }

    public final boolean isDirty() {
        return this.dirty;
    }

    public void setText(String t) {
        String realText = TextFieldEditor.cleanNullText(t);
        super.setText(realText);
        this.setDirty(false);
    }

    public static String cleanNullText(String s) {
        return s == null || "null".equals(s) ? "" : s;
    }

    private void addMarkDirtyListener() {
        this.getDocument().addDocumentListener(new 1());
    }

    public void setPropertyValueApplier(PropertyValueApplier newpropertyValueApplier) {
        this.propertyValueApplier = newpropertyValueApplier;
    }

    public PropertyValueApplier getPropertyValueApplier() {
        return this.propertyValueApplier;
    }

    final class 1
    implements DocumentListener {
        public void insertUpdate(DocumentEvent e) {
            this.markEditorAsDirty();
        }

        public void removeUpdate(DocumentEvent e) {
            this.markEditorAsDirty();
        }

        public void changedUpdate(DocumentEvent e) {
            this.markEditorAsDirty();
        }

        private void markEditorAsDirty() {
            TextFieldEditor.this.setDirty(true);
        }
    }
}

