/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector.editor;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import oracle.bali.inspector.PropertyEditorFactory2;
import oracle.bali.inspector.PropertyEditorFactory2ValueApplier;
import oracle.bali.inspector.editor.EditorComponentSetup;
import oracle.bali.inspector.editor.EditorFactoryUtils;
import oracle.bali.inspector.editor.PropertyModelValueApplier;
import oracle.bali.inspector.editor.PropertyValueApplier;
import oracle.bali.inspector.editor.PropertyValueApplierUtil;
import oracle.bali.inspector.editor.TextFieldEditor;

public class TextFieldEditorSetup
extends EditorComponentSetup {
    public boolean canConfigure(Component inlineEditor) {
        return inlineEditor instanceof JTextComponent;
    }

    public void configure(PropertyEditorFactory2 propertyEditor, PropertyValueApplier applier, Component inlineEditor) {
        if (!this.canConfigure(inlineEditor)) {
            return;
        }
        JTextComponent editor = (JTextComponent)inlineEditor;
        PropertyValueApplierUtil.storePropertyValueApplier(applier, editor);
        this.removeCurrentListeners(editor);
        this.addPropertyInspectorListeners(propertyEditor, editor);
    }

    private void addPropertyInspectorListeners(PropertyEditorFactory2 propertyEditor, JTextComponent editor) {
        ApplyValueListener listener = new ApplyValueListener(editor, propertyEditor);
        if (editor instanceof JTextField) {
            ((JTextField)editor).addActionListener(listener);
        }
        editor.addFocusListener(listener);
        editor.addKeyListener(listener);
        editor.addKeyListener(new MarkDirtyListener(editor));
    }

    private void removeCurrentListeners(JTextComponent editor) {
        ArrayList<ApplyValueListener> applyValueListeners = new ArrayList<ApplyValueListener>();
        ArrayList<MarkDirtyListener> markDirtyListeners = new ArrayList<MarkDirtyListener>();
        KeyListener[] keyListenerArray = editor.getKeyListeners();
        int n = 0;
        while (n < keyListenerArray.length) {
            KeyListener l = keyListenerArray[n];
            if (l instanceof ApplyValueListener) {
                applyValueListeners.add((ApplyValueListener)l);
            } else if (l instanceof MarkDirtyListener) {
                markDirtyListeners.add((MarkDirtyListener)l);
            }
            ++n;
        }
        if (applyValueListeners.isEmpty() && markDirtyListeners.isEmpty()) {
            return;
        }
        for (ApplyValueListener l : applyValueListeners) {
            editor.removeFocusListener(l);
            editor.removeKeyListener(l);
            if (!(editor instanceof JTextField)) continue;
            ((JTextField)editor).removeActionListener(l);
        }
        for (MarkDirtyListener l : markDirtyListeners) {
            editor.removeKeyListener(l);
        }
    }

    static class MarkDirtyListener
    extends KeyAdapter {
        private JTextComponent editor;
        private static final String KEY = MarkDirtyListener.class.getName();

        MarkDirtyListener(JTextComponent editor) {
            this.editor = editor;
            this.setDirty(false);
        }

        public void keyTyped(KeyEvent e) {
            this.markEditorAsDirty();
        }

        private void markEditorAsDirty() {
            this.setDirty(true);
        }

        private void setDirty(boolean val) {
            this.editor.putClientProperty(KEY, val);
        }

        static boolean isDirty(JTextComponent editor) {
            Object val = editor.getClientProperty(KEY);
            if (val instanceof Boolean) {
                return (Boolean)val;
            }
            return true;
        }
    }

    static class ApplyValueListener
    extends KeyAdapter
    implements ActionListener,
    FocusListener {
        JTextComponent editor;
        PropertyEditorFactory2 propertyEditor;

        ApplyValueListener(JTextComponent editor, PropertyEditorFactory2 propertyEditor) {
            this.editor = editor;
            this.propertyEditor = propertyEditor;
        }

        public void actionPerformed(ActionEvent e) {
            this.applyValueFromEditor();
        }

        public void focusLost(FocusEvent e) {
            if (e.isTemporary()) {
                return;
            }
            this.applyValueFromEditor();
        }

        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() != 27) {
                return;
            }
            String oldText = this.propertyEditor.getAsText();
            this.editor.setText(oldText);
        }

        private void applyValueFromEditor() {
            if (!this.isDirty()) {
                return;
            }
            PropertyValueApplier applier = PropertyValueApplierUtil.retrievePropertyValueApplier(this.editor);
            if (applier == null) {
                PropertyEditorFactory2ValueApplier.applyValueFromTextComponentEditor(this.propertyEditor, this.editor);
                return;
            }
            String newValue = TextFieldEditor.cleanNullText(this.editor.getText());
            String oldValue = this.propertyEditor.getAsText();
            if (ApplyValueListener.isEmpty(newValue) && ApplyValueListener.isEmpty(oldValue)) {
                return;
            }
            if (newValue.equals(oldValue)) {
                return;
            }
            try {
                try {
                    this.propertyEditor.setAsText(newValue);
                    applier.apply(this.propertyEditor.getValue());
                }
                catch (Exception ex) {
                    try {
                        this.editor.setText(oldValue);
                        this.propertyEditor.setAsText(oldValue);
                    }
                    catch (Exception ignored) {
                        // empty catch block
                    }
                    EditorFactoryUtils.showErrorMessage(this.editor.getParent(), ex, newValue);
                }
            }
            finally {
                if (!(applier instanceof PropertyModelValueApplier)) {
                    return;
                }
                Object value = ((PropertyModelValueApplier)applier).value();
                this.propertyEditor.setValue(value);
                this.editor.setText(TextFieldEditor.cleanNullText(this.propertyEditor.getAsText()));
            }
        }

        private boolean isDirty() {
            if (this.editor instanceof TextFieldEditor) {
                return ((TextFieldEditor)this.editor).isDirty();
            }
            return MarkDirtyListener.isDirty(this.editor);
        }

        private static boolean isEmpty(String s) {
            return s == null || s.length() == 0;
        }

        public void focusGained(FocusEvent e) {
        }
    }
}

