/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector.editors;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyEditorSupport;
import java.util.Locale;
import javax.swing.DefaultCellEditor;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import oracle.bali.inspector.PropertyEditorFactory;
import oracle.bali.inspector.editors.CharField;

public class CharEditor
extends PropertyEditorSupport
implements PropertyEditorFactory {
    private TableCellRenderer _renderer;
    private TableCellEditor _cellEditor;

    public String getJavaInitializationString() {
        return "" + this.getValue();
    }

    public void setValue(Object newCharacter) {
        super.setValue((Character)newCharacter);
    }

    public void setAsText(String text) throws IllegalArgumentException {
        this.setValue(this._setAsText(text));
    }

    private Character _setAsText(String text) {
        int textLen;
        int n = textLen = text != null ? text.length() : 0;
        if (textLen != 0) {
            if (textLen == 1) {
                return new Character(text.charAt(0));
            }
            if (textLen > 2 && text.charAt(0) == '0' && (text.charAt(1) == 'x' || text.charAt(1) == 'X')) {
                try {
                    int charValue = Integer.valueOf(text.substring(2), 16);
                    if (charValue <= 65535 && charValue >= 0) {
                        Character c = new Character((char)charValue);
                        return c;
                    }
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            throw new IllegalArgumentException();
        }
        return null;
    }

    public Object getEditorValue() {
        return this.getValue();
    }

    public void setEditorValue(Object value) {
        this.setValue(value);
    }

    public boolean hasValueRenderer() {
        return true;
    }

    public TableCellRenderer getValueRenderer() {
        if (this._renderer == null) {
            this._renderer = new ValueRenderer(null);
        }
        return this._renderer;
    }

    public boolean hasInPlaceEditor() {
        return true;
    }

    public TableCellEditor getInPlaceEditor(Locale editorLocale) {
        if (this._cellEditor == null) {
            this._cellEditor = new CharCellEditor();
        }
        return this._cellEditor;
    }

    public boolean hasTearOffEditor() {
        return false;
    }

    public Component getTearOffEditor() {
        return null;
    }

    public boolean hasAdvancedEditor() {
        return false;
    }

    public Component getAdvancedEditor() {
        return null;
    }

    private class CharCellEditor
    extends DefaultCellEditor {
        public CharCellEditor() {
            super(new CharField());
        }

        public Object getCellEditorValue() {
            String s = (String)super.getCellEditorValue();
            if (s == null || s.length() == 0) {
                return null;
            }
            return new Character(s.charAt(0));
        }
    }

    private class ValueRenderer
    extends DefaultTableCellRenderer {
        public void paintComponent(Graphics g) {
            Rectangle r = this.getBounds();
            r.x = 0;
            r.y = 0;
            Color c = g.getColor();
            g.setColor(this.getBackground());
            g.fillRect(r.x, r.y, r.width, r.height);
            g.setColor(c);
            super.paintComponent(g);
        }

        private ValueRenderer() {
        }

        ValueRenderer(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

