/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector.editors;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorSupport;
import java.util.Locale;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import oracle.bali.ewt.chooser.color.ColorChoice;
import oracle.bali.ewt.chooser.color.ColorGrid;
import oracle.bali.ewt.chooser.color.ColorPalettePane;
import oracle.bali.inspector.ExtendedPropertyEditor;
import oracle.bali.inspector.PropertyEditorFactory;
import oracle.bali.inspector.editors.ColorTableCellEditor;

public class ColorEditor
extends PropertyEditorSupport
implements ExtendedPropertyEditor,
PropertyEditorFactory {
    private static final int _PAINT_INSETS = 3;
    private static final Border _sBORDER = new EmptyBorder(8, 8, 8, 8);
    private Listener _listener;
    private TableCellRenderer _renderer;
    private ColorPalettePane _colorPalettePane;
    private JPanel _customEditor;
    private ColorGrid _tearOffEditor;
    private ColorTableCellEditor _cellEditor;

    public void setValue(Object newValue) {
        Color newColor = (Color)newValue;
        super.setValue(newColor);
        if (this._colorPalettePane != null) {
            this._colorPalettePane.setSelectedColor(newColor);
        }
        if (this._tearOffEditor != null) {
            try {
                this._tearOffEditor.setSelectedColor(newColor);
            }
            catch (IllegalArgumentException iae) {
                this._tearOffEditor.setSelectedColor(null);
            }
        }
    }

    public boolean isPaintable() {
        return true;
    }

    public final void paintValue(Graphics g, Rectangle paintBounds) {
        this.paintValue(this.getValue(), g, Locale.getDefault(), paintBounds.x, paintBounds.y, paintBounds.width, paintBounds.height);
    }

    public String getJavaInitializationString() {
        return "new java.awt.Color(" + this.getAsText() + ")";
    }

    public final String getAsText() {
        return null;
    }

    public final void setAsText(String text) throws IllegalArgumentException {
    }

    public Component getCustomEditor() {
        if (this._customEditor == null) {
            ColorPalettePane pane = new ColorPalettePane();
            pane.setColorNameVisible(false);
            if (this._listener == null) {
                this._listener = new Listener(null);
            }
            pane.addPropertyChangeListener((PropertyChangeListener)this._listener);
            this._colorPalettePane = pane;
            JPanel customEditor = new JPanel(new BorderLayout());
            customEditor.setBorder(_sBORDER);
            customEditor.add("Center", (Component)pane);
            this._customEditor = customEditor;
        }
        return this._customEditor;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Object textToValue(String text, Locale locale) throws IllegalArgumentException {
        return null;
    }

    public String valueToText(Object value, Locale locale) {
        return "null";
    }

    public void paintValue(Object value, Graphics g, Locale locale, int x, int y, int width, int height) {
        Color savedColor = g.getColor();
        Color currColor = (Color)value;
        g.setColor(Color.black);
        if (width > 20) {
            width = 20;
        }
        g.drawRect(x += 3, y += 3, width -= 6, height -= 6);
        g.setColor(currColor);
        g.fillRect(x + 1, y + 1, width - 1, height - 1);
        g.setColor(savedColor);
    }

    public boolean supportsSmallCustomEditor() {
        return true;
    }

    public Component getSmallCustomEditor() {
        if (this._tearOffEditor == null) {
            ColorGrid grid = new ColorGrid();
            if (this._listener == null) {
                this._listener = new Listener(null);
            }
            grid.addPropertyChangeListener((PropertyChangeListener)this._listener);
            this._tearOffEditor = grid;
        }
        return this._tearOffEditor;
    }

    public Object getEditorValue() {
        return this.getValue();
    }

    public void setEditorValue(Object value) {
        this.setValue(value);
    }

    public boolean hasValueRenderer() {
        return true;
    }

    public TableCellRenderer getValueRenderer() {
        if (this._renderer == null) {
            this._renderer = new ValueRenderer(null);
        }
        return this._renderer;
    }

    public boolean hasInPlaceEditor() {
        return true;
    }

    public TableCellEditor getInPlaceEditor(Locale editorLocale) {
        if (this._cellEditor == null) {
            this._cellEditor = new ColorTableCellEditor();
        }
        return this._cellEditor;
    }

    public boolean hasTearOffEditor() {
        return this.supportsSmallCustomEditor();
    }

    public Component getTearOffEditor() {
        return this.getSmallCustomEditor();
    }

    public boolean hasAdvancedEditor() {
        return this.supportsCustomEditor();
    }

    public Component getAdvancedEditor() {
        return this.getCustomEditor();
    }

    public ColorGrid getColorGrid() {
        Component dummy = this.getTearOffEditor();
        return this._tearOffEditor;
    }

    public ColorPalettePane getColorPalettePane() {
        Component dummy = this.getAdvancedEditor();
        return this._colorPalettePane;
    }

    public ColorChoice getColorChoice() {
        TableCellEditor dummy = this.getInPlaceEditor(Locale.getDefault());
        return this._cellEditor.getColorChoice();
    }

    private void _setValue(Object newValue) {
        super.setValue(newValue);
    }

    static ColorPalettePane ra$_colorPalettePane(ColorEditor colorEditor) {
        return colorEditor._colorPalettePane;
    }

    static ColorGrid ra$_tearOffEditor(ColorEditor colorEditor) {
        return colorEditor._tearOffEditor;
    }

    static void mav$_setValue(ColorEditor colorEditor, Object object) {
        colorEditor._setValue(object);
    }

    private class Listener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent e) {
            Color newValue = null;
            String name = e.getPropertyName();
            if (e.getSource() == ColorEditor.ra$_colorPalettePane(ColorEditor.this)) {
                newValue = ColorEditor.ra$_colorPalettePane(ColorEditor.this).getSelectedColor();
            } else if (e.getSource() == ColorEditor.ra$_tearOffEditor(ColorEditor.this)) {
                newValue = ColorEditor.ra$_tearOffEditor(ColorEditor.this).getSelectedColor();
            }
            ColorEditor.mav$_setValue(ColorEditor.this, newValue);
        }

        private Listener() {
        }

        Listener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class ValueRenderer
    extends DefaultTableCellRenderer {
        public void paintComponent(Graphics g) {
            this.setValue(null);
            Rectangle r = this.getBounds();
            r.x = 0;
            r.y = 0;
            Color c = g.getColor();
            g.setColor(this.getBackground());
            g.fillRect(r.x, r.y, r.width, r.height);
            g.setColor(c);
            super.paintComponent(g);
            ColorEditor.this.paintValue(g, r);
        }

        private ValueRenderer() {
        }

        ValueRenderer(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

